/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.model.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.model.animation.AnimatedEntityModel;
import cn.leolezury.eternalstarlight.common.entity.living.monster.TinyCreteor;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TinyCreteorModel<T extends TinyCreteor>
extends AnimatedEntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(EternalStarlight.id("tiny_creteor"), "main");
    public static final ModelLayerLocation ARMOR_LOCATION = new ModelLayerLocation(EternalStarlight.id("tiny_creteor"), "armor");
    private final ModelPart root;
    private final ModelPart rotator;

    public TinyCreteorModel(ModelPart root) {
        this.root = root.getChild("root");
        this.rotator = root.getChild("root").getChild("rotator");
    }

    public static LayerDefinition createBodyLayer(CubeDeformation deformation) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)20.0f, (float)0.0f));
        PartDefinition rotator = root.addOrReplaceChild("rotator", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, deformation), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        rotator.addOrReplaceChild("crystal1", CubeListBuilder.create().texOffs(33, 8).addBox(-4.0f, -4.0f, 0.0f, 6.0f, 6.0f, 0.0f, deformation), PartPose.offset((float)-4.0f, (float)-4.0f, (float)0.5f));
        rotator.addOrReplaceChild("crystal2", CubeListBuilder.create().texOffs(1, 26).addBox(-2.5f, -6.0f, 0.0f, 5.0f, 6.0f, 0.0f, deformation), PartPose.offsetAndRotation((float)-4.0f, (float)1.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f));
        rotator.addOrReplaceChild("crystal3", CubeListBuilder.create().texOffs(1, 26).mirror().addBox(-2.5f, -6.0f, 0.0f, 5.0f, 6.0f, 0.0f, deformation).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-3.1416f));
        rotator.addOrReplaceChild("crystal4", CubeListBuilder.create().texOffs(1, 17).mirror().addBox(0.0f, -8.0f, 0.0f, 4.0f, 8.0f, 0.0f, deformation).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        rotator.addOrReplaceChild("crystal5", CubeListBuilder.create().texOffs(33, 15).addBox(0.0f, -2.5f, 0.0f, 5.0f, 5.0f, 0.0f, deformation), PartPose.offset((float)4.0f, (float)0.5f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.rotator.zRot = -Mth.rotLerp((float)Mth.frac((float)ageInTicks), (float)((TinyCreteor)((Object)entity)).prevRollAngle, (float)((TinyCreteor)((Object)entity)).rollAngle) * ((float)Math.PI / 180);
        this.root.xRot = headPitch * ((float)Math.PI / 180);
        this.root.yRot = netHeadYaw * ((float)Math.PI / 180);
    }

    @Override
    public ModelPart root() {
        return this.root;
    }
}

