/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.gui.toast;

import cn.leolezury.eternalstarlight.common.registry.ESItems;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BookUnlockToast
implements Toast {
    private static final ResourceLocation BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"toast/advancement");
    private final Component chapterName;

    public BookUnlockToast(Component chapterName) {
        this.chapterName = chapterName;
    }

    public Toast.Visibility render(GuiGraphics graphics, ToastComponent component, long timeSinceLastVisible) {
        graphics.blitSprite(BACKGROUND_SPRITE, 0, 0, this.width(), this.height());
        List list = component.getMinecraft().font.split((FormattedText)this.chapterName, 125);
        if (list.size() == 1) {
            graphics.drawString(component.getMinecraft().font, (Component)Component.translatable((String)"book.eternal_starlight.unlock"), 30, 7, -256, false);
            graphics.drawString(component.getMinecraft().font, (FormattedCharSequence)list.getFirst(), 30, 18, -1, false);
        } else if (timeSinceLastVisible < 1500L) {
            int color = Mth.floor((float)(Mth.clamp((float)((float)(1500L - timeSinceLastVisible) / 300.0f), (float)0.0f, (float)1.0f) * 255.0f)) << 24 | 0x4000000;
            graphics.drawString(component.getMinecraft().font, (Component)Component.translatable((String)"book.eternal_starlight.unlock"), 30, 11, 0xFFFF00 | color, false);
        } else {
            int color = Mth.floor((float)(Mth.clamp((float)((float)(timeSinceLastVisible - 1500L) / 300.0f), (float)0.0f, (float)1.0f) * 252.0f)) << 24 | 0x4000000;
            Objects.requireNonNull(component.getMinecraft().font);
            int yPos = this.height() / 2 - list.size() * 9 / 2;
            for (FormattedCharSequence formattedCharSequence : list) {
                graphics.drawString(component.getMinecraft().font, formattedCharSequence, 30, yPos, 0xFFFFFF | color, false);
                Objects.requireNonNull(component.getMinecraft().font);
                yPos += 9;
            }
        }
        graphics.renderFakeItem(ESItems.BOOK.get().getDefaultInstance(), 8, 8);
        return (double)timeSinceLastVisible >= 5000.0 * component.getNotificationDisplayTimeMultiplier() ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }
}

