/*
 * Decompiled with CFR 0.152.
 */
package fuzs.hangglider.world.wind;

import fuzs.hangglider.HangGlider;
import fuzs.hangglider.config.ServerConfig;
import fuzs.hangglider.helper.PlayerGlidingHelper;
import fuzs.hangglider.world.wind.generator.OpenSimplexNoise;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class WindHelper {
    private static final OpenSimplexNoise NOISE_GENERATOR = new OpenSimplexNoise();

    public static void applyWind(Player player, ItemStack itemStack) {
        ServerConfig config = (ServerConfig)HangGlider.CONFIG.get(ServerConfig.class);
        if (!config.wind.allowWind) {
            return;
        }
        double windGustSize = config.wind.gustSize;
        double windFrequency = config.wind.frequency;
        double windRainingMultiplier = config.wind.rainingMultiplier;
        double windSpeedMultiplier = config.wind.speedMultiplier;
        double windHeightMultiplier = config.wind.heightMultiplier;
        double windOverallPower = config.wind.overallPower;
        double noise = NOISE_GENERATOR.eval(player.getX() / windGustSize, player.getZ() / windGustSize);
        double d = player.level().isRaining() ? windRainingMultiplier * windFrequency : windFrequency;
        double velocity = Math.sqrt(Math.pow(player.getDeltaMovement().x, 2.0) + Math.pow(player.getDeltaMovement().z, 2.0));
        double speedStabilized = (noise *= d) * 1.0 / (velocity * windSpeedMultiplier + 1.0);
        double height = player.getY() < 256.0 ? player.getY() / 256.0 * windHeightMultiplier : windHeightMultiplier;
        double wind = speedStabilized * height;
        double additionalDamagePercentage = itemStack.isDamaged() ? config.wind.durabilityMultiplier * ((double)itemStack.getDamageValue() / (double)itemStack.getMaxDamage()) : 0.0;
        wind *= 1.0 + additionalDamagePercentage;
        wind *= windOverallPower;
        player.setYRot((float)((double)player.getYRot() + (wind *= PlayerGlidingHelper.getGliderMaterialSettings((ItemStack)itemStack).windModifier)));
    }
}

