/*
 * Decompiled with CFR 0.152.
 */
package animalplus.entity;

import animalplus.init.AnimalplusModEntities;
import animalplus.init.AnimalplusModItems;
import java.util.function.Predicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.common.crafting.CompoundIngredient;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class RedPandaEntity
extends Animal {
    public RedPandaEntity(EntityType<RedPandaEntity> type, Level world) {
        super(type, world);
        this.xpReward = 4;
        this.setNoAi(false);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Blocks.BAMBOO.asItem()}), true));
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new FloatGoal((Mob)this));
    }

    protected void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource source, boolean recentlyHitIn) {
        super.dropCustomDeathLoot(serverLevel, source, recentlyHitIn);
        this.spawnAtLocation(new ItemStack((ItemLike)AnimalplusModItems.RED_PANDALEATHER.get()));
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"animalplus:redpanda"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"animalplus:redpanda_hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"animalplus:redpanda_dead"));
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        RedPandaEntity retval = (RedPandaEntity)((EntityType)AnimalplusModEntities.RED_PANDA.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return CompoundIngredient.of((Ingredient[])new Ingredient[]{Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.SHORT_GRASS)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.FERN)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.DANDELION)}), Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"minecraft:small_flowers"))), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.POPPY)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.BLUE_ORCHID)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.ALLIUM)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.AZURE_BLUET)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.RED_TULIP)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.ORANGE_TULIP)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.WHITE_TULIP)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.PINK_TULIP)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.OXEYE_DAISY)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.CORNFLOWER)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.LILY_OF_THE_VALLEY)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.TORCHFLOWER)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.PINK_PETALS)}), Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"minecraft:small_flowers"))), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.SUNFLOWER)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.LILAC)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.TALL_GRASS)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.LARGE_FERN)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.PEONY)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.PITCHER_PLANT)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.BROWN_MUSHROOM)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.WHEAT)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.BAMBOO)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.APPLE)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.GOLDEN_APPLE)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.GOLDEN_APPLE)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.ENCHANTED_GOLDEN_APPLE)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.WHEAT_SEEDS)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.WHEAT)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.CARROT)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.POTATO)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.BAKED_POTATO)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.POISONOUS_POTATO)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.PUMPKIN_PIE)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.GOLDEN_CARROT)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.BREAD)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.PUMPKIN_SEEDS)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.TORCHFLOWER_SEEDS)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.CAKE)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.MELON_SLICE)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.MELON_SEEDS)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.SWEET_BERRIES)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.GLOW_BERRIES)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.BEETROOT_SEEDS)})}).test(stack);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)AnimalplusModEntities.RED_PANDA.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.getBlockState(pos.below()).is(BlockTags.ANIMALS_SPAWNABLE_ON) && world.getRawBrightness(pos, 0) > 8, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 10.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        return builder;
    }
}

