/*
 * Decompiled with CFR 0.152.
 */
package animalplus.entity;

import animalplus.init.AnimalplusModEntities;
import animalplus.init.AnimalplusModItems;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RemoveBlockGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class RaccoonEntity
extends Animal {
    public RaccoonEntity(EntityType<RaccoonEntity> type, Level world) {
        super(type, world);
        this.xpReward = 4;
        this.setNoAi(false);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.SWEET_BERRIES}), true));
        this.goalSelector.addGoal(2, (Goal)new RemoveBlockGoal(Blocks.TURTLE_EGG, (PathfinderMob)this, 1.0, 2));
        this.goalSelector.addGoal(3, (Goal)new RemoveBlockGoal(Blocks.CAKE, (PathfinderMob)this, 1.0, 2));
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(6, (Goal)new FloatGoal((Mob)this));
    }

    protected void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource source, boolean recentlyHitIn) {
        super.dropCustomDeathLoot(serverLevel, source, recentlyHitIn);
        this.spawnAtLocation(new ItemStack((ItemLike)AnimalplusModItems.RACCOONLEATHER.get()));
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"animalplus:raccoon"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"animalplus:raccoon_dead"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"animalplus:raccoon_dead"));
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        RaccoonEntity retval = (RaccoonEntity)((EntityType)AnimalplusModEntities.RACCOON.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.CARROT), new ItemStack((ItemLike)Items.MUSHROOM_STEW), new ItemStack((ItemLike)Items.SUSPICIOUS_STEW), new ItemStack((ItemLike)Items.POTATO), new ItemStack((ItemLike)Items.BAKED_POTATO), new ItemStack((ItemLike)Items.POISONOUS_POTATO), new ItemStack((ItemLike)Items.PUMPKIN_PIE), new ItemStack((ItemLike)Items.GOLDEN_CARROT), new ItemStack((ItemLike)Items.BREAD), new ItemStack((ItemLike)Items.CAKE), new ItemStack((ItemLike)Items.SWEET_BERRIES), new ItemStack((ItemLike)Items.GLOW_BERRIES), new ItemStack((ItemLike)Items.COD), new ItemStack((ItemLike)Items.SALMON), new ItemStack((ItemLike)Items.TROPICAL_FISH), new ItemStack((ItemLike)Items.PUFFERFISH), new ItemStack((ItemLike)Items.COOKED_COD), new ItemStack((ItemLike)Items.COOKED_SALMON), new ItemStack((ItemLike)Items.PORKCHOP), new ItemStack((ItemLike)Items.COOKED_PORKCHOP), new ItemStack((ItemLike)Items.BEEF), new ItemStack((ItemLike)Items.COOKED_BEEF), new ItemStack((ItemLike)Items.CHICKEN), new ItemStack((ItemLike)Items.COOKED_CHICKEN), new ItemStack((ItemLike)Items.RABBIT), new ItemStack((ItemLike)Items.COOKED_RABBIT), new ItemStack((ItemLike)Items.RABBIT_FOOT), new ItemStack((ItemLike)Items.RABBIT_STEW), new ItemStack((ItemLike)Items.MUTTON), new ItemStack((ItemLike)Items.COOKED_MUTTON), new ItemStack((ItemLike)Items.ROTTEN_FLESH), new ItemStack((ItemLike)Blocks.TURTLE_EGG), new ItemStack((ItemLike)Blocks.SNIFFER_EGG), new ItemStack((ItemLike)Items.EGG)}).test(stack);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)AnimalplusModEntities.RACCOON.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.getDifficulty() != Difficulty.PEACEFUL && Monster.isDarkEnoughToSpawn((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random) && Mob.checkMobSpawnRules((EntityType)entityType, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random), RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 10.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        return builder;
    }
}

