/*
 * Decompiled with CFR 0.152.
 */
package fuzs.paperdoll.client.handler;

import fuzs.paperdoll.PaperDoll;
import fuzs.paperdoll.client.gui.PaperDollRenderer;
import fuzs.paperdoll.config.ClientConfig;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;

public class PaperDollHandler {
    private static final float MAX_ROTATION_DEGREES = 30.0f;
    private static final float SPIN_BACK_SPEED = 10.0f;
    private static int remainingDisplayTicks;
    private static int remainingRidingTicks;
    private static float yRotOffset;
    private static float yRotOffsetO;

    public static void onEndClientTick(Minecraft minecraft) {
        if (minecraft.player == null || minecraft.isPaused()) {
            return;
        }
        ClientConfig config = (ClientConfig)PaperDoll.CONFIG.get(ClientConfig.class);
        if (config.displayActions.stream().anyMatch(condition -> condition.isActive((Player)minecraft.player, remainingRidingTicks))) {
            remainingDisplayTicks = config.displayTime;
        } else if (remainingDisplayTicks > 0) {
            --remainingDisplayTicks;
        }
        if (remainingDisplayTicks > 0 || config.displayTime == 0) {
            PaperDollHandler.tickYRotOffset((Player)minecraft.player);
        } else {
            yRotOffsetO = 0.0f;
            yRotOffset = 0.0f;
        }
        if (minecraft.player.isPassenger()) {
            remainingRidingTicks = Math.max(0, config.displayTime - 2);
        } else if (remainingRidingTicks > 0) {
            --remainingRidingTicks;
        }
    }

    private static void tickYRotOffset(Player player) {
        yRotOffsetO = yRotOffset;
        yRotOffset = Mth.clamp((float)(yRotOffset + (player.yHeadRot - player.yHeadRotO) * 0.5f), (float)-30.0f, (float)30.0f);
        float nextYRotOffset = yRotOffset - yRotOffset / 10.0f;
        yRotOffset = yRotOffset < 0.0f ? Math.min(0.0f, nextYRotOffset) : (yRotOffset > 0.0f ? Math.max(0.0f, nextYRotOffset) : 0.0f);
    }

    public static void onRenderGui(Minecraft minecraft, GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        minecraft.getProfiler().push("paperDoll");
        if (!minecraft.player.isInvisible() && !minecraft.player.isSpectator()) {
            ClientConfig config = (ClientConfig)PaperDoll.CONFIG.get(ClientConfig.class);
            if (!(!minecraft.options.getCameraType().isFirstPerson() && config.firstPersonOnly || remainingDisplayTicks <= 0 && config.displayTime != 0)) {
                float partialTick = deltaTracker.getGameTimeDeltaPartialTick(false);
                int scale = config.scale * 5;
                int posX = config.position.getX(0, guiGraphics.guiWidth(), (int)((float)scale * 1.5f) + config.offsetX);
                int posY = config.position.isBottom() ? guiGraphics.guiHeight() - scale - config.offsetY : (int)((float)scale * 2.5f) + config.offsetY;
                posY = (int)((float)posY - ((float)scale - PaperDollHandler.getCurrentHeightOffset((Player)minecraft.player, partialTick) * (float)scale));
                if (config.potionShift) {
                    posY += config.position.getPotionShift(minecraft.player.getActiveEffects());
                }
                PaperDollRenderer.renderEntityInInventoryUpdateRotations(guiGraphics, posX, posY, scale, (LivingEntity)minecraft.player, partialTick);
            }
        }
        minecraft.getProfiler().pop();
    }

    private static float getCurrentHeightOffset(Player player, float tickDelta) {
        float height = player.getDimensions(Pose.STANDING).height();
        if (player.getFallFlyingTicks() > 0) {
            float ticksElytraFlying = (float)player.getFallFlyingTicks() + tickDelta;
            float flyingAnimation = Mth.clamp((float)(ticksElytraFlying * 0.09f), (float)0.0f, (float)1.0f);
            float flyingHeight = player.getDimensions(Pose.FALL_FLYING).height() / height;
            return Mth.lerp((float)flyingAnimation, (float)1.0f, (float)flyingHeight);
        }
        if ((double)player.getSwimAmount(tickDelta) > 0.0) {
            float swimmingAnimation = player.isVisuallySwimming() ? 1.0f : player.getSwimAmount(tickDelta);
            float swimmingHeight = player.getDimensions(Pose.SWIMMING).height() / height;
            return Mth.lerp((float)swimmingAnimation, (float)1.0f, (float)swimmingHeight);
        }
        if (player.isAutoSpinAttack()) {
            return player.getDimensions(Pose.SPIN_ATTACK).height() / height;
        }
        if (player.isCrouching()) {
            return player.getDimensions(Pose.CROUCHING).height() / height;
        }
        if (player.isSleeping()) {
            return player.getDimensions(Pose.SLEEPING).height() / height;
        }
        if (player.deathTime > 0) {
            float dyingAnimation = ((float)player.deathTime + tickDelta - 1.0f) / 20.0f * 1.6f;
            dyingAnimation = Math.min(1.0f, Mth.sqrt((float)dyingAnimation));
            float dyingHeight = player.getDimensions(Pose.DYING).height() / height;
            return Mth.lerp((float)dyingAnimation, (float)1.0f, (float)dyingHeight);
        }
        return 1.0f;
    }

    public static void applyEntityRotations(LivingEntity entity) {
        float defaultRotationYaw;
        ClientConfig config = (ClientConfig)PaperDoll.CONFIG.get(ClientConfig.class);
        ClientConfig.HeadMovement headMovement = config.headMovement;
        if (headMovement == ClientConfig.HeadMovement.YAW || entity.isFallFlying()) {
            entity.setXRot(7.5f);
            entity.xRotO = 7.5f;
        }
        entity.yBodyRot = entity.yBodyRotO = (defaultRotationYaw = 180.0f + config.position.getRotation(15.0f));
        if (headMovement == ClientConfig.HeadMovement.PITCH) {
            entity.yHeadRot = entity.yHeadRotO = defaultRotationYaw;
        } else {
            entity.yHeadRotO = defaultRotationYaw + yRotOffsetO;
            entity.yHeadRot = defaultRotationYaw + yRotOffset;
        }
    }
}

