/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.world;

import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.api.registry.BlockTempRegistry;
import com.momosoftworks.coldsweat.api.temperature.block_temp.BlockTemp;
import com.momosoftworks.coldsweat.api.temperature.modifier.FrigidnessTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.WarmthTempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.blockentity.HearthBlockEntity;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.network.message.BlockDataUpdateMessage;
import com.momosoftworks.coldsweat.core.network.message.ParticleBatchMessage;
import com.momosoftworks.coldsweat.core.network.message.PlayEntityAttachedSoundMessage;
import com.momosoftworks.coldsweat.core.network.message.SyncForgeDataMessage;
import com.momosoftworks.coldsweat.data.codec.configuration.BiomeTempData;
import com.momosoftworks.coldsweat.util.ClientOnlyHelper;
import com.momosoftworks.coldsweat.util.entity.DummyEntity;
import com.momosoftworks.coldsweat.util.entity.DummyPlayer;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.math.FastMap;
import com.momosoftworks.coldsweat.util.serialization.DynamicHolder;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

@EventBusSubscriber
public abstract class WorldHelper {
    static Map<ResourceKey<Level>, DummyPlayer> DUMMY_PLAYERS = new HashMap<ResourceKey<Level>, DummyPlayer>();
    static Map<ResourceKey<Level>, DummyEntity> DUMMY_ENTITIES = new HashMap<ResourceKey<Level>, DummyEntity>();
    static Map<ResourceKey<Level>, Map<BlockPos, TempSnapshot>> TEMPERATURE_CHECKS = new FastMap<ResourceKey<Level>, Map<BlockPos, TempSnapshot>>();

    @SubscribeEvent
    public static void clearCachesOnUnload(ServerStoppedEvent event) {
        DUMMY_PLAYERS.clear();
        DUMMY_ENTITIES.clear();
        TEMPERATURE_CHECKS.clear();
    }

    public static int getHeight(BlockPos pos, Level level) {
        int minHeight = level.getMinBuildHeight();
        int maxHeight = level.getMaxBuildHeight();
        int seaLevel = level.getSeaLevel();
        if (!level.isLoaded(pos)) {
            return seaLevel;
        }
        ChunkAccess chunk = WorldHelper.getChunk((LevelAccessor)level, pos);
        if (chunk == null) {
            return seaLevel;
        }
        if (level.isClientSide()) {
            int y = level.getMaxBuildHeight();
            BlockPos.MutableBlockPos mutable = pos.mutable();
            BlockState state = null;
            while (state == null || state.canBeReplaced()) {
                if (!CSMath.betweenInclusive(mutable.getY(), minHeight, maxHeight)) {
                    return seaLevel;
                }
                mutable.setY(y);
                state = chunk.getBlockState((BlockPos)mutable);
                --y;
            }
            return y;
        }
        return chunk.getHeight(Heightmap.Types.MOTION_BLOCKING, pos.getX(), pos.getZ());
    }

    public static List<BlockPos> getPositionGrid(BlockPos pos, int samples, int interval) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        int sampleRoot = (int)Math.sqrt(samples);
        int radius = sampleRoot * interval / 2;
        for (int x = -radius; x < radius; x += interval) {
            for (int z = -radius; z < radius; z += interval) {
                posList.add(pos.offset(x + interval / 2, 0, z + interval / 2));
            }
        }
        return posList;
    }

    public static List<BlockPos> getPositionCube(BlockPos pos, int size, int interval) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        int radius = size * interval / 2;
        int halfInterval = interval / 2;
        for (int x = -radius + halfInterval; x < radius + halfInterval; x += interval) {
            for (int y = -radius + halfInterval; y < radius + halfInterval; y += interval) {
                for (int z = -radius + halfInterval; z < radius + halfInterval; z += interval) {
                    posList.add(pos.offset(x, y, z));
                }
            }
        }
        return posList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canSeeSky(LevelAccessor level, BlockPos pos, int maxDistance) {
        BlockPos.MutableBlockPos pos2 = pos.mutable();
        int iterations = Math.min(maxDistance, level.getMaxBuildHeight() - pos.getY());
        ChunkAccess chunk = WorldHelper.getChunk(level, pos);
        if (chunk == null) {
            return true;
        }
        for (int i = 0; i < iterations; ++i) {
            try {
                BlockState state = chunk.getBlockState((BlockPos)pos2);
                if (ConfigSettings.THERMAL_SOURCE_SPREAD_BLACKLIST.get().contains(state.getBlock())) {
                    boolean bl = false;
                    return bl;
                }
                if (state.isAir() || state.liquid() || ConfigSettings.THERMAL_SOURCE_SPREAD_WHITELIST.get().contains(state.getBlock())) continue;
                VoxelShape shape = state.getShape((BlockGetter)level, pos, CollisionContext.empty());
                if (shape.equals(Shapes.block())) {
                    boolean bl = false;
                    return bl;
                }
                if (!WorldHelper.isFullSide(CSMath.flattenShape(Direction.Axis.Y, shape), Direction.UP)) continue;
                boolean bl = false;
                return bl;
            }
            finally {
                pos2.move(0, 1, 0);
            }
        }
        return true;
    }

    public static boolean isSpreadBlocked(LevelAccessor level, BlockState state, BlockPos pos, Direction fromDir, Direction toDir) {
        Block block = state.getBlock();
        if (state.isAir() || ConfigSettings.THERMAL_SOURCE_SPREAD_WHITELIST.get().contains(block)) {
            return false;
        }
        if (ConfigSettings.THERMAL_SOURCE_SPREAD_BLACKLIST.get().contains(block)) {
            return true;
        }
        VoxelShape shape = state.getCollisionShape((BlockGetter)level, pos, CollisionContext.empty());
        if (shape.equals(Shapes.block())) {
            return true;
        }
        return WorldHelper.isFullSide(shape.getFaceShape(fromDir.getOpposite()), fromDir) || WorldHelper.isFullSide(CSMath.flattenShape(toDir.getAxis(), shape), toDir);
    }

    public static boolean isFullSide(VoxelShape shape, Direction dir) {
        if (shape.isEmpty()) {
            return false;
        }
        double[] area = new double[1];
        switch (dir.getAxis()) {
            case X: {
                shape.forAllBoxes((x1, y1, z1, x2, y2, z2) -> {
                    area[0] = area[0] + Math.abs(y2 - y1) * Math.abs(z2 - z1);
                });
                break;
            }
            case Y: {
                shape.forAllBoxes((x1, y1, z1, x2, y2, z2) -> {
                    area[0] = area[0] + Math.abs(x2 - x1) * Math.abs(z2 - z1);
                });
                break;
            }
            case Z: {
                shape.forAllBoxes((x1, y1, z1, x2, y2, z2) -> {
                    area[0] = area[0] + Math.abs(x2 - x1) * Math.abs(y2 - y1);
                });
            }
        }
        return area[0] >= 1.0;
    }

    @Nullable
    public static ChunkAccess getChunk(LevelAccessor level, BlockPos pos) {
        return WorldHelper.getChunk(level, pos.getX() >> 4, pos.getZ() >> 4);
    }

    @Nullable
    public static ChunkAccess getChunk(LevelAccessor level, ChunkPos pos) {
        return WorldHelper.getChunk(level, pos.x, pos.z);
    }

    @Nullable
    public static ChunkAccess getChunk(LevelAccessor level, int chunkX, int chunkZ) {
        return level.getChunkSource().getChunkNow(chunkX, chunkZ);
    }

    public static LevelChunkSection getChunkSection(ChunkAccess chunk, int y) {
        LevelChunkSection[] sections = chunk.getSections();
        return sections[CSMath.clamp(chunk.getSectionIndex(y), 0, sections.length - 1)];
    }

    public static Optional<Holder<Structure>> getStructureAt(Level level, BlockPos pos) {
        ServerLevel serverLevel;
        block7: {
            block6: {
                if (!(level instanceof ServerLevel)) break block6;
                serverLevel = (ServerLevel)level;
                if (level.isLoaded(pos)) break block7;
            }
            return Optional.empty();
        }
        StructureManager structureManager = serverLevel.structureManager();
        Registry structureRegistry = serverLevel.registryAccess().registryOrThrow(Registries.STRUCTURE);
        for (Map.Entry entry : structureManager.getAllStructuresAt(pos).entrySet()) {
            Structure structure = (Structure)entry.getKey();
            LongSet strucCoordinates = (LongSet)entry.getValue();
            LongIterator longIterator = strucCoordinates.iterator();
            while (longIterator.hasNext()) {
                long coordinate = (Long)longIterator.next();
                SectionPos sectionpos = SectionPos.of((ChunkPos)new ChunkPos(coordinate), (int)level.getMinSection());
                StructureStart structurestart = structureManager.getStartForStructure(sectionpos, structure, (StructureAccess)level.getChunk(sectionpos.x(), sectionpos.z(), ChunkStatus.STRUCTURE_STARTS));
                if (structurestart == null || !structurestart.isValid() || !structureManager.structureHasPieceAt(pos, structurestart)) continue;
                ResourceLocation structureId = structureRegistry.getKey((Object)structure);
                if (structureId == null) {
                    return Optional.empty();
                }
                return structureRegistry.getHolder(ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)structureId));
            }
        }
        return Optional.empty();
    }

    public static void playEntitySound(SoundEvent sound, Entity entity, SoundSource source, float volume, float pitch) {
        if (!entity.isSilent()) {
            if (entity.level().isClientSide) {
                ClientOnlyHelper.playEntitySound(sound, source, volume, pitch, entity);
            } else {
                PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)new PlayEntityAttachedSoundMessage(sound, source, volume, pitch, entity.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static boolean isInWater(Entity entity) {
        BlockPos pos = entity.blockPosition();
        ChunkAccess chunk = WorldHelper.getChunk((LevelAccessor)entity.level(), pos);
        if (chunk == null) {
            return false;
        }
        return entity.isInWater() || chunk.getBlockState(pos).getBlock() == Blocks.BUBBLE_COLUMN;
    }

    public static boolean isRainingAt(Level level, BlockPos pos) {
        return (level.isRaining() && ((Biome)level.getBiomeManager().getBiome(pos).value()).getPrecipitationAt(pos) == Biome.Precipitation.RAIN || CompatManager.Weather2.isRainstormAt(level, pos)) && WorldHelper.canSeeSky((LevelAccessor)level, pos.above(), level.getMaxBuildHeight()) && !CompatManager.SereneSeasons.isColdEnoughToSnow(level, pos);
    }

    public static void forBlocksInRay(Vec3 from, Vec3 to, Level level, ChunkAccess chunk, Map<BlockPos, BlockState> stateCache, BiConsumer<BlockState, BlockPos> rayTracer, int maxHits) {
        block5: {
            if (from.equals((Object)to)) break block5;
            Vec3 ray = to.subtract(from);
            Vec3 normalRay = ray.normalize();
            BlockPos.MutableBlockPos pos = BlockPos.containing((Position)from).mutable();
            ChunkAccess workingChunk = chunk;
            int i = 0;
            while ((double)i < ray.length()) {
                block6: {
                    BlockState state;
                    block7: {
                        Vec3 vec = from.add(normalRay.scale((double)i));
                        if (BlockPos.containing((Position)vec).equals((Object)pos)) break block6;
                        pos.set(vec.x, vec.y, vec.z);
                        state = stateCache.get(pos);
                        if (state != null) break block7;
                        if (workingChunk == null || !workingChunk.getPos().equals((Object)new ChunkPos((BlockPos)pos))) {
                            workingChunk = WorldHelper.getChunk((LevelAccessor)level, (BlockPos)pos);
                        }
                        if (workingChunk == null) break block6;
                        state = workingChunk.getBlockState((BlockPos)pos);
                        stateCache.put(pos.immutable(), state);
                    }
                    if (!state.isAir() && --maxHits <= 0) break;
                    rayTracer.accept(state, (BlockPos)pos);
                }
                ++i;
            }
        }
    }

    public static void forBlocksInRay(Vec3 from, Vec3 to, Level level, BiConsumer<BlockState, BlockPos> rayTracer, int maxHits) {
        WorldHelper.forBlocksInRay(from, to, level, WorldHelper.getChunk((LevelAccessor)level, BlockPos.containing((Position)from)), new HashMap<BlockPos, BlockState>(), rayTracer, maxHits);
    }

    public static Entity raycastEntity(Vec3 from, Vec3 to, Level level, Predicate<Entity> filter) {
        if (!from.equals((Object)to)) {
            Vec3 ray = to.subtract(from);
            Vec3 normalRay = ray.normalize();
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            int i = 0;
            while ((double)i < ray.length()) {
                Vec3 vec = from.add(normalRay.scale((double)i));
                if (!BlockPos.containing((Position)vec).equals((Object)pos)) {
                    pos.set(vec.x, vec.y, vec.z);
                    List entities = level.getEntitiesOfClass(Entity.class, new AABB((BlockPos)pos), filter);
                    if (!entities.isEmpty()) {
                        return (Entity)entities.get(0);
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public static void spawnParticle(Level level, ParticleOptions particle, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        if (!level.isClientSide) {
            ParticleBatchMessage particles = new ParticleBatchMessage();
            particles.addParticle(particle, new ParticleBatchMessage.ParticlePlacement(x, y, z, xSpeed, ySpeed, zSpeed));
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)level), (ChunkPos)new ChunkPos((int)x >> 4, (int)z >> 4), (CustomPacketPayload)particles, (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            level.addParticle(particle, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }

    public static void spawnParticleBatch(Level level, ParticleOptions particle, double x, double y, double z, double xSpread, double ySpread, double zSpread, double count, double speed) {
        Random rand = new Random();
        if (!level.isClientSide) {
            ParticleBatchMessage particles = new ParticleBatchMessage();
            int i = 0;
            while ((double)i < count) {
                Vec3 vec = new Vec3(Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5).normalize().scale(speed);
                particles.addParticle(particle, new ParticleBatchMessage.ParticlePlacement(x + xSpread - rand.nextDouble() * (xSpread * 2.0), y + ySpread - rand.nextDouble() * (ySpread * 2.0), z + zSpread - rand.nextDouble() * (zSpread * 2.0), vec.x, vec.y, vec.z));
                ++i;
            }
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)level), (ChunkPos)new ChunkPos((int)x >> 4, (int)z >> 4), (CustomPacketPayload)particles, (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            int i = 0;
            while ((double)i < count) {
                Vec3 vec = new Vec3(Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5).normalize().scale(speed);
                level.addParticle(particle, x + xSpread - rand.nextDouble() * (xSpread * 2.0), y + ySpread - rand.nextDouble() * (ySpread * 2.0), z + zSpread - rand.nextDouble() * (zSpread * 2.0), vec.x, vec.y, vec.z);
                ++i;
            }
        }
    }

    public static ItemEntity dropItem(Level level, BlockPos pos, ItemStack stack) {
        return WorldHelper.dropItem(level, pos, stack, 6000);
    }

    public static ItemEntity dropItem(Level level, BlockPos pos, ItemStack stack, int lifeTime) {
        Random rand = new Random();
        ItemEntity item = new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), stack);
        item.setDeltaMovement(item.getDeltaMovement().add((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
        Field age = ObfuscationReflectionHelper.findField(ItemEntity.class, (String)"age");
        age.setAccessible(true);
        try {
            age.set(item, 6000 - lifeTime);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return item;
    }

    public static ItemEntity entityDropItem(Entity entity, ItemStack stack) {
        return WorldHelper.entityDropItem(entity, stack, 6000);
    }

    public static ItemEntity entityDropItem(Entity entity, ItemStack stack, int lifeTime) {
        Random rand = new Random();
        ItemEntity item = entity.spawnAtLocation(stack, entity.getBbHeight());
        if (item != null) {
            item.setDeltaMovement(item.getDeltaMovement().add((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
            item.lifespan = lifeTime;
        }
        return item;
    }

    public static Vec3 getClosestPointOnEntity(LivingEntity entity, Vec3 pos) {
        double playerRadius = entity.getBbWidth() / 2.0f;
        return new Vec3(CSMath.clamp(pos.x, entity.getX() - playerRadius, entity.getX() + playerRadius), CSMath.clamp(pos.y, entity.getY(), entity.getY() + (double)entity.getBbHeight()), CSMath.clamp(pos.z, entity.getZ() - playerRadius, entity.getZ() + playerRadius));
    }

    public static void syncEntityForgeData(Entity entity, ServerPlayer destination) {
        if (destination != null) {
            PacketDistributor.sendToPlayer((ServerPlayer)destination, (CustomPacketPayload)new SyncForgeDataMessage(entity), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)new SyncForgeDataMessage(entity), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void syncBlockEntityData(BlockEntity be) {
        if (be.getLevel() == null || be.getLevel().isClientSide) {
            return;
        }
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)be.getLevel()), (ChunkPos)new ChunkPos(be.getBlockPos()), (CustomPacketPayload)new BlockDataUpdateMessage(be), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static ServerLevel getServerLevel(Level level) {
        return ServerLifecycleHooks.getCurrentServer().getLevel(level.dimension());
    }

    public static MinecraftServer getServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    public static Pair<Double, Double> getBiomeTemperatureRange(LevelAccessor level, Holder<Biome> biome) {
        return WorldHelper.getBiomeTemperatureRange(level.registryAccess(), biome);
    }

    public static Pair<Double, Double> getBiomeTemperatureRange(RegistryAccess registryAccess, Holder<Biome> biome) {
        double variance = 1.0f / Math.max(1.0f, 2.0f + ((Biome)biome.value()).getModifiedClimateSettings().downfall() * 2.0f);
        double baseTemp = ((Biome)biome.value()).getBaseTemperature();
        BiomeTempData biomeTemp = ConfigSettings.BIOME_TEMPS.get(registryAccess).getOrDefault(biome, new BiomeTempData(biome, baseTemp - variance, baseTemp + variance, Temperature.Units.MC, true, false));
        if (biomeTemp.isDisabled()) {
            return Pair.of((Object)0.0, (Object)0.0);
        }
        BiomeTempData configOffset = ConfigSettings.BIOME_OFFSETS.get(registryAccess).getOrDefault(biome, new BiomeTempData(biome, 0.0, 0.0, Temperature.Units.MC, false, false));
        return CSMath.addPairs(Pair.of((Object)biomeTemp.minTemp(), (Object)biomeTemp.maxTemp()), Pair.of((Object)configOffset.minTemp(), (Object)configOffset.maxTemp()));
    }

    public static double getBiomeTemperature(LevelAccessor level, Holder<Biome> biome) {
        Pair<Double, Double> temps = WorldHelper.getBiomeTemperatureRange(level, biome);
        return CSMath.blend((Double)temps.getFirst(), (Double)temps.getSecond(), Math.sin((double)level.dayTime() / 3819.7186342054883), -1.0, 1.0);
    }

    public static double getRoughTemperatureAt(Level level, BlockPos pos, int flags) {
        boolean sensitive = (flags & 1) != 0;
        boolean forceUpdate = (flags & 2) != 0;
        Map snapshots = TEMPERATURE_CHECKS.computeIfAbsent((ResourceKey<Level>)level.dimension(), dim -> new HashMap());
        int tickSpeedMultiplier = 1 + level.getGameRules().getInt(GameRules.RULE_RANDOMTICKING) / 20;
        BlockPos segment = new BlockPos(pos.getX() >> 3, pos.getY() >> 3, pos.getZ() >> 3);
        if (!forceUpdate) {
            long gameTime;
            int interval = sensitive ? 200 : 1000;
            TempSnapshot snapshot = (TempSnapshot)snapshots.get(segment);
            if (snapshot != null && (gameTime = level.getGameTime()) - snapshot.timestamp < (long)(interval / tickSpeedMultiplier)) {
                return snapshot.temperature();
            }
        }
        DummyEntity dummy = WorldHelper.getDummyEntity(level);
        dummy.setPos(CSMath.getCenterPos(pos));
        ArrayList<TempModifier> modifiers = new ArrayList<TempModifier>(Temperature.getModifiers((LivingEntity)dummy, Temperature.Trait.WORLD));
        Pair<Integer, Integer> maxCoolingHeating = WorldHelper.getInsulationAt(level, pos, 2);
        if ((Integer)maxCoolingHeating.getFirst() > 0) {
            modifiers.add(new FrigidnessTempModifier((Integer)maxCoolingHeating.getFirst()));
        }
        if ((Integer)maxCoolingHeating.getSecond() > 0) {
            modifiers.add(new WarmthTempModifier((Integer)maxCoolingHeating.getSecond()));
        }
        double tempAt = Temperature.apply(0.0, (LivingEntity)dummy, Temperature.Trait.WORLD, modifiers, true);
        snapshots.put(segment, new TempSnapshot(level.getGameTime(), tempAt));
        return tempAt;
    }

    public static double getRoughTemperatureAt(Level level, BlockPos pos) {
        return WorldHelper.getRoughTemperatureAt(level, pos, 0);
    }

    public static double getBlockTemperature(Level level, BlockState block) {
        Collection<BlockTemp> blockTemps = BlockTempRegistry.getBlockTempsFor(block);
        for (BlockTemp blockTemp : blockTemps) {
            if (!blockTemp.isValid(level, BlockPos.ZERO, block)) continue;
            return blockTemp.getTemperature(level, null, block, BlockPos.ZERO, 0.0);
        }
        return 0.0;
    }

    public static double getTemperatureAt(Level level, BlockPos pos) {
        DummyPlayer dummy = WorldHelper.getDummyPlayer(level);
        dummy.setPos(CSMath.getCenterPos(pos));
        ArrayList<TempModifier> modifiers = new ArrayList<TempModifier>(Temperature.getModifiers((LivingEntity)dummy, Temperature.Trait.WORLD));
        Pair<Integer, Integer> maxCoolingHeating = WorldHelper.getInsulationAt(level, pos, 2);
        if ((Integer)maxCoolingHeating.getFirst() > 0) {
            modifiers.add(new FrigidnessTempModifier((Integer)maxCoolingHeating.getFirst()));
        }
        if ((Integer)maxCoolingHeating.getSecond() > 0) {
            modifiers.add(new WarmthTempModifier((Integer)maxCoolingHeating.getSecond()));
        }
        return Temperature.apply(0.0, (LivingEntity)dummy, Temperature.Trait.WORLD, modifiers, true);
    }

    public static DummyPlayer getDummyPlayer(Level level) {
        ResourceKey dimension = level.dimension();
        DummyPlayer dummy = DUMMY_PLAYERS.get(dimension);
        if (dummy == null || dummy.level() != level) {
            dummy = new DummyPlayer(level);
            DUMMY_PLAYERS.put((ResourceKey<Level>)dimension, dummy);
            Map<Temperature.Trait, List<TempModifier>> defaultModifiers = EntityTempManager.gatherTempModifiers((LivingEntity)dummy);
            defaultModifiers.get((Object)Temperature.Trait.WORLD).forEach(mod -> mod.tickRate(1));
            Temperature.getModifiers((LivingEntity)dummy).putAll(defaultModifiers);
        }
        return dummy;
    }

    public static DummyEntity getDummyEntity(Level level) {
        ResourceKey dimension = level.dimension();
        DummyEntity dummy = DUMMY_ENTITIES.get(dimension);
        if (dummy == null || dummy.level() != level) {
            dummy = new DummyEntity(level);
            DUMMY_ENTITIES.put((ResourceKey<Level>)dimension, dummy);
            Map<Temperature.Trait, List<TempModifier>> defaultModifiers = EntityTempManager.gatherTempModifiers((LivingEntity)dummy);
            defaultModifiers.get((Object)Temperature.Trait.WORLD).forEach(mod -> mod.tickRate(1));
            Temperature.getModifiers((LivingEntity)dummy).putAll(defaultModifiers);
        }
        return dummy;
    }

    public Map<ResourceKey<Level>, DummyPlayer> getDummyPlayers() {
        return DUMMY_PLAYERS;
    }

    public Map<ResourceKey<Level>, DummyEntity> getDummyEntities() {
        return DUMMY_ENTITIES;
    }

    public Map<ResourceKey<Level>, Map<BlockPos, TempSnapshot>> getWorldTempCache() {
        return TEMPERATURE_CHECKS;
    }

    public static boolean allAdjacentBlocksMatch(BlockPos pos, Predicate<BlockPos> predicate) {
        BlockPos.MutableBlockPos pos2 = pos.mutable();
        for (int i = 0; i < Direction.values().length; ++i) {
            BlockPos.MutableBlockPos offset = pos2.setWithOffset((Vec3i)pos, Direction.values()[i]);
            if (predicate.test((BlockPos)offset)) continue;
            return false;
        }
        return true;
    }

    public static BlockState waterlog(BlockState state, Level level, BlockPos pos) {
        boolean waterAt = level.getFluidState(pos).getType() == Fluids.WATER;
        return (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(waterAt));
    }

    public static boolean shouldFreeze(LevelAccessor levelReader, BlockPos pos, boolean mustBeAtEdge) {
        if (pos.getY() >= levelReader.getMinBuildHeight() && pos.getY() < levelReader.getMaxBuildHeight() && levelReader instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelReader;
            if (WorldHelper.surroundedByBlock(levelReader, pos, Blocks.ICE)) {
                return true;
            }
            DynamicHolder<Boolean> freezingTemp = DynamicHolder.create(null, () -> WorldHelper.getRoughTemperatureAt((Level)serverLevel, pos) < 0.0);
            if (!mustBeAtEdge) {
                return freezingTemp.get();
            }
            return !WorldHelper.surroundedByFluid(levelReader, pos, (Fluid)Fluids.WATER) && freezingTemp.get() != false;
        }
        return false;
    }

    public static boolean shouldMelt(LevelAccessor levelReader, BlockPos pos, boolean mustBeAtEdge) {
        if (pos.getY() >= levelReader.getMinBuildHeight() && pos.getY() < levelReader.getMaxBuildHeight() && levelReader instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelReader;
            if (mustBeAtEdge && WorldHelper.surroundedByBlock(levelReader, pos, Blocks.ICE)) {
                return false;
            }
            return WorldHelper.getRoughTemperatureAt((Level)serverLevel, pos) >= 0.0;
        }
        return false;
    }

    public static boolean surroundedByBlock(LevelAccessor level, BlockPos pos, Block block) {
        return level.getBlockState(pos.north()).is(block) && level.getBlockState(pos.south()).is(block) && level.getBlockState(pos.east()).is(block) && level.getBlockState(pos.west()).is(block);
    }

    public static boolean surroundedByFluid(LevelAccessor level, BlockPos pos, Fluid fluid) {
        return level.getBlockState(pos.north()).getFluidState().is(fluid) && level.getBlockState(pos.south()).getFluidState().is(fluid) && level.getBlockState(pos.east()).getFluidState().is(fluid) && level.getBlockState(pos.west()).getFluidState().is(fluid);
    }

    public static boolean nextToSoulFire(LevelAccessor level, BlockPos pos) {
        BlockPos.MutableBlockPos pos2 = pos.mutable();
        for (int x = -1; x <= 1; ++x) {
            for (int y = 0; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockState state = level.getBlockState((BlockPos)pos2.setWithOffset((Vec3i)pos, x, y, z));
                    if (!state.is(Blocks.SOUL_FIRE) && (!state.is(Blocks.SOUL_CAMPFIRE) || !((Boolean)state.getValue((Property)CampfireBlock.LIT)).booleanValue())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static Pair<Integer, Integer> getInsulationAt(Level level, BlockPos pos, int chunkRadius) {
        int maxCoolingLevel = 0;
        int maxHeatingLevel = 0;
        ChunkPos chunkPos = new ChunkPos(pos);
        for (int x = -chunkRadius; x <= chunkRadius; ++x) {
            for (int z = -chunkRadius; z <= chunkRadius; ++z) {
                ChunkAccess chunk = WorldHelper.getChunk((LevelAccessor)level, chunkPos.x + x, chunkPos.z + z);
                if (chunk == null) continue;
                for (BlockPos bePos : chunk.getBlockEntitiesPos()) {
                    HearthBlockEntity hearth;
                    BlockEntity be = chunk.getBlockEntity(bePos);
                    if (!(be instanceof HearthBlockEntity) || !(hearth = (HearthBlockEntity)be).getPathLookup().containsKey((Object)pos)) continue;
                    maxCoolingLevel = Math.max(maxCoolingLevel, hearth.getCoolingLevel());
                    maxHeatingLevel = Math.max(maxHeatingLevel, hearth.getHeatingLevel());
                }
            }
        }
        return Pair.of((Object)maxCoolingLevel, (Object)maxHeatingLevel);
    }

    public static List<BlockPos> getOccupiedPositions(AABB bb) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        int minX = (int)Math.floor(bb.minX);
        int minY = (int)Math.floor(bb.minY);
        int minZ = (int)Math.floor(bb.minZ);
        int maxX = (int)Math.ceil(bb.maxX);
        int maxY = (int)Math.ceil(bb.maxY);
        int maxZ = (int)Math.ceil(bb.maxZ);
        for (int x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                for (int z = minZ; z < maxZ; ++z) {
                    positions.add(new BlockPos(x, y, z));
                }
            }
        }
        return positions;
    }

    public record TempSnapshot(long timestamp, double temperature) {
    }
}

