/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.serialization;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.util.exceptions.SerializationException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.util.thread.EffectiveSide;

public class DynamicHolder<T>
implements Supplier<T> {
    private T value;
    private ResourceLocation name;
    private Supplier<T> valueCreator;
    private Loader<T> loader;
    private Saver<T> saver;
    private Codec<T> codec;
    private SyncType syncType = SyncType.NONE;
    private boolean requireRegistries = false;

    protected DynamicHolder(ResourceLocation name, Supplier<T> valueCreator, Consumer<DynamicHolder<T>> loader) {
        this.name = name;
        this.valueCreator = valueCreator;
        this.loader = (holder, registryAccess) -> loader.accept(holder);
    }

    protected DynamicHolder(ResourceLocation name, Supplier<T> valueCreator, Loader<T> loader) {
        this.name = name;
        this.valueCreator = valueCreator;
        this.loader = loader;
    }

    public static <T> DynamicHolder<T> createWithRegistries(ResourceLocation name, Supplier<T> valueCreator, Loader<T> loader) {
        DynamicHolder<T> holder = new DynamicHolder<T>(name, valueCreator, loader);
        holder.requireRegistries = true;
        return holder;
    }

    public static <T> DynamicHolder<T> create(ResourceLocation name, Supplier<T> valueCreator, Consumer<DynamicHolder<T>> loader) {
        return new DynamicHolder<T>(name, valueCreator, loader);
    }

    public static <T> DynamicHolder<T> create(ResourceLocation name, Supplier<T> valueCreator) {
        return new DynamicHolder<T>(name, valueCreator, holder -> {});
    }

    public static <T> DynamicHolder<T> createSyncedWithRegistries(ResourceLocation name, Supplier<T> valueCreator, Loader<T> loader, Codec<T> codec, Saver<T> saver, SyncType syncType) {
        if (syncType == SyncType.NONE) {
            throw (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("SyncType cannot be NONE for a synced DynamicHolder."));
        }
        DynamicHolder<T> holder = new DynamicHolder<T>(name, valueCreator, loader);
        holder.codec = codec;
        holder.saver = saver;
        holder.syncType = syncType;
        holder.requireRegistries = true;
        return holder;
    }

    public static <T> DynamicHolder<T> createSynced(ResourceLocation name, Supplier<T> valueCreator, Consumer<DynamicHolder<T>> loader, Codec<T> codec, Consumer<T> saver, SyncType syncType) {
        if (syncType == SyncType.NONE) {
            throw (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("SyncType cannot be NONE for a synced DynamicHolder."));
        }
        DynamicHolder<T> holder = new DynamicHolder<T>(name, valueCreator, loader);
        holder.saver = (val, registryAccess) -> saver.accept(val);
        holder.codec = codec;
        holder.syncType = syncType;
        return holder;
    }

    @Override
    public T get() {
        if (this.requireRegistries) {
            throw (RuntimeException)ColdSweat.LOGGER.throwing((Throwable)new RuntimeException("RegistryAccess is required for this DynamicHolder, yet none was provided."));
        }
        if (this.value == null) {
            this.load(true);
        }
        return this.value;
    }

    public T get(RegistryAccess registryAccess) {
        if (this.value == null) {
            this.load(registryAccess, true);
        }
        return this.value;
    }

    public void set(T value) {
        this.value = value;
    }

    public void setUnsafe(Object value) {
        this.value = value;
    }

    public void load(boolean replace) {
        if (replace) {
            this.value = this.valueCreator.get();
        }
        this.loader.load(this, null);
    }

    public void load(RegistryAccess registryAccess, boolean replace) {
        if (replace) {
            this.value = this.valueCreator.get();
        }
        this.loader.load(this, registryAccess);
    }

    public CompoundTag encode(RegistryAccess registryAccess) {
        if (!this.isSynced()) {
            throw (SerializationException)ColdSweat.LOGGER.throwing((Throwable)SerializationException.serialize(this.value, "Tried to encode non-synced DynamicHolder", null));
        }
        try {
            CompoundTag compound = new CompoundTag();
            DataResult holder = this.codec.encodeStart((DynamicOps)NbtOps.INSTANCE, this.get(registryAccess));
            Tag encoded = (Tag)holder.result().orElseThrow();
            compound.put(this.name.toString(), encoded);
            return compound;
        }
        catch (Exception e) {
            throw (SerializationException)ColdSweat.LOGGER.throwing((Throwable)SerializationException.serialize(this.value, "Failed to encode DynamicHolder for type " + this.value.getClass().getSimpleName(), e));
        }
    }

    public void decode(CompoundTag tag, RegistryAccess registryAccess) {
        if (!this.isSynced()) {
            throw (SerializationException)ColdSweat.LOGGER.throwing((Throwable)new SerializationException("Tried to decode non-synced DynamicHolder"));
        }
        try {
            Tag encoded = tag.get(this.name.toString());
            if (encoded == null) {
                throw (SerializationException)ColdSweat.LOGGER.throwing((Throwable)new SerializationException("No value found for DynamicHolder with name " + String.valueOf(this.name)));
            }
            this.value = this.codec.parse((DynamicOps)NbtOps.INSTANCE, (Object)encoded).result().orElseThrow();
            this.saver.save(this.value, registryAccess);
        }
        catch (Exception e) {
            throw (SerializationException)ColdSweat.LOGGER.throwing((Throwable)new SerializationException("Failed to decode DynamicHolder", e));
        }
    }

    public void save(RegistryAccess registryAccess) {
        if (!this.isSynced()) {
            throw (SerializationException)ColdSweat.LOGGER.throwing((Throwable)new SerializationException("Tried to save non-synced DynamicHolder"));
        }
        try {
            this.saver.save(this.get(registryAccess), registryAccess);
        }
        catch (Exception e) {
            throw (SerializationException)ColdSweat.LOGGER.throwing((Throwable)new SerializationException("Failed to save DynamicHolder for type " + this.value.getClass().getSimpleName(), e));
        }
    }

    public void reset() {
        this.value = this.valueCreator.get();
    }

    public boolean isSynced() {
        return this.syncType != SyncType.NONE;
    }

    public SyncType getSyncType() {
        return this.syncType;
    }

    public boolean requiresRegistries() {
        return this.requireRegistries;
    }

    public static enum SyncType {
        NONE,
        BOTH_WAYS,
        ONE_WAY;


        public boolean canSend() {
            return this == BOTH_WAYS || this == ONE_WAY && EffectiveSide.get().isServer();
        }

        public boolean canReceive() {
            return this == BOTH_WAYS || this == ONE_WAY && EffectiveSide.get().isClient() && !Minecraft.getInstance().isLocalServer();
        }
    }

    @FunctionalInterface
    public static interface Loader<T> {
        public void load(DynamicHolder<T> var1, RegistryAccess var2);
    }

    @FunctionalInterface
    public static interface Saver<T> {
        public void save(T var1, RegistryAccess var2);
    }
}

