/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.serialization;

import com.google.common.collect.Multimap;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigLoadingHandler;
import com.momosoftworks.coldsweat.data.codec.configuration.FuelData;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.util.math.FastMap;
import com.momosoftworks.coldsweat.util.math.FastMultiMap;
import com.momosoftworks.coldsweat.util.math.RegistryMultiMap;
import com.momosoftworks.coldsweat.util.serialization.DynamicHolder;
import com.momosoftworks.coldsweat.util.serialization.RegistryHelper;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.logging.log4j.util.TriConsumer;

public class ConfigHelper {
    private ConfigHelper() {
    }

    public static <T> List<Either<TagKey<T>, Holder<T>>> parseRegistryItems(ResourceKey<Registry<T>> registry, RegistryAccess registryAccess, String objects) {
        return ConfigHelper.parseRegistryItems(registry, registryAccess, objects.split(","));
    }

    public static <T> List<Either<TagKey<T>, Holder<T>>> parseRegistryItems(ResourceKey<Registry<T>> registry, RegistryAccess registryAccess, String[] objects) {
        ArrayList<Either<TagKey<T>, Holder<T>>> registryList = new ArrayList<Either<TagKey<T>, Holder<T>>>();
        Registry reg = registryAccess.registryOrThrow(registry);
        for (String objString : objects) {
            if (objString.startsWith("#")) {
                String tagID = objString.replace("#", "");
                registryList.add(Either.left((Object)TagKey.create(registry, (ResourceLocation)ResourceLocation.parse((String)tagID))));
                continue;
            }
            ResourceLocation id = ResourceLocation.parse((String)objString);
            Optional obj = reg.getHolder(ResourceKey.create(registry, (ResourceLocation)id));
            if (!reg.containsKey(id) || obj.isEmpty()) {
                ColdSweat.LOGGER.error("Error parsing config: {} \"{}\" does not exist", (Object)registry.location().getPath(), (Object)objString);
                continue;
            }
            registryList.add(Either.right((Object)((Holder)obj.get())));
        }
        return registryList;
    }

    public static <T> List<Either<TagKey<T>, T>> parseBuiltinItems(ResourceKey<Registry<T>> registryKey, Registry<T> registry, String objects) {
        return ConfigHelper.parseBuiltinItems(registryKey, registry, objects.split(","));
    }

    public static <T> List<Either<TagKey<T>, T>> parseBuiltinItems(ResourceKey<Registry<T>> registryKey, Registry<T> registry, String[] objects) {
        ArrayList<Either<TagKey<T>, T>> registryList = new ArrayList<Either<TagKey<T>, T>>();
        for (String objString : objects) {
            if (objString.startsWith("#")) {
                String tagID = objString.replace("#", "");
                registryList.add(Either.left((Object)TagKey.create(registryKey, (ResourceLocation)ResourceLocation.parse((String)tagID))));
                continue;
            }
            ResourceLocation id = ResourceLocation.parse((String)objString);
            if (!registry.containsKey(id)) {
                ColdSweat.LOGGER.error("Error parsing config: {} \"{}\" does not exist", (Object)registryKey.location().getPath(), (Object)objString);
                continue;
            }
            Object obj = registry.get(id);
            registryList.add(Either.right((Object)obj));
        }
        return registryList;
    }

    public static List<Either<TagKey<Block>, Block>> getBlocks(String blocks) {
        return ConfigHelper.getBlocks(blocks.split(","));
    }

    public static List<Either<TagKey<Block>, Block>> getBlocks(String[] blocks) {
        return ConfigHelper.parseBuiltinItems(Registries.BLOCK, BuiltInRegistries.BLOCK, blocks);
    }

    public static List<Either<TagKey<Item>, Item>> getItems(String items) {
        return ConfigHelper.getItems(items.split(","));
    }

    public static List<Either<TagKey<Item>, Item>> getItems(String[] items) {
        return ConfigHelper.parseBuiltinItems(Registries.ITEM, BuiltInRegistries.ITEM, items);
    }

    public static List<Either<TagKey<EntityType<?>>, EntityType<?>>> getEntityTypes(String entities) {
        return ConfigHelper.getEntityTypes(entities.split(","));
    }

    public static List<Either<TagKey<EntityType<?>>, EntityType<?>>> getEntityTypes(String[] entities) {
        return ConfigHelper.parseBuiltinItems(Registries.ENTITY_TYPE, BuiltInRegistries.ENTITY_TYPE, entities);
    }

    public static <K, V extends ConfigData> Multimap<K, V> parseTomlRegistry(ModConfigSpec.ConfigValue<List<? extends List<?>>> config, Function<List<?>, V> tomlParser, Function<V, List<Either<TagKey<K>, K>>> keyListGetter, Registry<K> keyRegistry, ResourceKey<Registry<V>> valueRegistry) {
        RegistryMultiMap dataMap = new RegistryMultiMap();
        for (List entry : (List)config.get()) {
            ConfigData data = (ConfigData)tomlParser.apply(entry);
            if (data == null) continue;
            data.setRegistryType(ConfigData.Type.TOML);
            RegistryHelper.mapBuiltinRegistryTagList(keyRegistry, keyListGetter.apply(data)).forEach(ent -> dataMap.put(ent, data));
        }
        ConfigLoadingHandler.removeEntries(dataMap.values(), valueRegistry);
        return dataMap;
    }

    public static <K, V extends ConfigData> Map<K, V> parseTomlRegistryUnique(ModConfigSpec.ConfigValue<List<? extends List<?>>> config, Function<List<?>, V> tomlParser, Function<V, List<Either<TagKey<K>, K>>> keyListGetter, Registry<K> keyRegistry, ResourceKey<Registry<V>> valueRegistry) {
        HashMap dataMap = new HashMap();
        for (List entry : (List)config.get()) {
            ConfigData data = (ConfigData)tomlParser.apply(entry);
            if (data == null) continue;
            data.setRegistryType(ConfigData.Type.TOML);
            RegistryHelper.mapBuiltinRegistryTagList(keyRegistry, keyListGetter.apply(data)).forEach(ent -> dataMap.put(ent, data));
        }
        ConfigLoadingHandler.removeEntries(dataMap.values(), valueRegistry);
        return dataMap;
    }

    private static <K, V> void putRegistryEntries(Multimap<K, V> map, Registry<K> registry, List<Either<TagKey<K>, K>> list, V data) {
        RegistryHelper.mapBuiltinRegistryTagList(registry, list).forEach(entry -> map.put(entry, data));
    }

    public static <K, V extends ConfigData> Map<Holder<K>, V> getRegistryMap(List<? extends List<?>> source, RegistryAccess registryAccess, ResourceKey<Registry<K>> keyRegistry, Function<List<?>, V> valueCreator, Function<V, List<Either<TagKey<K>, Holder<K>>>> taggedListGetter) {
        return ConfigHelper.getRegistryMapLike(source, registryAccess, keyRegistry, valueCreator, taggedListGetter, FastMap::new, FastMap::put);
    }

    public static <K, V extends ConfigData> Multimap<Holder<K>, V> getRegistryMultimap(List<? extends List<?>> source, RegistryAccess registryAccess, ResourceKey<Registry<K>> keyRegistry, Function<List<?>, V> valueCreator, Function<V, List<Either<TagKey<K>, Holder<K>>>> taggedListGetter) {
        return ConfigHelper.getRegistryMapLike(source, registryAccess, keyRegistry, valueCreator, taggedListGetter, FastMultiMap::new, FastMultiMap::put);
    }

    private static <K, V extends ConfigData, M> M getRegistryMapLike(List<? extends List<?>> source, RegistryAccess registryAccess, ResourceKey<Registry<K>> keyRegistry, Function<List<?>, V> valueCreator, Function<V, List<Either<TagKey<K>, Holder<K>>>> taggedListGetter, Supplier<M> mapSupplier, TriConsumer<M, Holder<K>, V> mapAdder) {
        M map = mapSupplier.get();
        for (List<?> entry : source) {
            ConfigData data = (ConfigData)valueCreator.apply(entry);
            if (data != null) {
                data.setRegistryType(ConfigData.Type.TOML);
                for (Holder<K> key : RegistryHelper.mapRegistryTagList(keyRegistry, taggedListGetter.apply(data), registryAccess)) {
                    mapAdder.accept(map, key, (Object)data);
                }
                continue;
            }
            ColdSweat.LOGGER.error("Error parsing {} config \"{}\"", (Object)keyRegistry.location(), (Object)entry.toString());
        }
        return map;
    }

    public static <T> Codec<Either<TagKey<T>, T>> tagOrBuiltinCodec(ResourceKey<Registry<T>> vanillaRegistry, DefaultedRegistry<T> forgeRegistry) {
        return Codec.either((Codec)Codec.STRING.comapFlatMap(str -> {
            if (!str.startsWith("#")) {
                return DataResult.error(() -> String.format("Not a tag key for builtin registry %s: %s", vanillaRegistry.location(), str));
            }
            ResourceLocation itemLocation = ResourceLocation.parse((String)str.replace("#", ""));
            return DataResult.success((Object)TagKey.create((ResourceKey)vanillaRegistry, (ResourceLocation)itemLocation));
        }, key -> "#" + String.valueOf(key.location())), (Codec)Codec.STRING.comapFlatMap(str -> {
            ResourceLocation itemLocation = ResourceLocation.parse((String)str);
            Optional obj = forgeRegistry.getOptional(itemLocation);
            if (obj.isEmpty()) {
                if (CompatManager.modLoaded(itemLocation.getNamespace())) {
                    ColdSweat.LOGGER.error("Error deserializing config: object \"{}\" does not exist", str);
                    return DataResult.error(() -> "Object does not exist");
                }
                return DataResult.success((Object)forgeRegistry.get(forgeRegistry.getDefaultKey()));
            }
            return DataResult.success(obj.get());
        }, obj -> {
            ResourceLocation itemLocation = forgeRegistry.getKey(obj);
            return itemLocation.toString();
        }));
    }

    public static <T> Codec<Either<TagKey<T>, Holder<T>>> tagOrHolderCodec(ResourceKey<Registry<T>> vanillaRegistry) {
        return Codec.either((Codec)Codec.STRING.comapFlatMap(str -> {
            if (!str.startsWith("#")) {
                return DataResult.error(() -> String.format("Not a tag key for dynamic holder registry %s: %s", vanillaRegistry.location(), str));
            }
            ResourceLocation itemLocation = ResourceLocation.parse((String)str.replace("#", ""));
            return DataResult.success((Object)TagKey.create((ResourceKey)vanillaRegistry, (ResourceLocation)itemLocation));
        }, key -> "#" + String.valueOf(key.location())), (Codec)Codec.STRING.comapFlatMap(str -> {
            RegistryAccess registryAccess = RegistryHelper.getRegistryAccess();
            if (registryAccess == null) {
                ColdSweat.LOGGER.error("Error deserializing config: registry access is null");
                return DataResult.error(() -> "Registry access is null");
            }
            ResourceLocation itemLocation = ResourceLocation.parse((String)str);
            Registry registry = registryAccess.registry(vanillaRegistry).orElse(null);
            if (registry == null) {
                ColdSweat.LOGGER.error("Error deserializing config: registry \"{}\" does not exist", (Object)vanillaRegistry.location());
                return DataResult.error(() -> "Registry does not exist");
            }
            Optional holder = registry.getHolder(itemLocation);
            if (holder.isEmpty()) {
                if (CompatManager.modLoaded(itemLocation.getNamespace())) {
                    ColdSweat.LOGGER.error("Error deserializing config: object \"{}\" does not exist", str);
                    return DataResult.error(() -> "Object does not exist");
                }
                return DataResult.success((Object)Holder.Reference.createIntrusive((HolderOwner)new HolderOwner<T>(){}, registry.stream().findFirst().get()));
            }
            return DataResult.success((Object)((Holder.Reference)holder.get()));
        }, holder -> {
            RegistryAccess registryAccess = RegistryHelper.getRegistryAccess();
            if (registryAccess == null) {
                ColdSweat.LOGGER.error("Error serializing config: registry access is null");
                return "null";
            }
            Registry registry = registryAccess.registry(vanillaRegistry).orElse(null);
            if (registry == null) {
                ColdSweat.LOGGER.error("Error serializing config: registry \"{}\" does not exist", (Object)vanillaRegistry.location());
                return "null";
            }
            return registry.getKey(holder.value()).toString();
        }));
    }

    public static <T> Codec<Either<TagKey<T>, Holder<T>>> tagOrBuiltinHolderCodec(ResourceKey<Registry<T>> vanillaRegistry, Registry<T> registry) {
        return Codec.either((Codec)Codec.STRING.comapFlatMap(str -> {
            if (!str.startsWith("#")) {
                return DataResult.error(() -> String.format("Not a tag key for builtin holder registry %s: %s", vanillaRegistry.location(), str));
            }
            ResourceLocation itemLocation = ResourceLocation.parse((String)str.replace("#", ""));
            return DataResult.success((Object)TagKey.create((ResourceKey)vanillaRegistry, (ResourceLocation)itemLocation));
        }, key -> "#" + String.valueOf(key.location())), (Codec)Codec.STRING.comapFlatMap(str -> {
            ResourceLocation itemLocation = ResourceLocation.parse((String)str);
            Optional holder = registry.getHolder(itemLocation);
            if (holder.isEmpty()) {
                if (CompatManager.modLoaded(itemLocation.getNamespace())) {
                    ColdSweat.LOGGER.error("Error deserializing config: object \"{}\" does not exist", str);
                    return DataResult.error(() -> "Object does not exist");
                }
                return DataResult.success((Object)Holder.Reference.createIntrusive((HolderOwner)new HolderOwner<T>(){}, registry.stream().findFirst().get()));
            }
            return DataResult.success((Object)((Holder.Reference)registry.getHolder(itemLocation).get()));
        }, holder -> {
            ResourceLocation itemLocation = registry.getKey(holder.value());
            return itemLocation.toString();
        }));
    }

    public static <T> Codec<Either<TagKey<T>, Holder<T>>> tagOrHolderCodec(ResourceKey<Registry<T>> vanillaRegistry, Codec<Holder<T>> codec) {
        return Codec.either((Codec)Codec.STRING.comapFlatMap(str -> {
            if (!str.startsWith("#")) {
                return DataResult.error(() -> "Not a tag key: " + str);
            }
            ResourceLocation itemLocation = ResourceLocation.parse((String)str.replace("#", ""));
            return DataResult.success((Object)TagKey.create((ResourceKey)vanillaRegistry, (ResourceLocation)itemLocation));
        }, key -> "#" + String.valueOf(key.location())), codec);
    }

    public static <T> Codec<Either<TagKey<T>, ResourceKey<T>>> tagOrResourceKeyCodec(ResourceKey<Registry<T>> vanillaRegistry) {
        return Codec.either((Codec)Codec.STRING.comapFlatMap(str -> {
            if (!str.startsWith("#")) {
                return DataResult.error(() -> String.format("Not a tag key for dynamic resource registry %s: %s", vanillaRegistry.location(), str));
            }
            ResourceLocation itemLocation = ResourceLocation.parse((String)str.replace("#", ""));
            return DataResult.success((Object)TagKey.create((ResourceKey)vanillaRegistry, (ResourceLocation)itemLocation));
        }, key -> "#" + String.valueOf(key.location())), (Codec)ResourceKey.codec(vanillaRegistry));
    }

    public static Optional<FuelData> findFirstFuelMatching(DynamicHolder<Multimap<Item, FuelData>> predicates, ItemStack stack) {
        for (FuelData predicate : predicates.get().get((Object)stack.getItem())) {
            if (!predicate.test(stack)) continue;
            return Optional.of(predicate);
        }
        return Optional.empty();
    }

    public static <T> Optional<T> parseResource(ResourceManager resourceManager, ResourceLocation location, Codec<T> codec) {
        Optional optional;
        if (resourceManager == null) {
            return Optional.empty();
        }
        Resource resource = (Resource)resourceManager.getResource(location).orElseThrow();
        InputStreamReader reader = new InputStreamReader(resource.open(), StandardCharsets.UTF_8);
        try {
            JsonObject json = GsonHelper.parse((Reader)reader);
            optional = codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).result();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                ColdSweat.LOGGER.error((Object)new RuntimeException("Failed to load JSON file: " + String.valueOf(location), e));
                return Optional.empty();
            }
        }
        ((Reader)reader).close();
        return optional;
    }

    public static String concatStringList(List<String> list) {
        StringBuilder builder = new StringBuilder();
        Iterator<String> iter = list.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    public static <K, T extends ConfigData> List<T> getTaggedConfigsFor(K object, TagKey<T> tag, Multimap<K, T> config, RegistryAccess registryAccess) {
        Registry registry = registryAccess.registryOrThrow(tag.registry());
        ArrayList<ConfigData> results = new ArrayList<ConfigData>();
        for (ConfigData configData : config.get(object)) {
            Holder holder = registry.wrapAsHolder((Object)configData);
            if (!holder.is(tag)) continue;
            results.add(configData);
        }
        return results;
    }

    public static <K, V> V getFirstOrNull(DynamicHolder<Multimap<K, V>> map, K key, Predicate<V> filter) {
        List values = map.get().get(key).stream().filter(filter).toList();
        if (values.isEmpty()) {
            return null;
        }
        return (V)values.iterator().next();
    }
}

