/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.item;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.fml.util.ObfuscationReflectionHelper;

public class ItemStackHelper {
    public static void playBucketEmptySound(ItemStack stack, @Nullable Player pPlayer, LevelAccessor pLevel, BlockPos pPos) {
        Method playEmptySound = ObfuscationReflectionHelper.findMethod(BucketItem.class, (String)"playEmptySound", (Class[])new Class[]{Player.class, LevelAccessor.class, BlockPos.class});
        playEmptySound.setAccessible(true);
        try {
            playEmptySound.invoke((Object)stack.getItem(), pPlayer, pLevel, pPos);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Stream<ItemAttributeModifiers.Entry> getAttributeModifiers(ItemStack stack, AttributeModifier.Operation operation) {
        return stack.getAttributeModifiers().modifiers().stream().filter(entry -> entry.modifier().operation() == operation);
    }

    public static Stream<ItemAttributeModifiers.Entry> getAttributeModifiers(ItemStack stack, EquipmentSlot slot) {
        return stack.getAttributeModifiers().modifiers().stream().filter(entry -> entry.slot().test(slot));
    }

    public static <T> T getOrCreateComponent(ItemStack stack, DataComponentType<T> componentType, Supplier<T> componentCreator) {
        Object component = stack.get(componentType);
        if (component == null) {
            component = componentCreator.get();
            stack.set(componentType, component);
        }
        return (T)component;
    }

    public static EquipmentSlot getEquipmentSlot(ItemStack stack) {
        EquipmentSlot slot = stack.getEquipmentSlot();
        if (slot != null) {
            return slot;
        }
        Equipable equipable = Equipable.get((ItemStack)stack);
        if (equipable != null) {
            return equipable.getEquipmentSlot();
        }
        return EquipmentSlot.MAINHAND;
    }

    public static boolean canApplyEnchantment(ItemStack item, Holder<Enchantment> enchantment) {
        if (item.has(DataComponents.ENCHANTMENTS)) {
            for (Object2IntMap.Entry entry : ((ItemEnchantments)item.get(DataComponents.ENCHANTMENTS)).entrySet()) {
                Holder itemEnch = (Holder)entry.getKey();
                if (!((Enchantment)itemEnch.value()).exclusiveSet().contains(enchantment) && !((Enchantment)enchantment.value()).exclusiveSet().contains(itemEnch)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

