/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.mixin;

import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.ModItemComponents;
import com.momosoftworks.coldsweat.core.init.ModItems;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CampfireBlockEntity.class})
public class MixinCampfire {
    @Inject(method={"cookTick(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/CampfireBlockEntity;)V"}, at={@At(value="HEAD")})
    private static void onItemCook(Level level, BlockPos pos, BlockState state, CampfireBlockEntity blockEntity, CallbackInfo ci) {
        double waterskinStrength = ConfigSettings.WATERSKIN_CONSUME_STRENGTH.get().intValue();
        double tempRate = ConfigSettings.TEMP_RATE.get();
        for (int i = 0; i < blockEntity.getItems().size(); ++i) {
            ItemStack stack = (ItemStack)blockEntity.getItems().get(i);
            if (!stack.is(ModItems.FILLED_WATERSKIN) || (level.getGameTime() & 4L) != 0L) continue;
            double temperature = (Double)stack.get(ModItemComponents.WATER_TEMPERATURE);
            if (state.is(BlockTags.CAMPFIRES) && CSMath.getIfNotNull(BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()), ResourceLocation::toString, "").contains("soul") && temperature > -waterskinStrength * 0.6) {
                stack.set(ModItemComponents.WATER_TEMPERATURE, (Object)(temperature + tempRate * 0.1 * (double)(ConfigSettings.COLD_SOUL_FIRE.get() != false ? -1 : 1)));
                continue;
            }
            if (!state.is(BlockTags.CAMPFIRES) || !(temperature < waterskinStrength * 0.6)) continue;
            stack.set(ModItemComponents.WATER_TEMPERATURE, (Object)(temperature + tempRate * 0.1));
        }
    }

    @ModifyArg(method={"cookTick(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/CampfireBlockEntity;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/Containers;dropItemStack(Lnet/minecraft/world/level/Level;DDDLnet/minecraft/world/item/ItemStack;)V"), index=4)
    private static ItemStack onItemFinishedCooking(Level level, double x, double y, double z, ItemStack result) {
        if (result.is(ModItems.FILLED_WATERSKIN)) {
            double waterskinStrength = ConfigSettings.WATERSKIN_CONSUME_STRENGTH.get().intValue();
            BlockState state = level.getBlockState(BlockPos.containing((double)x, (double)y, (double)z));
            if (state.is(BlockTags.CAMPFIRES) && CSMath.getIfNotNull(BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()), ResourceLocation::toString, "").contains("soul")) {
                result.set(ModItemComponents.WATER_TEMPERATURE, (Object)(waterskinStrength * 0.6 * (double)(ConfigSettings.COLD_SOUL_FIRE.get() != false ? -1 : 1)));
            } else if (state.is(BlockTags.CAMPFIRES)) {
                result.set(ModItemComponents.WATER_TEMPERATURE, (Object)(waterskinStrength * 0.6));
            }
        }
        return result;
    }
}

