/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.tag;

import com.momosoftworks.coldsweat.api.event.core.init.InitDynamicTagsEvent;
import com.momosoftworks.coldsweat.api.event.vanilla.ServerConfigsLoadedEvent;
import com.momosoftworks.coldsweat.util.serialization.ListBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.common.NeoForge;

@EventBusSubscriber
public class TagHelper {
    private static final Field CONTENTS = ObfuscationReflectionHelper.findField(HolderSet.Named.class, (String)"contents");
    private static final Method BIND = ObfuscationReflectionHelper.findMethod(HolderSet.Named.class, (String)"bind", (Class[])new Class[]{List.class});
    private static final Method BIND_TAGS = ObfuscationReflectionHelper.findMethod(Holder.Reference.class, (String)"bindTags", (Class[])new Class[]{Collection.class});

    public static <T> void fillTag(TagKey<T> tag, Predicate<T> predicate, ResourceKey<Registry<T>> registry, RegistryAccess registryAccess) {
        HashSet entries;
        Registry reg = registryAccess.registryOrThrow(registry);
        HolderSet.Named holderSet = (HolderSet.Named)reg.getTag(tag).get();
        try {
            entries = new HashSet((List)CONTENTS.get(holderSet));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        reg.holders().forEach(dimensionType -> {
            if (predicate.test(dimensionType.value())) {
                entries.add(dimensionType);
                try {
                    BIND_TAGS.invoke(dimensionType, ListBuilder.begin(dimensionType.tags().toList()).add((List<TagKey>)tag).build());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        try {
            BIND.invoke((Object)holderSet, new ArrayList(entries));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public static void onServerStart(ServerConfigsLoadedEvent event) {
        InitDynamicTagsEvent tagsEvent = new InitDynamicTagsEvent((RegistryAccess)event.getServer().registryAccess());
        NeoForge.EVENT_BUS.post((Event)tagsEvent);
    }

    static {
        CONTENTS.setAccessible(true);
        BIND.setAccessible(true);
        BIND_TAGS.setAccessible(true);
    }
}

