/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.tag;

import com.momosoftworks.coldsweat.api.event.core.init.InitDynamicTagsEvent;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.dimension.DimensionType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;

@EventBusSubscriber
public class ModDimensionTags {
    public static final TagKey<DimensionType> SOUL_LAMP_VALID = ModDimensionTags.createTag("soulspring_lamp_valid");
    public static final TagKey<DimensionType> HAS_CEILING = ModDimensionTags.createForgeTag("has_ceiling");
    public static final TagKey<DimensionType> HAS_SKY = ModDimensionTags.createForgeTag("has_sky");
    public static final TagKey<DimensionType> NATURAL = ModDimensionTags.createForgeTag("natural");
    public static final TagKey<DimensionType> UNNATURAL = ModDimensionTags.createForgeTag("unnatural");
    public static final TagKey<DimensionType> ULTRAWARM = ModDimensionTags.createForgeTag("ultrawarm");
    public static final TagKey<DimensionType> BED_WORKS = ModDimensionTags.createForgeTag("bed_works");
    public static final TagKey<DimensionType> RESPAWN_ANCHOR_WORKS = ModDimensionTags.createForgeTag("respawn_anchor_works");
    public static final TagKey<DimensionType> PIGLIN_SAFE = ModDimensionTags.createForgeTag("piglin_safe");
    public static final TagKey<DimensionType> HAS_SKYLIGHT = ModDimensionTags.createForgeTag("has_skylight");
    public static final TagKey<DimensionType> HAS_RAIDS = ModDimensionTags.createForgeTag("has_raids");
    public static final TagKey<DimensionType> OVERWORLD_LIKE = ModDimensionTags.createForgeTag("overworld_like");

    private static TagKey<DimensionType> createTag(String name) {
        return TagKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)name));
    }

    private static TagKey<DimensionType> createForgeTag(String name) {
        return TagKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
    }

    @SubscribeEvent
    public static void initDynamicTags(InitDynamicTagsEvent event) {
        event.fillTag(HAS_CEILING, DimensionType::hasCeiling, Registries.DIMENSION_TYPE);
        event.fillTag(HAS_SKY, dimensionType -> !dimensionType.hasCeiling(), Registries.DIMENSION_TYPE);
        event.fillTag(NATURAL, DimensionType::natural, Registries.DIMENSION_TYPE);
        event.fillTag(UNNATURAL, dimensionType -> !dimensionType.natural(), Registries.DIMENSION_TYPE);
        event.fillTag(ULTRAWARM, DimensionType::ultraWarm, Registries.DIMENSION_TYPE);
        event.fillTag(BED_WORKS, DimensionType::bedWorks, Registries.DIMENSION_TYPE);
        event.fillTag(RESPAWN_ANCHOR_WORKS, DimensionType::respawnAnchorWorks, Registries.DIMENSION_TYPE);
        event.fillTag(PIGLIN_SAFE, DimensionType::piglinSafe, Registries.DIMENSION_TYPE);
        event.fillTag(HAS_SKYLIGHT, DimensionType::hasSkyLight, Registries.DIMENSION_TYPE);
        event.fillTag(HAS_RAIDS, DimensionType::hasRaids, Registries.DIMENSION_TYPE);
        event.fillTag(OVERWORLD_LIKE, dimensionType -> !dimensionType.hasCeiling() && dimensionType.natural() && dimensionType.hasSkyLight() && !dimensionType.ultraWarm(), Registries.DIMENSION_TYPE);
    }
}

