/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.util.serialization.RegistryHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class ExtraCodecs {
    public static Codec<Object> anyOf(final Codec<?> ... codecs) {
        return new Codec<Object>(){

            public <T> DataResult<T> encode(Object input, DynamicOps<T> ops, T prefix) {
                for (Codec codec : codecs) {
                    try {
                        DataResult result = codec.encode(input, ops, prefix);
                        if (!result.result().isPresent()) continue;
                        return result;
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
                return DataResult.error(() -> "No codecs could encode input " + String.valueOf(input));
            }

            public <T> DataResult<Pair<Object, T>> decode(DynamicOps<T> ops, T input) {
                for (Codec codec : codecs) {
                    DataResult result = codec.decode(ops, input);
                    if (!result.result().isPresent()) continue;
                    return result;
                }
                return DataResult.error(() -> "No codecs could decode input " + String.valueOf(input));
            }
        };
    }

    public static <F, S> Codec<Pair<F, S>> pair(Codec<F> firstCodec, Codec<S> secondCodec) {
        return RecordCodecBuilder.create(instance -> instance.group((App)firstCodec.fieldOf("first").forGetter(Pair::getFirst), (App)secondCodec.fieldOf("second").forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::of));
    }

    public static <K, V> Codec<Map<K, V>> builtinMapCodec(final Registry<K> keyRegistry, final Codec<V> valueCodec) {
        return new Codec<Map<K, V>>(){

            public <T> DataResult<Pair<Map<K, V>, T>> decode(DynamicOps<T> ops, T input) {
                RegistryOps decoderOps = RegistryOps.create(ops, (HolderLookup.Provider)RegistryHelper.getRegistryAccess());
                Optional keyMapResult = Codec.unboundedMap((Codec)Codec.STRING, (Codec)valueCodec).decode((DynamicOps)decoderOps, input).result();
                Map keyMap = (Map)((Pair)keyMapResult.orElseThrow()).getFirst();
                HashMap holderMap = new HashMap();
                for (Map.Entry entry : keyMap.entrySet()) {
                    ResourceLocation id = ResourceLocation.parse((String)((String)entry.getKey()));
                    Object key = keyRegistry.get(id);
                    if (key == null) continue;
                    holderMap.put(key, entry.getValue());
                }
                return DataResult.success((Object)Pair.of(holderMap, (Object)keyMapResult.map(Pair::getSecond).orElseThrow()));
            }

            public <T> DataResult<T> encode(Map<K, V> input, DynamicOps<T> ops, T prefix) {
                RegistryOps encoderOps = RegistryOps.create(ops, (HolderLookup.Provider)RegistryHelper.getRegistryAccess());
                HashMap keyMap = new HashMap();
                for (Map.Entry entry : input.entrySet()) {
                    keyMap.put(keyRegistry.getKey(entry.getKey()).toString(), entry.getValue());
                }
                return Codec.unboundedMap((Codec)Codec.STRING, (Codec)valueCodec).encode(keyMap, (DynamicOps)encoderOps, prefix);
            }
        };
    }

    public static <K, V> Codec<Multimap<K, V>> builtinMultimapCodec(Registry<K> keyRegistry, Codec<V> valueCodec) {
        return ExtraCodecs.builtinMapCodec(keyRegistry, valueCodec.listOf()).xmap(map -> {
            HashMultimap multimap = HashMultimap.create();
            for (Map.Entry entry : map.entrySet()) {
                multimap.putAll(entry.getKey(), (Iterable)entry.getValue());
            }
            return multimap;
        }, multimap -> {
            HashMap fastMultiMap = new HashMap();
            for (Map.Entry entry : multimap.asMap().entrySet()) {
                fastMultiMap.put(entry.getKey(), new ArrayList((Collection)entry.getValue()));
            }
            return fastMultiMap;
        });
    }

    public static <K, V> Codec<Map<Holder<K>, V>> registryMapCodec(final ResourceKey<Registry<K>> keyRegistry, final Codec<V> valueCodec) {
        return new Codec<Map<Holder<K>, V>>(){

            public <T> DataResult<Pair<Map<Holder<K>, V>, T>> decode(DynamicOps<T> ops, T input) {
                RegistryAccess registryAccess = RegistryHelper.getRegistryAccess();
                Registry reg = registryAccess.registryOrThrow(keyRegistry);
                RegistryOps decoderOps = registryAccess.createSerializationContext(ops);
                Optional keyMapResult = Codec.unboundedMap((Codec)Codec.STRING, (Codec)valueCodec).decode((DynamicOps)decoderOps, input).result();
                Map keyMap = (Map)((Pair)keyMapResult.orElseThrow()).getFirst();
                HashMap holderMap = new HashMap();
                for (Map.Entry entry : keyMap.entrySet()) {
                    ResourceKey key = ResourceKey.create((ResourceKey)keyRegistry, (ResourceLocation)ResourceLocation.parse((String)((String)entry.getKey())));
                    reg.getHolder(key).ifPresent(k -> holderMap.put(k, entry.getValue()));
                }
                return DataResult.success((Object)Pair.of(holderMap, (Object)keyMapResult.map(Pair::getSecond).orElseThrow()));
            }

            public <T> DataResult<T> encode(Map<Holder<K>, V> input, DynamicOps<T> ops, T prefix) {
                RegistryOps encoderOps = RegistryHelper.getRegistryAccess().createSerializationContext(ops);
                HashMap keyMap = new HashMap();
                for (Map.Entry entry : input.entrySet()) {
                    entry.getKey().unwrapKey().ifPresent(k -> keyMap.put(k.location().toString(), entry.getValue()));
                }
                return Codec.unboundedMap((Codec)Codec.STRING, (Codec)valueCodec).encode(keyMap, (DynamicOps)encoderOps, prefix);
            }
        };
    }

    public static <K, V> Codec<Multimap<Holder<K>, V>> registryMultimapCodec(ResourceKey<Registry<K>> keyRegistry, Codec<V> valueCodec) {
        return ExtraCodecs.registryMapCodec(keyRegistry, valueCodec.listOf()).xmap(map -> {
            HashMultimap multimap = HashMultimap.create();
            for (Map.Entry entry : map.entrySet()) {
                multimap.putAll((Object)((Holder)entry.getKey()), (Iterable)entry.getValue());
            }
            return multimap;
        }, multimap -> {
            HashMap fastMultiMap = new HashMap();
            for (Map.Entry entry : multimap.asMap().entrySet()) {
                fastMultiMap.put((Holder)entry.getKey(), new ArrayList((Collection)entry.getValue()));
            }
            return fastMultiMap;
        });
    }
}

