/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement.sub_type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.impl.RequirementHolder;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.sub_type.EntitySubRequirement;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.entity.EntityHelper;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public record PlayerDataRequirement(IntegerBounds level, Optional<GameType> gameType, NegatableList<StatRequirement> stats, Optional<Map<ResourceLocation, Boolean>> recipes, Optional<Map<ResourceLocation, Either<AdvancementCompletionRequirement, AdvancementCriteriaRequirement>>> advancements, EntityRequirement lookingAt) implements EntitySubRequirement,
RequirementHolder
{
    @Override
    public MapCodec<? extends EntitySubRequirement> getCodec() {
        return PlayerDataRequirement.getCodec(EntityRequirement.getCodec());
    }

    public static MapCodec<PlayerDataRequirement> getCodec(Codec<EntityRequirement> lastCodec) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)IntegerBounds.CODEC.optionalFieldOf("level", (Object)IntegerBounds.NONE).forGetter(requirement -> requirement.level), (App)GameType.CODEC.optionalFieldOf("game_mode").forGetter(PlayerDataRequirement::gameType), (App)NegatableList.listCodec(StatRequirement.CODEC).optionalFieldOf("stats", new NegatableList()).forGetter(PlayerDataRequirement::stats), (App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, (Codec)Codec.BOOL).optionalFieldOf("recipes").forGetter(PlayerDataRequirement::recipes), (App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, (Codec)Codec.either(AdvancementCompletionRequirement.CODEC, AdvancementCriteriaRequirement.CODEC)).optionalFieldOf("advancements").forGetter(PlayerDataRequirement::advancements), (App)lastCodec.optionalFieldOf("looking_at", (Object)EntityRequirement.NONE).forGetter(PlayerDataRequirement::lookingAt)).apply((Applicative)instance, PlayerDataRequirement::new));
    }

    @Override
    public boolean test(Entity entity, Level level, Vec3 position) {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        ServerPlayer serverPlayer = EntityHelper.getServerPlayer(player);
        if (!this.level.test(serverPlayer.experienceLevel)) {
            return false;
        }
        if (this.gameType.isPresent() && serverPlayer.gameMode.getGameModeForPlayer() != this.gameType.get()) {
            return false;
        }
        if (!this.stats.test((T stat) -> stat.test(stat.stat(), serverPlayer.getStats().getValue(stat.stat())))) {
            return false;
        }
        if (this.recipes.isPresent()) {
            for (Map.Entry<ResourceLocation, Boolean> entry : this.recipes.get().entrySet()) {
                if (serverPlayer.getRecipeBook().contains(entry.getKey()) == entry.getValue().booleanValue()) continue;
                return false;
            }
        }
        if (this.advancements.isPresent()) {
            for (Map.Entry<ResourceLocation, Boolean> entry : this.advancements.get().entrySet()) {
                AdvancementProgress progress = serverPlayer.getAdvancements().getOrStartProgress(serverPlayer.getServer().getAdvancements().get(entry.getKey()));
                if (!((Boolean)((Either)entry.getValue()).map(complete -> complete.test(progress), criteria -> criteria.test(progress))).booleanValue()) continue;
                return false;
            }
        }
        if (this.lookingAt != EntityRequirement.NONE) {
            Vec3 vec3 = player.getEyePosition();
            Vec3 vec32 = player.getViewVector(1.0f);
            Vec3 vec322 = vec3.add(vec32.x * 100.0, vec32.y * 100.0, vec32.z * 100.0);
            EntityHitResult entityhitresult = ProjectileUtil.getEntityHitResult((Level)player.level(), (Entity)player, (Vec3)vec3, (Vec3)vec322, (AABB)new AABB(vec3, vec322).inflate(1.0), ent -> !ent.isSpectator(), (float)0.0f);
            if (entityhitresult == null || entityhitresult.getType() != HitResult.Type.ENTITY) {
                return false;
            }
            Entity hitEntity = entityhitresult.getEntity();
            if (!this.lookingAt.test(hitEntity)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String toString() {
        return CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("serialize_failed");
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PlayerDataRequirement that = (PlayerDataRequirement)obj;
        return this.gameType.equals(that.gameType) && this.stats.equals(that.stats) && this.recipes.equals(that.recipes) && this.advancements.equals(that.advancements) && this.lookingAt.equals(that.lookingAt);
    }

    public record AdvancementCriteriaRequirement(Map<String, Boolean> criteria) {
        public static final Codec<AdvancementCriteriaRequirement> CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.BOOL).xmap(AdvancementCriteriaRequirement::new, AdvancementCriteriaRequirement::criteria);

        public boolean test(AdvancementProgress progress) {
            for (Map.Entry<String, Boolean> entry : this.criteria.entrySet()) {
                CriterionProgress criterionprogress = progress.getCriterion(entry.getKey());
                if (criterionprogress != null && criterionprogress.isDone() == entry.getValue().booleanValue()) continue;
                return false;
            }
            return true;
        }

        @Override
        public String toString() {
            return CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("serialize_failed");
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            AdvancementCriteriaRequirement that = (AdvancementCriteriaRequirement)obj;
            return this.criteria.equals(that.criteria);
        }
    }

    public record AdvancementCompletionRequirement(Boolean complete) {
        public static final Codec<AdvancementCompletionRequirement> CODEC = Codec.BOOL.xmap(AdvancementCompletionRequirement::new, AdvancementCompletionRequirement::complete);

        public boolean test(AdvancementProgress progress) {
            return progress.isDone() == this.complete.booleanValue();
        }

        @Override
        public String toString() {
            return CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("serialize_failed");
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            AdvancementCompletionRequirement that = (AdvancementCompletionRequirement)obj;
            return this.complete.equals(that.complete);
        }
    }

    public record StatRequirement(StatType<?> type, ResourceLocation statId, Stat<?> stat, IntegerBounds value) {
        public static final Codec<StatRequirement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.STAT_TYPE.byNameCodec().fieldOf("type").forGetter(stat -> stat.type), (App)ResourceLocation.CODEC.fieldOf("stat").forGetter(stat -> stat.statId), (App)IntegerBounds.CODEC.fieldOf("value").forGetter(stat -> stat.value)).apply((Applicative)instance, StatRequirement::new));

        public StatRequirement(StatType<?> type, ResourceLocation statId, IntegerBounds value) {
            this(type, statId, (Stat)type.getRegistry().get(statId), value);
        }

        public boolean test(Stat<?> stat, int value) {
            return stat.getType() == this.type && this.stat.equals(stat) && this.value.test(value);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            StatRequirement that = (StatRequirement)obj;
            return this.type.equals(that.type) && this.statId.equals((Object)that.statId) && this.value.equals(that.value);
        }

        @Override
        public String toString() {
            return CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("serialize_failed");
        }
    }
}

