/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.serialization.Codec;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;

public record NbtRequirement(CompoundTag tag) {
    public static final Codec<NbtRequirement> CODEC = CompoundTag.CODEC.xmap(NbtRequirement::new, NbtRequirement::tag);
    public static final NbtRequirement NONE = new NbtRequirement();

    public NbtRequirement() {
        this(new CompoundTag());
    }

    public boolean test(Entity entity) {
        return this.tag().isEmpty() || this.test(NbtPredicate.getEntityTagToCompare((Entity)entity));
    }

    public boolean test(@Nullable CompoundTag nbt) {
        if (nbt == null) {
            return this.tag().isEmpty();
        }
        return NbtRequirement.compareNbt((Tag)this.tag, (Tag)nbt, true);
    }

    public boolean isEmpty() {
        return this.tag.isEmpty();
    }

    public static boolean compareNbt(@Nullable Tag tag, @Nullable Tag other, boolean compareListTag) {
        if (tag == other) {
            return true;
        }
        if (tag == null) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (tag.equals((Object)other)) {
            return true;
        }
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            return NbtRequirement.handleCompoundTagComparison(compoundTag, other, compareListTag);
        }
        if (tag instanceof ListTag && other instanceof ListTag && compareListTag) {
            return NbtRequirement.compareListTags((ListTag)tag, (ListTag)other, compareListTag);
        }
        if (tag instanceof StringTag) {
            StringTag string = (StringTag)tag;
            if (other instanceof NumericTag) {
                NumericTag numericTag = (NumericTag)other;
                return NbtRequirement.compareNumericRange(string, numericTag);
            }
        }
        if (tag instanceof NumericTag) {
            NumericTag numericTag = (NumericTag)tag;
            if (other instanceof NumericTag) {
                NumericTag otherNumeric = (NumericTag)other;
                return NbtRequirement.compareNumbers(numericTag, otherNumeric);
            }
        }
        return false;
    }

    private static boolean handleCompoundTagComparison(CompoundTag compoundTag, Tag other, boolean compareListTag) {
        ListTag containsAllValues;
        if (other instanceof CompoundTag) {
            CompoundTag otherCompound = (CompoundTag)other;
            for (String key : compoundTag.getAllKeys()) {
                if (NbtRequirement.compareNbt(compoundTag.get(key), otherCompound.get(key), compareListTag)) continue;
                return false;
            }
            return true;
        }
        if (compoundTag.getAllKeys().size() != 1) {
            return false;
        }
        ListTag anyOfValues = (ListTag)compoundTag.get("cs:any_of");
        if (anyOfValues != null && !anyOfValues.isEmpty()) {
            for (int i = 0; i < anyOfValues.size(); ++i) {
                Tag value = anyOfValues.get(i);
                if (!NbtRequirement.compareNbt(value, other, compareListTag)) continue;
                return true;
            }
            return false;
        }
        ListTag containsAnyValues = (ListTag)compoundTag.get("cs:contains_any");
        if (containsAnyValues != null && !containsAnyValues.isEmpty() && other instanceof ListTag) {
            ListTag otherList = (ListTag)other;
            for (int i = 0; i < containsAnyValues.size(); ++i) {
                Tag value = containsAnyValues.get(i);
                for (int i1 = 0; i1 < otherList.size(); ++i1) {
                    Tag otherValue = otherList.get(i1);
                    if (!NbtRequirement.compareNbt(value, otherValue, compareListTag)) continue;
                    return true;
                }
            }
        }
        if ((containsAllValues = (ListTag)compoundTag.get("cs:contains_all")) != null && !containsAllValues.isEmpty() && other instanceof ListTag) {
            ListTag otherList = (ListTag)other;
            block4: for (int i = 0; i < containsAllValues.size(); ++i) {
                Tag value = containsAllValues.get(i);
                for (int i1 = 0; i1 < otherList.size(); ++i1) {
                    Tag otherValue = otherList.get(i1);
                    if (NbtRequirement.compareNbt(value, otherValue, compareListTag)) continue block4;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean compareListTags(ListTag list1, ListTag list2, boolean compareListTag) {
        if (list1.isEmpty()) {
            return list2.isEmpty();
        }
        return list1.stream().allMatch(element -> IntStream.range(0, list2.size()).anyMatch(j -> NbtRequirement.compareNbt(element, list2.get(j), compareListTag)));
    }

    private static boolean compareNumericRange(StringTag rangeTag, NumericTag numberTag) {
        try {
            String[] parts = rangeTag.getAsString().split("-");
            if (parts.length != 2) {
                return false;
            }
            double min = Double.parseDouble(parts[0]);
            double max = Double.parseDouble(parts[1]);
            double value = numberTag.getAsDouble();
            return CSMath.betweenInclusive(value, min, max);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean compareNumbers(NumericTag tag, NumericTag other) {
        return tag.getAsDouble() == other.getAsDouble();
    }

    @Override
    public String toString() {
        return "NbtRequirement{tag=" + String.valueOf(this.tag) + "}";
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NbtRequirement that = (NbtRequirement)obj;
        return this.tag.equals((Object)that.tag);
    }
}

