/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.serialization.RegistryHelper;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.item.ItemParser;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public record ItemComponentsRequirement(Map<DataComponentType<?>, Object> components) {
    public static final Codec<ItemComponentsRequirement> CODEC = CompoundTag.CODEC.xmap(ItemComponentsRequirement::deserialize, ItemComponentsRequirement::serialize);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemComponentsRequirement> STREAM_CODEC = StreamCodec.of((buf, requirement) -> buf.writeNbt((Tag)requirement.serialize()), buf -> ItemComponentsRequirement.deserialize(buf.readNbt()));

    public ItemComponentsRequirement() {
        this(new HashMap());
    }

    public boolean test(ItemStack pStack) {
        return this.components().isEmpty() || this.test(pStack.getComponents());
    }

    public boolean test(@Nullable DataComponentMap components) {
        if (components == null) {
            return this.components().isEmpty();
        }
        return this.components().keySet().stream().allMatch(component -> CSMath.getIfNotNull(components.get(component), other -> this.compareComponents(this.components().get(component), other), false));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean compareComponents(Object predicate, Object component) {
        String string;
        if (predicate == component) {
            return true;
        }
        if (predicate == null) {
            return true;
        }
        if (component == null) {
            return false;
        }
        if (predicate.equals(component)) {
            return true;
        }
        if (predicate instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)predicate;
            if (!(component instanceof CompoundTag)) {
                Tag value;
                ListTag anyOfValues = (ListTag)compoundTag.get("cs:any_of");
                if (anyOfValues == null) return false;
                if (anyOfValues.isEmpty()) return false;
                Iterator iterator = anyOfValues.iterator();
                do {
                    if (!iterator.hasNext()) return false;
                } while (!this.compareComponents(value = (Tag)iterator.next(), component));
                return true;
            }
        }
        if (!(component instanceof Number)) return false;
        Number num = (Number)component;
        if (predicate instanceof String) {
            String str;
            string = str = (String)predicate;
        } else {
            if (!(predicate instanceof StringTag)) return false;
            StringTag stringTag = (StringTag)predicate;
            string = stringTag.getAsString();
        }
        String range = string;
        if (range == null) {
            return false;
        }
        String[] parts = range.split("-");
        if (parts.length != 2) {
            return false;
        }
        double min = Double.parseDouble(parts[0]);
        double max = Double.parseDouble(parts[1]);
        return CSMath.betweenInclusive(num.doubleValue(), min, max);
    }

    public static ItemComponentsRequirement parse(String data) {
        RegistryAccess registryAccess = RegistryHelper.getRegistryAccess();
        if (registryAccess == null) {
            return new ItemComponentsRequirement();
        }
        ItemParser parser = new ItemParser((HolderLookup.Provider)registryAccess);
        final HashMap parsedComponents = new HashMap();
        try {
            parser.parse(new StringReader(data), new ItemParser.Visitor(){

                public <T> void visitComponent(DataComponentType<T> componentType, T value) {
                    parsedComponents.put(componentType, value);
                }

                public <T> void visitRemovedComponent(DataComponentType<T> componentType) {
                    parsedComponents.remove(componentType);
                }
            });
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
        return new ItemComponentsRequirement(parsedComponents);
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        for (DataComponentType<?> componentType : this.components().keySet()) {
            String key = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey(componentType).toString();
            Tag component = this.serializeComponent(componentType, this.components().get(componentType));
            if (component == null) continue;
            tag.put(key, component);
        }
        return tag;
    }

    private Tag serializeComponent(DataComponentType componentType, Object component) {
        Object object = component;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, CompoundTag.class}, (Object)object2, n)) {
            case 0: {
                String string = (String)object2;
                return StringTag.valueOf((String)string);
            }
            case 1: {
                CompoundTag tag = (CompoundTag)object2;
                return tag;
            }
        }
        TypedDataComponent typed = new TypedDataComponent(componentType, component);
        return (Tag)typed.encodeValue((DynamicOps)NbtOps.INSTANCE).getOrThrow();
    }

    public static ItemComponentsRequirement deserialize(CompoundTag nbt) {
        HashMap components = new HashMap();
        for (String key : nbt.getAllKeys()) {
            DataComponentType componentType;
            ResourceLocation resourceLocation = ResourceLocation.tryParse((String)key);
            if (resourceLocation == null || (componentType = (DataComponentType)BuiltInRegistries.DATA_COMPONENT_TYPE.get(resourceLocation)) == null) continue;
            Tag tag = nbt.get(key);
            Object value = ItemComponentsRequirement.deserializeComponent(componentType, tag);
            components.put(componentType, value);
        }
        return new ItemComponentsRequirement(components);
    }

    private static Object deserializeComponent(DataComponentType<?> componentType, Tag tag) {
        Tag tag2 = tag;
        Objects.requireNonNull(tag2);
        Tag tag3 = tag2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StringTag.class, CompoundTag.class}, (Object)tag3, n)) {
            case 0: {
                StringTag stringTag = (StringTag)tag3;
                return stringTag.getAsString();
            }
            case 1: {
                CompoundTag compoundTag = (CompoundTag)tag3;
                return compoundTag;
            }
        }
        return componentType.codec().decode((DynamicOps)NbtOps.INSTANCE, (Object)tag).getOrThrow();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ItemComponentsRequirement that = (ItemComponentsRequirement)obj;
        return this.components.equals(that.components);
    }

    @Override
    public String toString() {
        return "ItemComponents{components=" + String.valueOf(this.components) + "}";
    }
}

