/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.api.annotation.Internal;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.serialization.NbtSerializable;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.util.StringRepresentable;

public abstract class ConfigData
implements NbtSerializable {
    protected UUID id = UUID.randomUUID();
    protected Type registryType = Type.JSON;
    protected NegatableList<String> requiredMods;
    protected static final Codec<Dummy> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)NegatableList.listCodec(Codec.STRING).optionalFieldOf("required_mods", new NegatableList()).forGetter(ConfigData::requiredMods), (App)Type.CODEC.optionalFieldOf("config_type", (Object)Type.JSON).forGetter(ConfigData::registryType), (App)Codec.STRING.xmap(UUID::fromString, UUID::toString).optionalFieldOf("id", (Object)UUID.randomUUID()).forGetter(ConfigData::uuid)).apply((Applicative)instance, Dummy::new));

    public ConfigData(NegatableList<String> requiredMods, Type configType, UUID id) {
        this.requiredMods = requiredMods;
        this.registryType = configType;
        this.id = id;
    }

    public ConfigData(NegatableList<String> requiredMods) {
        this.requiredMods = requiredMods;
    }

    public abstract Codec<? extends ConfigData> getCodec();

    protected static <T extends ConfigData> Codec<T> createCodec(final Codec<T> child) {
        return new Codec<T>(){

            public <T1> DataResult<Pair<T, T1>> decode(DynamicOps<T1> ops, T1 input) {
                return child.decode(ops, input).map(pair -> {
                    ConfigData data = (ConfigData)pair.getFirst();
                    CODEC.decode(ops, input).result().map(Pair::getFirst).ifPresent(dummy -> {
                        data.requiredMods = dummy.requiredMods();
                        data.id = dummy.uuid();
                        data.registryType = dummy.registryType();
                    });
                    return Pair.of((Object)data, (Object)input);
                });
            }

            public <T1> DataResult<T1> encode(T input, DynamicOps<T1> ops, T1 prefix) {
                Dummy dummy = new Dummy(((ConfigData)input).requiredMods(), ((ConfigData)input).registryType(), ((ConfigData)input).uuid());
                return child.encode(input, ops, CODEC.encodeStart(ops, (Object)dummy).result().orElse(ops.empty()));
            }
        };
    }

    public UUID uuid() {
        if (this.id == null) {
            this.id = UUID.randomUUID();
        }
        return this.id;
    }

    public Type registryType() {
        return this.registryType;
    }

    public NegatableList<String> requiredMods() {
        return this.requiredMods;
    }

    @Internal
    public void setId(UUID id) {
        this.id = id;
    }

    @Internal
    public void setRegistryType(Type registryType) {
        this.registryType = registryType;
    }

    @Override
    public CompoundTag serialize() {
        return this.getCodec().encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this).result().orElse(new CompoundTag());
    }

    public String toString() {
        return this.getClass().getSimpleName() + String.valueOf(this.getCodec().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse(""));
    }

    public boolean areRequiredModsLoaded() {
        return this.requiredMods.test(mod -> mod.equals("minecraft") || CompatManager.modLoaded(mod));
    }

    public boolean equals(Object obj) {
        ConfigData data;
        return obj instanceof ConfigData && (data = (ConfigData)obj).requiredMods().equals(this.requiredMods());
    }

    public static enum Type implements StringRepresentable
    {
        TOML("toml"),
        JSON("json"),
        KUBEJS("kubejs");

        public static final Codec<Type> CODEC;
        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
        }
    }

    protected static class Dummy
    extends ConfigData {
        public Dummy(NegatableList<String> requiredMods, Type configType, UUID id) {
            super(requiredMods, configType, id);
        }

        @Override
        public Codec<? extends ConfigData> getCodec() {
            return CODEC;
        }
    }
}

