/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.ModRegistries;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.requirement.NbtRequirement;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class RemoveRegistryData<T extends ConfigData>
extends ConfigData {
    private final ResourceKey<Registry<T>> registry;
    private final NegatableList<NbtRequirement> matches;
    private final List<ResourceLocation> entries;
    private final List<ConfigData.Type> registryTypes;
    private static final Codec<List<ConfigData.Type>> CONFIG_TYPE_CODEC = Codec.either(ConfigData.Type.CODEC, (Codec)ConfigData.Type.CODEC.listOf()).xmap(either -> (List)either.map(List::of, r -> r), Either::right);
    public static final Codec<RemoveRegistryData<?>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.xmap(s -> ModRegistries.getRegistry(s), key -> ModRegistries.getRegistryName((ResourceKey<? extends ConfigData>)key)).fieldOf("registry").forGetter(data -> data.registry()), (App)NegatableList.listCodec(NbtRequirement.CODEC).optionalFieldOf("matches", new NegatableList()).forGetter(RemoveRegistryData::matches), (App)ResourceLocation.CODEC.listOf().optionalFieldOf("entries", List.of()).forGetter(RemoveRegistryData::entries), (App)CONFIG_TYPE_CODEC.optionalFieldOf("config_type", List.of()).forGetter(RemoveRegistryData::configTypes)).apply((Applicative)instance, RemoveRegistryData::new));

    public RemoveRegistryData(ResourceKey<Registry<T>> registry, NegatableList<NbtRequirement> matches, List<ResourceLocation> entries, List<ConfigData.Type> registryTypes) {
        super(new NegatableList<String>());
        this.registry = registry;
        this.matches = matches;
        this.entries = entries;
        this.registryTypes = registryTypes;
    }

    public ResourceKey<Registry<T>> registry() {
        return this.registry;
    }

    public NegatableList<NbtRequirement> matches() {
        return this.matches;
    }

    public List<ResourceLocation> entries() {
        return this.entries;
    }

    public List<ConfigData.Type> configTypes() {
        return this.registryTypes;
    }

    private boolean checkType(T object) {
        return this.registryTypes.isEmpty() || this.registryTypes.contains((Object)((ConfigData)object).registryType());
    }

    public boolean matches(T object) {
        if (!this.checkType(object)) {
            return false;
        }
        Optional serializedOpt = ModRegistries.getCodec(this.registry).encodeStart((DynamicOps)NbtOps.INSTANCE, object).result();
        return serializedOpt.map(serialized -> this.matches.test(nbt -> nbt.test((CompoundTag)serialized))).orElse(false);
    }

    public boolean matches(Holder<T> holder) {
        if (!this.checkType((ConfigData)holder.value())) {
            return false;
        }
        ResourceLocation key = holder.unwrapKey().map(ResourceKey::location).orElse(null);
        if (key != null && this.entries.contains(key)) {
            return true;
        }
        return this.matches((ConfigData)holder.value());
    }

    @Override
    public Codec<? extends ConfigData> getCodec() {
        return CODEC;
    }
}

