/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.impl.RequirementHolder;
import com.momosoftworks.coldsweat.data.codec.requirement.ItemComponentsRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.ItemRequirement;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemInsulationSlotsData
extends ConfigData
implements RequirementHolder {
    final NegatableList<ItemRequirement> item;
    final int slots;
    public static final Codec<ItemInsulationSlotsData> CODEC = ItemInsulationSlotsData.createCodec(RecordCodecBuilder.create(instance -> instance.group((App)NegatableList.codec(ItemRequirement.CODEC).optionalFieldOf("item", new NegatableList()).forGetter(ItemInsulationSlotsData::item), (App)Codec.INT.fieldOf("slots").forGetter(ItemInsulationSlotsData::slots)).apply((Applicative)instance, ItemInsulationSlotsData::new)));

    public ItemInsulationSlotsData(NegatableList<ItemRequirement> item, int slots, NegatableList<String> requiredMods) {
        super(requiredMods);
        this.item = item;
        this.slots = slots;
    }

    public ItemInsulationSlotsData(NegatableList<ItemRequirement> item, int slots) {
        this(item, slots, new NegatableList<String>());
    }

    public NegatableList<ItemRequirement> item() {
        return this.item;
    }

    public int slots() {
        return this.slots;
    }

    @Override
    public boolean test(ItemStack stack) {
        return this.item.test((T req) -> req.test(stack, true));
    }

    @Nullable
    public static ItemInsulationSlotsData fromToml(List<?> entry) {
        if (entry.size() < 2) {
            ColdSweat.LOGGER.error("Error parsing insulation slot override config: not enough arguments");
            return null;
        }
        List<Either<TagKey<Item>, Item>> items = ConfigHelper.getItems((String)entry.get(0));
        if (items.isEmpty()) {
            return null;
        }
        int slots = ((Number)entry.get(1)).intValue();
        ItemComponentsRequirement componentsRequirement = entry.size() > 2 ? ItemComponentsRequirement.parse((String)entry.get(2)) : new ItemComponentsRequirement();
        ItemRequirement itemRequirement = new ItemRequirement(items, componentsRequirement);
        return new ItemInsulationSlotsData(new NegatableList<ItemRequirement>(itemRequirement), slots);
    }

    @Override
    public Codec<? extends ConfigData> getCodec() {
        return CODEC;
    }
}

