/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.impl.RequirementHolder;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.ItemComponentsRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.ItemRequirement;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class FoodData
extends ConfigData
implements RequirementHolder {
    final NegatableList<ItemRequirement> item;
    final Double temperature;
    final int duration;
    final NegatableList<EntityRequirement> entityRequirement;
    public static final Codec<FoodData> CODEC = FoodData.createCodec(RecordCodecBuilder.create(instance -> instance.group((App)NegatableList.codec(ItemRequirement.CODEC).optionalFieldOf("item", new NegatableList()).forGetter(FoodData::item), (App)Codec.DOUBLE.fieldOf("temperature").forGetter(FoodData::temperature), (App)Codec.INT.optionalFieldOf("duration", (Object)0).forGetter(FoodData::duration), (App)NegatableList.codec(EntityRequirement.getCodec()).optionalFieldOf("entity", new NegatableList()).forGetter(FoodData::entityRequirement)).apply((Applicative)instance, FoodData::new)));

    public FoodData(NegatableList<ItemRequirement> item, Double temperature, int duration, NegatableList<EntityRequirement> entityRequirement, NegatableList<String> requiredMods) {
        super(requiredMods);
        this.temperature = temperature;
        this.item = item;
        this.duration = duration;
        this.entityRequirement = entityRequirement;
    }

    public FoodData(NegatableList<ItemRequirement> item, Double temperature, int duration, NegatableList<EntityRequirement> entityRequirement) {
        this(item, temperature, duration, entityRequirement, new NegatableList<String>());
    }

    public NegatableList<ItemRequirement> item() {
        return this.item;
    }

    public Double temperature() {
        return this.temperature;
    }

    public int duration() {
        return this.duration;
    }

    public NegatableList<EntityRequirement> entityRequirement() {
        return this.entityRequirement;
    }

    @Override
    public boolean test(ItemStack stack) {
        return this.item.test((T req) -> req.test(stack, true));
    }

    @Override
    public boolean test(Entity entity) {
        return this.entityRequirement.test((T req) -> req.test(entity));
    }

    @Nullable
    public static FoodData fromToml(List<?> entry) {
        if (entry.size() < 2) {
            ColdSweat.LOGGER.error("Error parsing food config: not enough arguments");
            return null;
        }
        List<Either<TagKey<Item>, Item>> items = ConfigHelper.getItems((String)entry.get(0));
        if (items.isEmpty()) {
            return null;
        }
        double temperature = ((Number)entry.get(1)).doubleValue();
        ItemComponentsRequirement componentsRequirement = entry.size() > 2 ? ItemComponentsRequirement.parse((String)entry.get(2)) : new ItemComponentsRequirement();
        int duration = entry.size() > 3 ? ((Number)entry.get(3)).intValue() : 0;
        ItemRequirement itemRequirement = new ItemRequirement(items, componentsRequirement);
        return new FoodData(new NegatableList<ItemRequirement>(itemRequirement), temperature, duration, new NegatableList<EntityRequirement>());
    }

    public Codec<FoodData> getCodec() {
        return CODEC;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FoodData that = (FoodData)obj;
        return super.equals(obj) && this.item.equals(that.item) && this.temperature.equals(that.temperature) && this.duration == that.duration && this.entityRequirement.equals(that.entityRequirement);
    }
}

