/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.impl.RequirementHolder;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.ItemComponentsRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.ItemRequirement;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class DryingItemData
extends ConfigData
implements RequirementHolder {
    private final NegatableList<ItemRequirement> item;
    private final ItemStack result;
    private final NegatableList<EntityRequirement> entity;
    private final SoundEvent sound;
    public static final Codec<DryingItemData> CODEC = DryingItemData.createCodec(RecordCodecBuilder.create(builder -> builder.group((App)NegatableList.codec(ItemRequirement.CODEC).fieldOf("item").forGetter(data -> data.item), (App)ItemStack.CODEC.optionalFieldOf("result", (Object)ItemStack.EMPTY).forGetter(data -> data.result), (App)NegatableList.codec(EntityRequirement.getCodec()).optionalFieldOf("entity", new NegatableList()).forGetter(data -> data.entity), (App)SoundEvent.DIRECT_CODEC.optionalFieldOf("sound", (Object)SoundEvents.WET_GRASS_STEP).forGetter(data -> data.sound)).apply((Applicative)builder, DryingItemData::new)));

    public DryingItemData(NegatableList<ItemRequirement> item, ItemStack result, NegatableList<EntityRequirement> entity, SoundEvent sound, NegatableList<String> requiredMods) {
        super(requiredMods);
        this.item = item;
        this.result = result;
        this.entity = entity;
        this.sound = sound;
    }

    public DryingItemData(NegatableList<ItemRequirement> item, ItemStack result, NegatableList<EntityRequirement> entity, SoundEvent sound) {
        this(item, result, entity, sound, new NegatableList<String>(BuiltInRegistries.ITEM.getKey((Object)result.getItem()).getNamespace()));
    }

    public NegatableList<ItemRequirement> item() {
        return this.item;
    }

    public ItemStack result() {
        return this.result;
    }

    public NegatableList<EntityRequirement> entity() {
        return this.entity;
    }

    public SoundEvent sound() {
        return this.sound;
    }

    @Nullable
    public static DryingItemData fromToml(List<?> entry) {
        ResourceLocation sound;
        if (entry.size() < 2) {
            ColdSweat.LOGGER.error("Error parsing drying item config: not enough arguments");
            return null;
        }
        List<Either<TagKey<Item>, Item>> items = ConfigHelper.getItems((String)entry.get(0));
        if (items.isEmpty()) {
            return null;
        }
        Item result = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)((String)entry.get(1))));
        if (result == null) {
            return null;
        }
        ResourceLocation resourceLocation = sound = entry.size() > 2 ? ResourceLocation.parse((String)((String)entry.get(2))) : ResourceLocation.parse((String)"minecraft:block.wet_grass.step");
        if (result != null) {
            ItemRequirement input = new ItemRequirement(items, new ItemComponentsRequirement());
            return new DryingItemData(new NegatableList<ItemRequirement>(input), new ItemStack((ItemLike)result), new NegatableList<EntityRequirement>(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(sound));
        }
        return null;
    }

    @Override
    public boolean test(Entity entity) {
        return this.entity.test((T req) -> req.test(entity));
    }

    @Override
    public boolean test(ItemStack stack) {
        return this.item.test((T req) -> req.test(stack, true));
    }

    @Override
    public Codec<? extends ConfigData> getCodec() {
        return CODEC;
    }
}

