/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;

public class BiomeTempData
extends ConfigData {
    final NegatableList<Either<TagKey<Biome>, Holder<Biome>>> biomes;
    final double min;
    final double max;
    final Temperature.Units units;
    final boolean isOffset;
    final boolean isDisabled;
    public static final Codec<BiomeTempData> CODEC = BiomeTempData.createCodec(RecordCodecBuilder.create(instance -> instance.group((App)NegatableList.listCodec(ConfigHelper.tagOrHolderCodec(Registries.BIOME, Biome.CODEC)).fieldOf("biomes").forGetter(BiomeTempData::biomes), (App)Codec.mapEither((MapCodec)Codec.DOUBLE.optionalFieldOf("temperature", (Object)0.0), (MapCodec)Codec.DOUBLE.optionalFieldOf("min_temp", (Object)0.0)).xmap(either -> (Double)either.map(left -> left, right -> right), Either::right).forGetter(BiomeTempData::min), (App)Codec.mapEither((MapCodec)Codec.DOUBLE.optionalFieldOf("temperature", (Object)0.0), (MapCodec)Codec.DOUBLE.optionalFieldOf("max_temp", (Object)0.0)).xmap(either -> (Double)either.map(left -> left, right -> right), Either::right).forGetter(BiomeTempData::max), (App)Temperature.Units.CODEC.optionalFieldOf("units", (Object)Temperature.Units.MC).forGetter(BiomeTempData::units), (App)Codec.BOOL.optionalFieldOf("is_offset", (Object)false).forGetter(BiomeTempData::isOffset), (App)Codec.BOOL.optionalFieldOf("disable", (Object)false).forGetter(BiomeTempData::isDisabled)).apply((Applicative)instance, BiomeTempData::new)));

    public BiomeTempData(NegatableList<Either<TagKey<Biome>, Holder<Biome>>> biomes, double min, double max, Temperature.Units units, boolean isOffset, boolean isDisabled, NegatableList<String> requiredMods) {
        super(requiredMods);
        this.biomes = biomes;
        this.min = min;
        this.max = max;
        this.units = units;
        this.isOffset = isOffset;
        this.isDisabled = isDisabled;
    }

    public BiomeTempData(NegatableList<Either<TagKey<Biome>, Holder<Biome>>> biomes, double min, double max, Temperature.Units units, boolean isOffset, boolean isDisabled) {
        this(biomes, min, max, units, isOffset, isDisabled, new NegatableList<String>());
    }

    public BiomeTempData(Holder<Biome> biome, double min, double max, Temperature.Units units, boolean isOffset, boolean isDisabled) {
        this(new NegatableList<Either<TagKey<Biome>, Holder<Biome>>>(Either.right(biome)), min, max, units, isOffset, isDisabled);
    }

    public NegatableList<Either<TagKey<Biome>, Holder<Biome>>> biomes() {
        return this.biomes;
    }

    public double min() {
        return this.min;
    }

    public double max() {
        return this.max;
    }

    public Temperature.Units units() {
        return this.units;
    }

    public boolean isOffset() {
        return this.isOffset;
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public double minTemp() {
        return Temperature.convert(this.min, this.units, Temperature.Units.MC, !this.isOffset);
    }

    public double maxTemp() {
        return Temperature.convert(this.max, this.units, Temperature.Units.MC, !this.isOffset);
    }

    @Nullable
    public static BiomeTempData fromToml(List<?> entry, boolean isOffset, RegistryAccess registryAccess) {
        boolean isDisabled;
        double max;
        double min;
        Temperature.Units units;
        String string;
        if (!(entry.size() == 2 && entry.get(1) instanceof String || entry.size() >= 3)) {
            ColdSweat.LOGGER.error("Error parsing biome config: not enough arguments");
            return null;
        }
        List biomes = ConfigHelper.parseRegistryItems(Registries.BIOME, registryAccess, (String)entry.get(0));
        if (biomes.isEmpty()) {
            return null;
        }
        Object obj = entry.get(1);
        if (obj instanceof String && (string = (String)obj).equals("disable")) {
            units = Temperature.Units.MC;
            min = 0.0;
            max = 0.0;
            isDisabled = true;
        } else {
            units = entry.size() == 4 ? Temperature.Units.valueOf(((String)entry.get(3)).toUpperCase()) : Temperature.Units.MC;
            min = ((Number)entry.get(1)).doubleValue();
            max = ((Number)entry.get(2)).doubleValue();
            isDisabled = false;
        }
        return new BiomeTempData(new NegatableList<Either<TagKey<Biome>, Holder<Biome>>>(biomes), min, max, units, isOffset, isDisabled);
    }

    public Codec<BiomeTempData> getCodec() {
        return CODEC;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BiomeTempData that = (BiomeTempData)obj;
        return super.equals(obj) && Double.compare(that.min, this.min) == 0 && Double.compare(that.max, this.max) == 0 && this.isOffset == that.isOffset && this.biomes.equals(that.biomes) && this.units == that.units;
    }
}

