/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.biome_modifier;

import com.mojang.serialization.MapCodec;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.ModBiomeModifiers;
import com.momosoftworks.coldsweat.data.codec.configuration.SpawnBiomeData;
import com.momosoftworks.coldsweat.data.codec.util.FunctionalSpawnerData;
import com.momosoftworks.coldsweat.util.serialization.RegistryHelper;
import java.util.Collection;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;

public record AddSpawnsBiomeModifier(boolean useConfigs) implements BiomeModifier
{
    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD && this.useConfigs) {
            Collection spawns = ConfigSettings.ENTITY_SPAWN_BIOMES.get(RegistryHelper.getRegistryAccess()).get(biome);
            for (SpawnBiomeData spawn : spawns) {
                RegistryHelper.mapBuiltinRegistryTagList(BuiltInRegistries.ENTITY_TYPE, spawn.entities()).forEach(entityType -> {
                    FunctionalSpawnerData spawnerData = new FunctionalSpawnerData((EntityType<?>)entityType, spawn.weight(), spawn.count().min(), spawn.count().max(), (level, structureManager, chunkGenerator, category, data, pos) -> spawn.location().test(req -> req.test((Level)level, pos)));
                    builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).removeIf(oldData -> oldData.type == entityType);
                    builder.getMobSpawnSettings().addSpawn(MobCategory.CREATURE, (MobSpawnSettings.SpawnerData)spawnerData);
                });
            }
        }
    }

    public MapCodec<? extends BiomeModifier> codec() {
        return (MapCodec)ModBiomeModifiers.ADD_SPAWNS_CODEC.value();
    }
}

