/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.network.message;

import com.momosoftworks.coldsweat.common.entity.data.Preference;
import com.momosoftworks.coldsweat.util.ClientOnlyHelper;
import com.momosoftworks.coldsweat.util.serialization.NBTHelper;
import java.util.EnumMap;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.fml.util.thread.EffectiveSide;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SyncPreferencesMessage
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<SyncPreferencesMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"sync_preferred_units"));
    public static final StreamCodec<FriendlyByteBuf, SyncPreferencesMessage> CODEC = CustomPacketPayload.codec(SyncPreferencesMessage::encode, SyncPreferencesMessage::decode);
    EnumMap<Preference, Object> preferences = new EnumMap(Preference.class);

    public static SyncPreferencesMessage create() {
        SyncPreferencesMessage message = new SyncPreferencesMessage();
        for (Preference preference : Preference.values()) {
            message.preferences.put(preference, preference.getter().get());
        }
        return message;
    }

    public static void encode(SyncPreferencesMessage message, FriendlyByteBuf buffer) {
        if (EffectiveSide.get().isClient()) {
            SyncPreferencesMessage.savePreferences(ClientOnlyHelper.getClientPlayer(), message.preferences);
        }
        AtomicReference pref = new AtomicReference();
        buffer.writeInt(message.preferences.size());
        message.preferences.forEach((key, value) -> {
            pref.set(key);
            buffer.writeEnum((Enum)key);
            ((Preference)((Object)((Object)pref.get()))).writer().encode(buffer, value);
        });
    }

    public static SyncPreferencesMessage decode(FriendlyByteBuf buffer) {
        SyncPreferencesMessage message = new SyncPreferencesMessage();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            Preference preference = (Preference)buffer.readEnum(Preference.class);
            Object value = preference.reader().decode(buffer);
            message.preferences.put(preference, value);
        }
        return message;
    }

    public static void handle(SyncPreferencesMessage message, IPayloadContext context) {
        context.enqueueWork(() -> SyncPreferencesMessage.savePreferences(context.player(), message.preferences));
    }

    private static void savePreferences(Player player, EnumMap<Preference, Object> preferences) {
        CompoundTag nbt = player.getPersistentData();
        CompoundTag preferencesTag = new CompoundTag();
        for (Preference preference : Preference.values()) {
            preferencesTag.put(preference.key(), NBTHelper.serialize(preferences.get((Object)preference)));
        }
        nbt.put("ColdSweatPreferences", (Tag)preferencesTag);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

