/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.network.message;

import com.momosoftworks.coldsweat.core.network.message.SyncConfigSettingsMessage;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ClientConfigAskMessage
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<ClientConfigAskMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"client_config_ask"));
    public static final StreamCodec<FriendlyByteBuf, ClientConfigAskMessage> CODEC = CustomPacketPayload.codec(ClientConfigAskMessage::encode, ClientConfigAskMessage::decode);
    UUID openerUUID;

    public ClientConfigAskMessage(UUID openerUUID) {
        this.openerUUID = openerUUID;
    }

    public ClientConfigAskMessage() {
        this(null);
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeOptional(Optional.ofNullable(this.openerUUID), (buf, id) -> buf.writeUUID(id));
    }

    public static ClientConfigAskMessage decode(FriendlyByteBuf buffer) {
        return new ClientConfigAskMessage(buffer.readOptional(buf -> buf.readUUID()).orElse(null));
    }

    public static void handle(ClientConfigAskMessage message, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncConfigSettingsMessage(message.openerUUID, serverPlayer.registryAccess()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

