/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.event;

import com.momosoftworks.coldsweat.ColdSweat;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber
public class TaskScheduler {
    static final ConcurrentLinkedQueue<QueueEntry> SERVER_SCHEDULE = new ConcurrentLinkedQueue();
    static final ConcurrentLinkedQueue<QueueEntry> CLIENT_SCHEDULE = new ConcurrentLinkedQueue();

    @SubscribeEvent
    public static void tickClient(ClientTickEvent.Pre event) {
        TaskScheduler.tickScheduledTasks(CLIENT_SCHEDULE);
    }

    @SubscribeEvent
    public static void tickServer(ServerTickEvent.Pre event) {
        TaskScheduler.tickScheduledTasks(SERVER_SCHEDULE);
    }

    private static void tickScheduledTasks(ConcurrentLinkedQueue<QueueEntry> schedule) {
        if (!schedule.isEmpty()) {
            schedule.removeIf(entry -> {
                int ticks = entry.time;
                if (ticks <= 0) {
                    try {
                        entry.task.run();
                    }
                    catch (Exception e) {
                        ColdSweat.LOGGER.error("Error while running scheduled task", (Throwable)e);
                        throw e;
                    }
                    return true;
                }
                entry.time = ticks - 1;
                return false;
            });
        }
    }

    public static void scheduleServer(Runnable task, int delay) {
        SERVER_SCHEDULE.add(new QueueEntry(task, delay));
    }

    public static void scheduleClient(Runnable task, int delay) {
        CLIENT_SCHEDULE.add(new QueueEntry(task, delay));
    }

    public static void schedule(Runnable task, int delay) {
        TaskScheduler.scheduleServer(task, delay);
        TaskScheduler.scheduleClient(task, delay);
    }

    static class QueueEntry {
        private final Runnable task;
        private int time;

        public QueueEntry(Runnable task, int time) {
            this.task = task;
            this.time = time;
        }
    }
}

