/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.event;

import com.momosoftworks.coldsweat.core.init.ModItems;
import com.momosoftworks.coldsweat.core.init.ModPotions;
import com.momosoftworks.coldsweat.util.item.PotionUtils;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.brewing.BrewingRecipe;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;

@EventBusSubscriber
public class PotionRecipes {
    @SubscribeEvent
    public static void register(RegisterBrewingRecipesEvent event) {
        ItemStack awkward = PotionRecipes.createPotion((Holder<Potion>)Potions.AWKWARD);
        ItemStack icePotion = PotionRecipes.createPotion(ModPotions.ICE_RESISTANCE);
        ItemStack longIcePotion = PotionRecipes.createPotion(ModPotions.LONG_ICE_RESISTANCE);
        event.getBuilder().addRecipe((IBrewingRecipe)new WorkingBrewingRecipe(Ingredient.of((ItemStack[])new ItemStack[]{awkward}), Ingredient.of((ItemLike[])new ItemLike[]{ModItems.SOUL_SPROUT}), icePotion));
        event.getBuilder().addRecipe((IBrewingRecipe)new WorkingBrewingRecipe(Ingredient.of((ItemStack[])new ItemStack[]{icePotion}), Ingredient.of((ItemLike[])new ItemLike[]{Items.REDSTONE}), longIcePotion));
    }

    private static ItemStack createPotion(Holder<Potion> potion) {
        return PotionUtils.setPotion(Items.POTION.getDefaultInstance(), potion);
    }

    public static class WorkingBrewingRecipe
    extends BrewingRecipe {
        Ingredient potionIn;
        Ingredient reagent;
        ItemStack output;

        public WorkingBrewingRecipe(Ingredient potionIn, Ingredient reagent, ItemStack output) {
            super(potionIn, reagent, output);
            this.potionIn = potionIn;
            this.reagent = reagent;
            this.output = output.copy();
        }

        public boolean isInput(@Nonnull ItemStack potionIn) {
            if (potionIn == null) {
                return false;
            }
            ItemStack[] matchingStacks = this.potionIn.getItems();
            if (matchingStacks.length == 0) {
                return potionIn.isEmpty();
            }
            return Arrays.stream(matchingStacks).anyMatch(itemstack -> ItemStack.isSameItemSameComponents((ItemStack)itemstack, (ItemStack)potionIn));
        }

        public boolean isIngredient(ItemStack ingredient) {
            if (ingredient == null) {
                return false;
            }
            ItemStack[] matchingStacks = this.reagent.getItems();
            if (matchingStacks.length == 0) {
                return ingredient.isEmpty();
            }
            return Arrays.stream(matchingStacks).anyMatch(itemstack -> ItemStack.isSameItemSameComponents((ItemStack)itemstack, (ItemStack)ingredient));
        }
    }
}

