/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.config.spec;

import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.serialization.ListBuilder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ItemSettingsConfig {
    private static final ModConfigSpec SPEC;
    private static final ModConfigSpec.Builder BUILDER;
    public static final ModConfigSpec.ConfigValue<List<? extends List<?>>> BOILER_FUELS;
    public static final ModConfigSpec.ConfigValue<List<? extends List<?>>> ICEBOX_FUELS;
    public static final ModConfigSpec.ConfigValue<List<? extends List<?>>> HEARTH_FUELS;
    public static final ModConfigSpec.ConfigValue<List<? extends String>> HEARTH_POTION_BLACKLIST;
    public static final ModConfigSpec.BooleanValue ALLOW_POTIONS_IN_HEARTH;
    public static final ModConfigSpec.ConfigValue<List<? extends List<?>>> SOULSPRING_LAMP_FUELS;
    public static final ModConfigSpec.ConfigValue<List<? extends String>> SOULSPRING_LAMP_DIMENSIONS;
    public static final ModConfigSpec.ConfigValue<List<? extends List<?>>> FOOD_TEMPERATURES;
    public static final ModConfigSpec.ConfigValue<List<? extends List<?>>> CARRIED_ITEM_TEMPERATURES;
    public static final ModConfigSpec.ConfigValue<List<? extends List<?>>> INSULATION_ITEMS;
    public static final ModConfigSpec.ConfigValue<List<? extends String>> INSULATION_BLACKLIST;
    public static final ModConfigSpec.ConfigValue<List<? extends List<?>>> INSULATING_ARMOR;
    public static final ModConfigSpec.ConfigValue<List<?>> INSULATION_SLOTS;
    public static final ModConfigSpec.ConfigValue<List<? extends List<?>>> INSULATION_SLOT_OVERRIDES;
    public static final ModConfigSpec.DoubleValue INSULATION_STRENGTH;
    public static final ModConfigSpec.IntValue WATERSKIN_CONSUME_STRENGTH;
    public static final ModConfigSpec.DoubleValue WATERSKIN_HOTBAR_STRENGTH;
    public static final ModConfigSpec.DoubleValue WATERSKIN_NEUTRALIZE_SPEED;
    public static final ModConfigSpec.DoubleValue SOULSPRING_LAMP_STRENGTH;
    public static final ModConfigSpec.ConfigValue<Boolean> FIRE_RESISTANCE_BLOCKS_OVERHEATING;
    public static final ModConfigSpec.ConfigValue<Boolean> ICE_RESISTANCE_BLOCKS_FREEZING;
    public static final ModConfigSpec.ConfigValue<Boolean> REQUIRE_THERMOMETER;
    public static final ModConfigSpec.ConfigValue<List<? extends List<?>>> DRYING_ITEMS;
    public static final ModConfigSpec.ConfigValue<List<? extends List<?>>> INSULATING_CURIOS;
    public static final ModConfigSpec.BooleanValue HEAT_DRAINS_BACKTANK;
    public static final ModConfigSpec.BooleanValue COLD_DRAINS_BACKTANK;

    public static void setup(ModContainer modContainer) {
        Path configPath = FMLPaths.CONFIGDIR.get();
        Path csConfigPath = Paths.get(configPath.toAbsolutePath().toString(), "coldsweat");
        try {
            Files.createDirectory(csConfigPath, new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SPEC, "coldsweat/item.toml");
    }

    public static void save() {
        SPEC.save();
    }

    static {
        BUILDER = new ModConfigSpec.Builder();
        ConfigSettings.Difficulty defaultDiff = ConfigSettings.DEFAULT_DIFFICULTY;
        BUILDER.push("Fuel Items").comment(new String[]{"Defines items that can be used as fuel", "Format: [[\"item-id-1\", amount-1], [\"item-id-2\", amount-2], ...etc]"});
        BOILER_FUELS = BUILDER.defineListAllowEmpty(List.of("Boiler"), () -> ListBuilder.begin(new List[]{List.of("#minecraft:planks", Integer.valueOf(10)), List.of("#minecraft:coals", Integer.valueOf(37)), List.of("#minecraft:logs_that_burn", Integer.valueOf(37)), List.of("minecraft:coal_block", Integer.valueOf(333)), List.of("minecraft:magma_block", Integer.valueOf(333)), List.of("minecraft:lava_bucket", Integer.valueOf(1000))}).build(), it -> {
            List list;
            return it instanceof List && (list = (List)it).size() == 2 && list.get(0) instanceof String && list.get(1) instanceof Number;
        });
        ICEBOX_FUELS = BUILDER.defineListAllowEmpty(List.of("Icebox"), () -> ListBuilder.begin(new List[]{List.of("minecraft:snowball", Integer.valueOf(10)), List.of("minecraft:clay_ball", Integer.valueOf(37)), List.of("minecraft:snow_block", Integer.valueOf(100)), List.of("minecraft:ice", Integer.valueOf(250)), List.of("minecraft:clay", Integer.valueOf(333)), List.of("minecraft:powder_snow_bucket", Integer.valueOf(100)), List.of("minecraft:packed_ice", Integer.valueOf(1000))}).build(), it -> {
            List list;
            return it instanceof List && (list = (List)it).size() == 2 && list.get(0) instanceof String && list.get(1) instanceof Number;
        });
        HEARTH_FUELS = BUILDER.comment("Negative values indicate cold fuel").defineListAllowEmpty(List.of("Hearth"), () -> ListBuilder.begin(new List[]{List.of("#minecraft:planks", Integer.valueOf(10)), List.of("#minecraft:coals", Integer.valueOf(37)), List.of("#minecraft:logs_that_burn", Integer.valueOf(37)), List.of("minecraft:coal_block", Integer.valueOf(333)), List.of("minecraft:magma_block", Integer.valueOf(333)), List.of("minecraft:lava_bucket", Integer.valueOf(1000)), List.of("minecraft:snowball", Integer.valueOf(-10)), List.of("minecraft:clay_ball", Integer.valueOf(-37)), List.of("minecraft:snow_block", Integer.valueOf(-100)), List.of("minecraft:ice", Integer.valueOf(-250)), List.of("minecraft:clay", Integer.valueOf(-333)), List.of("minecraft:powder_snow_bucket", Integer.valueOf(-100)), List.of("minecraft:packed_ice", Integer.valueOf(-1000))}).build(), it -> {
            List list;
            return it instanceof List && (list = (List)it).size() == 2 && list.get(0) instanceof String && list.get(1) instanceof Number;
        });
        HEARTH_POTION_BLACKLIST = BUILDER.comment(new String[]{"Potions containing any of these effects will not be allowed in the hearth", "Format: [\"effect_id\", \"effect_id\", ...etc]"}).defineListAllowEmpty(List.of("Blacklisted Hearth Potions"), () -> ListBuilder.begin(new String[]{"minecraft:instant_damage", "minecraft:poison", "minecraft:wither", "minecraft:weakness", "minecraft:mining_fatigue", "minecraft:slowness"}).build(), it -> it instanceof String);
        ALLOW_POTIONS_IN_HEARTH = BUILDER.comment(new String[]{"If true, potions can be used as fuel in the hearth", "This gives all players in range the potion effect"}).define("Allow Potions in Hearth", true);
        BUILDER.pop();
        BUILDER.push("Soulspring Lamp");
        SOULSPRING_LAMP_FUELS = BUILDER.comment(new String[]{"Defines items that the Soulspring Lamp can use as fuel", "Format: [[\"item-id-1\", amount-1], [\"item-id-2\", amount-2], ...etc]"}).defineListAllowEmpty(List.of("Fuel Items"), () -> ListBuilder.begin(List.of("cold_sweat:soul_sprout", Integer.valueOf(4))).build(), it -> {
            List list;
            return it instanceof List && (list = (List)it).size() == 2 && list.get(0) instanceof String && list.get(1) instanceof Number;
        });
        SOULSPRING_LAMP_DIMENSIONS = BUILDER.comment(new String[]{"Defines the dimensions that the Soulspring Lamp can be used in", "Format: [\"dimension-id-1\", \"dimension-id-2\", ...etc]"}).defineListAllowEmpty(List.of("Valid Dimensions"), () -> ListBuilder.begin("minecraft:the_nether").build(), it -> it instanceof String);
        BUILDER.pop();
        BUILDER.push("Insulation");
        INSULATION_ITEMS = BUILDER.comment(new String[]{"Defines the items that can be used for insulating armor in the Sewing Table", "Format: [[\"item_id\", cold, hot, *\"static\", *\"nbt\", *fil_slots], [\"item_id\", amount, adapt-speed, \"adaptive\", *\"nbt\", *fill_slots], ...etc]", "(* = Optional)", "\"item_id\": The item's ID (i.e. \"minecraft:iron_ingot\"). Accepts tags with \"#\" (i.e. \"#minecraft:wool\").", "cold: The cold insulation the item provides.", "hot: The heat insulation the item provides.", "amount: The amount of insulation the item provides.", "adapt-speed: The speed at which the insulation adapts to the environment.", "\"static\"/\"adaptive\": The type of insulation the item provides. Defaults to \"static\" if unset", "nbt: Optional. If set, the item will only provide insulation if it has the specified NBT tag.", "fill_slots: If true, the item will fill 1 slot per 2 insulation points. Otherwise, the item will fill 1 slot."}).defineListAllowEmpty(List.of("Insulation Ingredients"), () -> ListBuilder.begin(new List[]{List.of("minecraft:leather", Integer.valueOf(1), Integer.valueOf(1)), List.of("cold_sweat:chameleon_molt", Integer.valueOf(2), Double.valueOf(0.0085), "adaptive"), List.of("cold_sweat:hoglin_hide", Integer.valueOf(0), Integer.valueOf(2)), List.of("cold_sweat:goat_fur", Integer.valueOf(2), Integer.valueOf(0)), List.of("#minecraft:wool", Double.valueOf(1.5), Integer.valueOf(0)), List.of("minecraft:rabbit_hide", Integer.valueOf(0), Double.valueOf(1.5)), List.of("minecraft:leather_helmet", Integer.valueOf(4), Integer.valueOf(4), "static", "", Boolean.valueOf(true)), List.of("minecraft:leather_chestplate", Integer.valueOf(6), Integer.valueOf(6), "static", "", Boolean.valueOf(true)), List.of("minecraft:leather_leggings", Integer.valueOf(5), Integer.valueOf(5), "static", "", Boolean.valueOf(true)), List.of("minecraft:leather_boots", Integer.valueOf(4), Integer.valueOf(4), "static", "", Boolean.valueOf(true)), List.of("cold_sweat:hoglin_headpiece", Integer.valueOf(0), Integer.valueOf(8), "static", "", Boolean.valueOf(true)), List.of("cold_sweat:hoglin_tunic", Integer.valueOf(0), Integer.valueOf(12), "static", "", Boolean.valueOf(true)), List.of("cold_sweat:hoglin_trousers", Integer.valueOf(0), Integer.valueOf(10), "static", "", Boolean.valueOf(true)), List.of("cold_sweat:hoglin_hooves", Integer.valueOf(0), Integer.valueOf(8), "static", "", Boolean.valueOf(true)), List.of("cold_sweat:goat_fur_cap", Integer.valueOf(8), Integer.valueOf(0), "static", "", Boolean.valueOf(true)), List.of("cold_sweat:goat_fur_parka", Integer.valueOf(12), Integer.valueOf(0), "static", "", Boolean.valueOf(true)), List.of("cold_sweat:goat_fur_pants", Integer.valueOf(10), Integer.valueOf(0), "static", "", Boolean.valueOf(true)), List.of("cold_sweat:goat_fur_boots", Integer.valueOf(8), Integer.valueOf(0), "static", "", Boolean.valueOf(true)), List.of("cold_sweat:chameleon_scale_helmet", Integer.valueOf(8), Double.valueOf(0.0085), "adaptive", "", Boolean.valueOf(true)), List.of("cold_sweat:chameleon_scale_chestplate", Integer.valueOf(12), Double.valueOf(0.0085), "adaptive", "", Boolean.valueOf(true)), List.of("cold_sweat:chameleon_scale_leggings", Integer.valueOf(10), Double.valueOf(0.0085), "adaptive", "", Boolean.valueOf(true)), List.of("cold_sweat:chameleon_scale_boots", Integer.valueOf(8), Double.valueOf(0.0085), "adaptive", "", Boolean.valueOf(true))}).addIf(CompatManager.isEnvironmentalLoaded(), (Supplier<List[]>)((Supplier<List>)() -> List.of("environmental:yak_hair", Double.valueOf(1.5), Integer.valueOf(-1)))).addIf(CompatManager.isToughAsNailsLoaded(), () -> List.of("toughasnails:leaf_helmet", Integer.valueOf(0), List.of(Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1)), "static", "", Boolean.valueOf(true)), () -> List.of("toughasnails:leaf_chestplate", Integer.valueOf(0), List.of(Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1)), "static", "", Boolean.valueOf(true)), () -> List.of("toughasnails:leaf_leggings", Integer.valueOf(0), List.of(Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1)), "static", "", Boolean.valueOf(true)), () -> List.of("toughasnails:leaf_boots", Integer.valueOf(0), List.of(Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1)), "static", "", Boolean.valueOf(true)), () -> List.of("toughasnails:wool_helmet", List.of(Double.valueOf(1.5), Double.valueOf(1.5), Double.valueOf(1.5), Double.valueOf(1.5)), Integer.valueOf(0), "static", "", Boolean.valueOf(true)), () -> List.of("toughasnails:wool_chestplate", List.of(Double.valueOf(1.5), Double.valueOf(1.5), Double.valueOf(1.5), Double.valueOf(1.5), Double.valueOf(1.5), Double.valueOf(1.5)), Integer.valueOf(0), "static", "", Boolean.valueOf(true)), () -> List.of("toughasnails:wool_leggings", List.of(Double.valueOf(1.5), Double.valueOf(1.5), Double.valueOf(1.5), Double.valueOf(1.5), Double.valueOf(1.5)), Integer.valueOf(0), "static", "", Boolean.valueOf(true)), () -> List.of("toughasnails:wool_boots", List.of(Double.valueOf(1.5), Double.valueOf(1.5), Double.valueOf(1.5), Double.valueOf(1.5)), Integer.valueOf(0), "static", "", Boolean.valueOf(true))).build(), it -> {
            List list;
            return !(!(it instanceof List) || (list = (List)it).size() < 3 || !(list.get(0) instanceof String) || !(list.get(1) instanceof Number) && !(list.get(1) instanceof List) || !(list.get(2) instanceof Number) && !(list.get(2) instanceof List) || list.size() >= 4 && !(list.get(3) instanceof String) || list.size() >= 5 && !(list.get(4) instanceof String) || list.size() >= 6 && !(list.get(5) instanceof Boolean));
        });
        INSULATING_ARMOR = BUILDER.comment(new String[]{"Defines the items that provide insulation when worn", "See Insulation Ingredients for formatting. This setting does not have a \"fill_slots\" option"}).defineListAllowEmpty(List.of("Insulating Armor"), () -> ListBuilder.begin(new List[]{List.of("minecraft:leather_helmet", Integer.valueOf(4), Integer.valueOf(4)), List.of("minecraft:leather_chestplate", Integer.valueOf(6), Integer.valueOf(6)), List.of("minecraft:leather_leggings", Integer.valueOf(5), Integer.valueOf(5)), List.of("minecraft:leather_boots", Integer.valueOf(4), Integer.valueOf(4)), List.of("cold_sweat:hoglin_headpiece", Integer.valueOf(0), Integer.valueOf(8)), List.of("cold_sweat:hoglin_tunic", Integer.valueOf(0), Integer.valueOf(12)), List.of("cold_sweat:hoglin_trousers", Integer.valueOf(0), Integer.valueOf(10)), List.of("cold_sweat:hoglin_hooves", Integer.valueOf(0), Integer.valueOf(8)), List.of("cold_sweat:goat_fur_cap", Integer.valueOf(8), Integer.valueOf(0)), List.of("cold_sweat:goat_fur_parka", Integer.valueOf(12), Integer.valueOf(0)), List.of("cold_sweat:goat_fur_pants", Integer.valueOf(10), Integer.valueOf(0)), List.of("cold_sweat:goat_fur_boots", Integer.valueOf(8), Integer.valueOf(0)), List.of("cold_sweat:chameleon_scale_helmet", Integer.valueOf(8), Double.valueOf(0.0085), "adaptive"), List.of("cold_sweat:chameleon_scale_chestplate", Integer.valueOf(12), Double.valueOf(0.0085), "adaptive"), List.of("cold_sweat:chameleon_scale_leggings", Integer.valueOf(10), Double.valueOf(0.0085), "adaptive"), List.of("cold_sweat:chameleon_scale_boots", Integer.valueOf(8), Double.valueOf(0.0085), "adaptive")}).addIf(CompatManager.isEnvironmentalLoaded(), (Supplier<List[]>)((Supplier<List>)() -> List.of("environmental:yak_pants", Double.valueOf(7.5), Integer.valueOf(-5)))).addIf(CompatManager.isToughAsNailsLoaded(), () -> List.of("toughasnails:leaf_helmet", Integer.valueOf(0), List.of(Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1)), "static", "", Boolean.valueOf(true)), () -> List.of("toughasnails:leaf_chestplate", Integer.valueOf(0), List.of(Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1)), "static", "", Boolean.valueOf(true)), () -> List.of("toughasnails:leaf_leggings", Integer.valueOf(0), List.of(Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1)), "static", "", Boolean.valueOf(true)), () -> List.of("toughasnails:leaf_boots", Integer.valueOf(0), List.of(Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1)), "static", "", Boolean.valueOf(true)), () -> List.of("toughasnails:wool_helmet", List.of(Double.valueOf(1.5), Double.valueOf(1.5), Double.valueOf(1.5), Double.valueOf(1.5)), Integer.valueOf(0), "static", "", Boolean.valueOf(true)), () -> List.of("toughasnails:wool_chestplate", List.of(Double.valueOf(1.5), Double.valueOf(1.5), Double.valueOf(1.5), Double.valueOf(1.5), Double.valueOf(1.5), Double.valueOf(1.5)), Integer.valueOf(0), "static", "", Boolean.valueOf(true)), () -> List.of("toughasnails:wool_leggings", List.of(Double.valueOf(1.5), Double.valueOf(1.5), Double.valueOf(1.5), Double.valueOf(1.5), Double.valueOf(1.5)), Integer.valueOf(0), "static", "", Boolean.valueOf(true)), () -> List.of("toughasnails:wool_boots", List.of(Double.valueOf(1.5), Double.valueOf(1.5), Double.valueOf(1.5), Double.valueOf(1.5)), Integer.valueOf(0), "static", "", Boolean.valueOf(true))).build(), it -> {
            List list;
            return !(!(it instanceof List) || (list = (List)it).size() < 3 || !(list.get(0) instanceof String) || !(list.get(1) instanceof Number) && !(list.get(1) instanceof List) || !(list.get(2) instanceof Number) && !(list.get(2) instanceof List) || list.size() >= 4 && !(list.get(3) instanceof String) || list.size() >= 5 && !(list.get(5) instanceof String) || list.size() >= 6);
        });
        INSULATING_CURIOS = CompatManager.isCuriosLoaded() ? BUILDER.comment(new String[]{"Defines the items that provide insulation when worn in a curio slot", "See Insulation Ingredients for formatting. This setting does not have a \"fill_slots\" option"}).defineListAllowEmpty(List.of("Insulating Curios"), () -> List.of(), it -> {
            List list;
            return !(!(it instanceof List) || (list = (List)it).size() < 3 || !(list.get(0) instanceof String) || !(list.get(1) instanceof Number) || !(list.get(2) instanceof Number) || list.size() >= 4 && !(list.get(3) instanceof String) || list.size() >= 5 && !(list.get(4) instanceof String));
        }) : null;
        INSULATION_SLOTS = BUILDER.comment(new String[]{"Defines how many insulation slots armor pieces have", "There are 4 modes for this setting:", "Static: Each armor slot (head, body, legs, feet) has a fixed number of insulation slots", "- Format: [head, body, legs, feet] (a list of integers; insulation slot count for each armor slot)", " ", "Linear: Number of slots increases steadily with protection", "Exponential: Number of slots increases rapidly with protection", "Logarithmic: Number of slots increases with protection, with diminishing returns", "- Format: [number, max-slots] (a positive integer or decimal; the rate of increase)"}).defineList("Insulation Slots", List.of("static", Integer.valueOf(4), Integer.valueOf(6), Integer.valueOf(5), Integer.valueOf(4)), it -> it instanceof Number || it instanceof String);
        INSULATION_SLOT_OVERRIDES = BUILDER.comment(new String[]{"Allows for overriding the number of insulation slots for specific items", "Format: [[\"item_id\", slot_count, *\"nbt\"], [\"item_id\", slot_count, *\"nbt\"], ...etc]"}).defineListAllowEmpty(List.of("Insulation Slot Overrides"), () -> List.of(), it -> {
            List list;
            return it instanceof List && (list = (List)it).size() == 2 && list.get(0) instanceof String && list.get(1) instanceof Number && (list.size() < 3 || list.get(2) instanceof String);
        });
        INSULATION_STRENGTH = BUILDER.comment("Defines the effectiveness of insulating items in protecting against temperature").defineInRange("Insulation Strength", 1.0, 0.0, Double.POSITIVE_INFINITY);
        INSULATION_BLACKLIST = BUILDER.comment(new String[]{"Defines wearable items that cannot be insulated", "Format: [\"item_id\", \"item_id\", ...etc]"}).defineListAllowEmpty(List.of("Insulation Blacklist"), () -> List.of(), it -> it instanceof String);
        BUILDER.pop();
        BUILDER.push("Consumables");
        FOOD_TEMPERATURES = BUILDER.comment(new String[]{"Defines items that affect the player's temperature when consumed", "Format: [[\"item_id\", amount, *\"nbt\", *duration], [\"item_id\", amount, *\"nbt\", *duration], ...etc]", "Negative values are cold foods, positive values are hot foods", "nbt: Optional. If set, the item will only affect the player's temperature if it has the specified NBT tag.", "duration: Optional. If set, the player's temperature will remain increased/decreased for this amount of time (in ticks)."}).defineListAllowEmpty(List.of("Temperature-Affecting Foods"), () -> Arrays.asList(List.of("cold_sweat:soul_sprout", Integer.valueOf(-20), "{}", Integer.valueOf(1200))), it -> {
            List list;
            return !(!(it instanceof List) || (list = (List)it).size() < 2 || !(list.get(0) instanceof String) || !(list.get(1) instanceof Number) || list.size() >= 3 && !(list.get(2) instanceof String) || list.size() >= 4 && !(list.get(3) instanceof Number));
        });
        WATERSKIN_CONSUME_STRENGTH = BUILDER.comment("Defines how much a waterskin will change the player's body temperature when used").defineInRange("Waterskin Strength", 50, 0, Integer.MAX_VALUE);
        WATERSKIN_HOTBAR_STRENGTH = BUILDER.comment("A multiplier for how effective a waterskin's over-time effect is, when held in the player's hotbar").defineInRange("Waterskin Hotbar Strength", 1.0, 0.0, Double.POSITIVE_INFINITY);
        WATERSKIN_NEUTRALIZE_SPEED = BUILDER.comment("A multiplier for how quickly a waterskin will return to its neutral temperature when being used in the hotbar").defineInRange("Waterskin Neutralize Speed", 1.0, 0.0, Double.POSITIVE_INFINITY);
        SOULSPRING_LAMP_STRENGTH = BUILDER.comment(new String[]{"Determines the strength of the Soulspring Lamp's effect before it is overwhelmed", "A value of 1 means it will never be overwhelmed"}).defineInRange("Soulspring Lamp Strength", 0.6, 0.0, 1.0);
        DRYING_ITEMS = BUILDER.comment(new String[]{"Defines items that can be used to dry the player", "Format: [[\"item_id\", \"turns_into\"], [\"item_id\", \"turns_into\"], ...etc]"}).defineListAllowEmpty(List.of("Drying Items"), () -> List.of(List.of("minecraft:sponge", "minecraft:wet_sponge")), it -> {
            List list;
            return it instanceof List && (list = (List)it).size() == 2 && list.get(0) instanceof String && list.get(1) instanceof String;
        });
        BUILDER.pop();
        BUILDER.push("Misc");
        CARRIED_ITEM_TEMPERATURES = BUILDER.comment(new String[]{"Defines items that affect the player's temperature when in the inventory", "Format: [[\"item_id\", temperature, \"slot_range\", \"trait\", *\"nbt\", *max_effect], [\"item_id\", temperature, \"slot_range\", \"trait\", *\"nbt\", *max_effect], ...etc]", "temperature: The temperature change the item will apply to the entity. For core temperature, this is applied every tick", "slot_range: Either \"inventory\", \"hotbar\", or \"hand\". Defines what slots the item must be in to apply to the entity (inventory includes hotbar)", "trait: The temperature trait to apply the effect to. Typical values are \"core\" for body temperature or \"world\" for ambient temperature. More on the mod documentation page.", "nbt: Optional. The NBT data the item must have to apply to the entity.", "max_effect: Optional. The maximum temperature effect the item can apply to the entity."}).defineListAllowEmpty(List.of("Carried Item Temperatures"), () -> List.of(), it -> {
            List list;
            return !(!(it instanceof List) || !CSMath.betweenInclusive((list = (List)it).size(), 4.0, 6.0) || !(list.get(0) instanceof String) || !(list.get(1) instanceof Number) || !(list.get(2) instanceof String) || !(list.get(3) instanceof String) || list.size() >= 5 && !(list.get(4) instanceof String) || list.size() >= 6 && !(list.get(5) instanceof Number));
        });
        BUILDER.pop();
        BUILDER.push("Item Functions");
        FIRE_RESISTANCE_BLOCKS_OVERHEATING = BUILDER.comment("Allow fire resistance to block overheating damage").define("Fire Resistance Immunity", (Object)defaultDiff.getOrDefault(ConfigSettings.FIRE_RESISTANCE_ENABLED, Boolean.valueOf(true)));
        ICE_RESISTANCE_BLOCKS_FREEZING = BUILDER.comment("Allow ice resistance to block freezing damage").define("Ice Resistance Immunity", (Object)defaultDiff.getOrDefault(ConfigSettings.ICE_RESISTANCE_ENABLED, Boolean.valueOf(true)));
        REQUIRE_THERMOMETER = BUILDER.comment("Thermometer item is required to see detailed world temperature").define("Require Thermometer", (Object)defaultDiff.getOrDefault(ConfigSettings.REQUIRE_THERMOMETER, Boolean.valueOf(true)));
        BUILDER.pop();
        if (CompatManager.isCreateLoaded()) {
            BUILDER.comment(new String[]{"Drains pressure from Create's netherite backtank if the player is in a hot/cold environment", "Triggered by the set bonus for wearing a full set of netherite diving gear", "Disabling these settings will not disable the heat/cold protection set bonus"}).push("Create Backtank");
            HEAT_DRAINS_BACKTANK = BUILDER.define("Heat Drains Backtank", true);
            COLD_DRAINS_BACKTANK = BUILDER.define("Cold Drains Backtank", false);
            BUILDER.pop();
        } else {
            HEAT_DRAINS_BACKTANK = null;
            COLD_DRAINS_BACKTANK = null;
        }
        SPEC = BUILDER.build();
    }
}

