/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.config.spec;

import com.momosoftworks.coldsweat.config.ConfigSettings;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.joml.Vector2i;

public class ClientSettingsConfig {
    private static final ModConfigSpec SPEC;
    private static final ModConfigSpec.Builder BUILDER;
    public static final ModConfigSpec.BooleanValue USE_CELSIUS;
    public static final ModConfigSpec.IntValue TEMPERATURE_OFFSET;
    public static final ModConfigSpec.DoubleValue TEMPERATURE_SMOOTHING;
    public static final ModConfigSpec.ConfigValue<List<? extends Integer>> BODY_TEMP_ICON_POS;
    public static final ModConfigSpec.BooleanValue SHOW_BODY_TEMP_ICON;
    public static final ModConfigSpec.BooleanValue MOVE_BODY_TEMP_ICON_ADVANCED;
    public static final ModConfigSpec.ConfigValue<List<? extends Integer>> BODY_TEMP_READOUT_POS;
    public static final ModConfigSpec.BooleanValue SHOW_BODY_TEMP_READOUT;
    public static final ModConfigSpec.ConfigValue<List<? extends Integer>> WORLD_TEMP_GAUGE_POS;
    public static final ModConfigSpec.BooleanValue SHOW_WORLD_TEMP_GAUGE;
    public static final ModConfigSpec.BooleanValue USE_CUSTOM_HOTBAR_LAYOUT;
    public static final ModConfigSpec.BooleanValue ENABLE_ICON_BOBBING;
    public static final ModConfigSpec.BooleanValue SHOW_HEARTH_DEBUG_VISUALS;
    public static final ModConfigSpec.BooleanValue SHOW_CONFIG_BUTTON;
    public static final ModConfigSpec.ConfigValue<List<? extends Integer>> CONFIG_BUTTON_POS;
    public static final ModConfigSpec.BooleanValue SHOW_SCREEN_DISTORTIONS;
    public static final ModConfigSpec.BooleanValue HIGH_CONTRAST_MODE;
    public static final ModConfigSpec.BooleanValue ENABLE_CREATIVE_WARNING;
    public static final ModConfigSpec.BooleanValue HIDE_INSULATION_TOOLTIPS;
    public static final ModConfigSpec.BooleanValue EXPAND_TOOLTIPS;
    public static final ModConfigSpec.IntValue WATER_EFFECT_SETTING;
    public static final ModConfigSpec.ConfigValue<List<? extends Integer>> WATER_DROPLET_SCALE;
    public static final ModConfigSpec.BooleanValue SHOW_FROZEN_HEALTH;
    public static final ModConfigSpec.DoubleValue FREEZING_OVERLAY_OPACITY;
    public static final ModConfigSpec.DoubleValue SHIVER_INTENSITY;
    public static final ModConfigSpec.DoubleValue HEATSTROKE_BORDER_OPACITY;
    public static final ModConfigSpec.DoubleValue HEATSTROKE_BLUR;
    public static final ModConfigSpec.DoubleValue HEATSTROKE_SWAY_AMOUNT;
    public static final ModConfigSpec.DoubleValue HEATSTROKE_SWAY_SPEED;
    public static final ModConfigSpec.BooleanValue ANIMATED_SOUL_SPRING_LAMP;
    public static final ModConfigSpec.ConfigValue<String> WATERSKIN_DRINK_PRIMARY;
    public static final ModConfigSpec.ConfigValue<String> WATERSKIN_DRINK_SECONDARY;

    public static void setup(ModContainer modContainer) {
        Path configPath = FMLPaths.CONFIGDIR.get();
        Path csConfigPath = Paths.get(configPath.toAbsolutePath().toString(), "coldsweat");
        try {
            Files.createDirectory(csConfigPath, new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)SPEC, "coldsweat/client.toml");
    }

    public static Vector2i getBodyIconPos() {
        return new Vector2i(((Integer)((List)BODY_TEMP_ICON_POS.get()).get(0)).intValue(), ((Integer)((List)BODY_TEMP_ICON_POS.get()).get(1)).intValue());
    }

    public static Vector2i getBodyReadoutPos() {
        return new Vector2i(((Integer)((List)BODY_TEMP_READOUT_POS.get()).get(0)).intValue(), ((Integer)((List)BODY_TEMP_READOUT_POS.get()).get(1)).intValue());
    }

    public static Vector2i getWorldGaugePos() {
        return new Vector2i(((Integer)((List)WORLD_TEMP_GAUGE_POS.get()).get(0)).intValue(), ((Integer)((List)WORLD_TEMP_GAUGE_POS.get()).get(1)).intValue());
    }

    public static Vector2i getConfigButtonPos() {
        return new Vector2i(((Integer)((List)CONFIG_BUTTON_POS.get()).get(0)).intValue(), ((Integer)((List)CONFIG_BUTTON_POS.get()).get(1)).intValue());
    }

    public static synchronized void writeAndSave() {
        USE_CELSIUS.set((Object)ConfigSettings.CELSIUS.get());
        TEMPERATURE_OFFSET.set((Object)ConfigSettings.TEMP_OFFSET.get());
        TEMPERATURE_SMOOTHING.set((Object)ConfigSettings.TEMP_SMOOTHING.get());
        BODY_TEMP_ICON_POS.set(List.of(Integer.valueOf(ConfigSettings.BODY_ICON_POS.get().x()), Integer.valueOf(ConfigSettings.BODY_ICON_POS.get().y())));
        BODY_TEMP_READOUT_POS.set(List.of(Integer.valueOf(ConfigSettings.BODY_READOUT_POS.get().x()), Integer.valueOf(ConfigSettings.BODY_READOUT_POS.get().y())));
        WORLD_TEMP_GAUGE_POS.set(List.of(Integer.valueOf(ConfigSettings.WORLD_GAUGE_POS.get().x()), Integer.valueOf(ConfigSettings.WORLD_GAUGE_POS.get().y())));
        USE_CUSTOM_HOTBAR_LAYOUT.set((Object)ConfigSettings.CUSTOM_HOTBAR_LAYOUT.get());
        ENABLE_ICON_BOBBING.set((Object)ConfigSettings.ICON_BOBBING.get());
        SHOW_HEARTH_DEBUG_VISUALS.set((Object)ConfigSettings.HEARTH_DEBUG.get());
        ENABLE_CREATIVE_WARNING.set((Object)ConfigSettings.SHOW_CREATIVE_WARNING.get());
        SHOW_BODY_TEMP_ICON.set((Object)ConfigSettings.BODY_ICON_ENABLED.get());
        SHOW_BODY_TEMP_READOUT.set((Object)ConfigSettings.BODY_READOUT_ENABLED.get());
        SHOW_WORLD_TEMP_GAUGE.set((Object)ConfigSettings.WORLD_GAUGE_ENABLED.get());
        SHOW_SCREEN_DISTORTIONS.set((Object)ConfigSettings.DISTORTION_EFFECTS.get());
        HIGH_CONTRAST_MODE.set((Object)ConfigSettings.HIGH_CONTRAST.get());
        CONFIG_BUTTON_POS.set(List.of(Integer.valueOf(ConfigSettings.CONFIG_BUTTON_POS.get().x()), Integer.valueOf(ConfigSettings.CONFIG_BUTTON_POS.get().y())));
        MOVE_BODY_TEMP_ICON_ADVANCED.set((Object)ConfigSettings.MOVE_BODY_ICON_WHEN_ADVANCED.get());
        WATER_EFFECT_SETTING.set((Object)ConfigSettings.WATER_EFFECT_SETTING.get().ordinal());
        ClientSettingsConfig.save();
    }

    public static synchronized void save() {
        SPEC.save();
    }

    static {
        BUILDER = new ModConfigSpec.Builder();
        BUILDER.push("Preferences");
        USE_CELSIUS = BUILDER.comment("Sets all temperatures to be displayed in Celsius").define("Celsius", false);
        TEMPERATURE_OFFSET = BUILDER.comment("Visually offsets the world temperature to better match the user's definition of \"hot\" and \"cold\"").defineInRange("Temperature Offset", 0, -2147483647, Integer.MAX_VALUE);
        TEMPERATURE_SMOOTHING = BUILDER.comment(new String[]{"The amount of smoothing applied to gauges in the UI", "A value of 1 has no smoothing"}).defineInRange("Temperature Smoothing", 10.0, 1.0, 2.147483647E9);
        WATER_EFFECT_SETTING = BUILDER.comment(new String[]{"Displays a dripping water effect on-screen and/or with particles when the player is wet", "0: Off, 1: Particles, 2: On-Screen, 3: Both"}).defineInRange("Show Water Effect", 3, 0, 3);
        WATER_DROPLET_SCALE = BUILDER.comment("The scale of the water droplets on-screen, in scaled \"pixels\"").defineList("Water Droplet Scale", List.of(Integer.valueOf(40), Integer.valueOf(48)), it -> it instanceof Integer);
        WATERSKIN_DRINK_PRIMARY = BUILDER.comment(new String[]{"Defines the primary (right-click) action for the waterskin", "Can be one of \"drink\", \"pour\", or \"none\""}).define("Waterskin Primary Action", (Object)"pour");
        WATERSKIN_DRINK_SECONDARY = BUILDER.comment(new String[]{"Defines the secondary (sneak-right-click) action for the waterskin", "Can be one of \"drink\", \"pour\", or \"none\""}).define("Waterskin Secondary Action", (Object)"drink");
        BUILDER.pop();
        BUILDER.push("UI Options");
        USE_CUSTOM_HOTBAR_LAYOUT = BUILDER.define("Custom hotbar layout", true);
        ENABLE_ICON_BOBBING = BUILDER.comment("Controls whether UI elements will shake when in critical conditions").define("Icon Bobbing", true);
        BODY_TEMP_ICON_POS = BUILDER.comment("The position of the body temperature icon relative to default").defineList("Body Temperature Icon Offset", List.of(Integer.valueOf(0), Integer.valueOf(0)), it -> it instanceof Integer);
        SHOW_BODY_TEMP_ICON = BUILDER.comment("Enables the body temperature icon above the hotbar").define("Show Body Temperature Icon", true);
        MOVE_BODY_TEMP_ICON_ADVANCED = BUILDER.comment("Moves the body temperature icon to make way for the advanced readout when a thermometer is equipped").define("Move Body Icon For Advanced Info", true);
        BODY_TEMP_READOUT_POS = BUILDER.comment("The position of the body temperature readout relative to default").defineList("Body Temperature Readout Offset", List.of(Integer.valueOf(0), Integer.valueOf(0)), it -> it instanceof Integer);
        SHOW_BODY_TEMP_READOUT = BUILDER.comment("Enables the body temperature readout above the hotbar").define("Show Body Temperature Readout", true);
        WORLD_TEMP_GAUGE_POS = BUILDER.comment("The position of the world temperature gauge relative to default").defineList("World Temperature UI Offset", List.of(Integer.valueOf(0), Integer.valueOf(0)), it -> it instanceof Integer);
        SHOW_WORLD_TEMP_GAUGE = BUILDER.comment("Enables the world temperature gauge next to the hotbar").define("Show World Temperature Gauge", true);
        SHOW_CONFIG_BUTTON = BUILDER.comment("Show the config menu button in the Options menu").define("Enable In-Game Config", true);
        CONFIG_BUTTON_POS = BUILDER.comment("The position (offset) of the config button on the screen").defineList("Config Button Position", List.of(Integer.valueOf(0), Integer.valueOf(0)), it -> it instanceof Integer);
        BUILDER.pop();
        BUILDER.push("Accessibility");
        SHOW_SCREEN_DISTORTIONS = BUILDER.comment("Enables visual distortion effects when the player is too hot or cold").define("Distortion Effects", true);
        HIGH_CONTRAST_MODE = BUILDER.comment("Enables high contrast mode for UI elements").define("High Contrast", false);
        SHOW_FROZEN_HEALTH = BUILDER.comment("Shows a frozen texture over the player's health bar when they are freezing").define("Show Frozen Health", true);
        FREEZING_OVERLAY_OPACITY = BUILDER.comment(new String[]{"The opacity of the icy overlay when the player is freezing", "Does not affect Vanilla's powder snow overlay"}).defineInRange("Freezing Overlay Opacity", 1.0, 0.0, 1.0);
        SHIVER_INTENSITY = BUILDER.comment("The intensity of the shivering effect when the player is too cold").defineInRange("Shiver Intensity", 1.0, 0.0, 2.0);
        HEATSTROKE_BORDER_OPACITY = BUILDER.comment("The opacity of the pulsing red border around the screen when the player is too hot").defineInRange("Heatstroke Border Opacity", 1.0, 0.0, 1.0);
        HEATSTROKE_BLUR = BUILDER.comment("The amount of blur applied to the screen when the player is too hot").defineInRange("Heatstroke Blur Strength", 1.0, 0.0, 1.0);
        HEATSTROKE_SWAY_AMOUNT = BUILDER.comment("The amount of camera sway applied when the player is too hot").defineInRange("Heatstroke Sway Amount", 1.0, 0.0, 2.0);
        HEATSTROKE_SWAY_SPEED = BUILDER.comment("The speed of the camera sway applied when the player is too hot").defineInRange("Heatstroke Sway Speed", 1.0, 0.0, 2.0);
        BUILDER.pop();
        BUILDER.push("Misc");
        ENABLE_CREATIVE_WARNING = BUILDER.comment("Warns the player about a bug that clears armor insulation when in creative mode").define("Enable Creative Mode Warning", true);
        SHOW_HEARTH_DEBUG_VISUALS = BUILDER.comment("Displays areas that the Hearth is affecting when the F3 debug menu is open").define("Hearth Debug", true);
        HIDE_INSULATION_TOOLTIPS = BUILDER.comment("Hides insulation tooltips for items, armor, and curios unless SHIFT is held").define("Hide Tooltips", false);
        EXPAND_TOOLTIPS = BUILDER.comment("Automatically expands all collapsible tooltips").define("Expand Tooltips", false);
        ANIMATED_SOUL_SPRING_LAMP = BUILDER.comment(new String[]{"Enables the animated soul spring lamp model", "Disable this if there are visual errors like missing textures"}).define("Animated Soul Spring Lamp", true);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

