/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.config;

import com.google.common.io.Files;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.temperature.modifier.InventoryItemsTempModifier;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigLoadingHandler;
import com.momosoftworks.coldsweat.config.spec.ItemSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.MainSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.WorldSettingsConfig;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ModUpdater {
    public static void updateEntity(LivingEntity entity) {
        String entityVersion = entity.getPersistentData().getString("cs:version");
        if (ModUpdater.compareVersions(entityVersion, "2.3-b03a") < 0) {
            EntityTempManager.getTemperatureCap((Entity)entity).ifPresent(cap -> cap.getModifiers().forEach((trait, list) -> list.removeIf(mod -> mod.getClass() == InventoryItemsTempModifier.class)));
        }
        entity.getPersistentData().putString("cs:version", ColdSweat.getVersion());
    }

    public static void updateConfigs() {
        if (!((Boolean)MainSettingsConfig.AUTO_UPDATE.get()).booleanValue()) {
            return;
        }
        String version = ColdSweat.getVersion();
        String configVersion = (String)MainSettingsConfig.VERSION.get();
        if (ModUpdater.isBehind(configVersion, "2.3-b05b")) {
            ColdSweat.LOGGER.error("Cancelling config auto-updater. Version {} is older than minimum supported version: 2.3-b05b", (Object)configVersion);
            return;
        }
        if (ModUpdater.isBehind(configVersion, "2.3")) {
            ModUpdater.replaceConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, "minecraft:magma_block", blockTemp -> {
                blockTemp.clear();
                blockTemp.addAll(List.of("minecraft:magma_block", Double.valueOf(0.25), Integer.valueOf(3), "mc", Double.valueOf(1.0)));
            });
            ModUpdater.replaceConfigSetting(ItemSettingsConfig.ICEBOX_FUELS, "minecraft:ice", iceFuel -> iceFuel.set(1, 250));
            ModUpdater.replaceConfigSetting(ItemSettingsConfig.HEARTH_FUELS, "minecraft:ice", iceFuel -> iceFuel.set(1, -250));
            ModUpdater.replaceConfigSetting(ItemSettingsConfig.ICEBOX_FUELS, "minecraft:snow_block", snowFuel -> snowFuel.set(1, 100));
            ModUpdater.replaceConfigSetting(ItemSettingsConfig.HEARTH_FUELS, "minecraft:snow_block", snowFuel -> snowFuel.set(1, -100));
            ModUpdater.replaceConfigSetting(ItemSettingsConfig.ICEBOX_FUELS, "minecraft:powder_snow_bucket", powderSnowFuel -> powderSnowFuel.set(1, 100));
            ModUpdater.replaceConfigSetting(ItemSettingsConfig.HEARTH_FUELS, "minecraft:powder_snow_bucket", powderSnowFuel -> powderSnowFuel.set(1, -100));
            ModUpdater.replaceConfigSetting(ItemSettingsConfig.ICEBOX_FUELS, "minecraft:snowball", snowballFuel -> snowballFuel.set(1, 10));
            ModUpdater.replaceConfigSetting(ItemSettingsConfig.HEARTH_FUELS, "minecraft:snowball", snowballFuel -> snowballFuel.set(1, -10));
        }
        if (ModUpdater.isBehind(configVersion, "2.3.1")) {
            ModUpdater.removeConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, "minecraft:ice");
            ModUpdater.removeConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, "minecraft:packed_ice");
            ModUpdater.removeConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, "minecraft:blue_ice");
        }
        if (ModUpdater.isBehind(configVersion, "2.3.2")) {
            ModUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, "cold_sweat:fur", insulator -> insulator.set(0, "cold_sweat:goat_fur"));
            ModUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, "cold_sweat:fur_cap", insulator -> insulator.set(0, "cold_sweat:goat_fur_cap"));
            ModUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, "cold_sweat:fur_parka", insulator -> insulator.set(0, "cold_sweat:goat_fur_parka"));
            ModUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, "cold_sweat:fur_pants", insulator -> insulator.set(0, "cold_sweat:goat_fur_pants"));
            ModUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, "cold_sweat:fur_boots", insulator -> insulator.set(0, "cold_sweat:goat_fur_boots"));
            ModUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATING_ARMOR, "cold_sweat:fur_cap", insulator -> insulator.set(0, "cold_sweat:goat_fur_cap"));
            ModUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATING_ARMOR, "cold_sweat:fur_parka", insulator -> insulator.set(0, "cold_sweat:goat_fur_parka"));
            ModUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATING_ARMOR, "cold_sweat:fur_pants", insulator -> insulator.set(0, "cold_sweat:goat_fur_pants"));
            ModUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATING_ARMOR, "cold_sweat:fur_boots", insulator -> insulator.set(0, "cold_sweat:goat_fur_boots"));
        }
        if (ModUpdater.compareVersions(configVersion, "2.3.4") < 0) {
            ModUpdater.removeConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, "minecraft:soul_fire");
            ModUpdater.removeConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, "minecraft:soul_campfire");
            ModUpdater.addConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, List.of("cold_sweat:boiler", Double.valueOf(0.27), Integer.valueOf(7), "mc", Double.valueOf(0.88), "lit=true", "{}", Integer.valueOf(4)));
            ModUpdater.addConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, List.of("cold_sweat:icebox", Double.valueOf(-0.27), Integer.valueOf(7), "mc", Double.valueOf(0.88), "frosted=true", "{}", Integer.valueOf(0)));
            ModUpdater.addConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, List.of("minecraft:ice", Double.valueOf(-0.15), Integer.valueOf(4), "mc", Double.valueOf(0.6), "", "{}", Double.valueOf(-0.7)));
            ModUpdater.addConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, List.of("minecraft:packed_ice", Double.valueOf(-0.25), Integer.valueOf(4), "mc", Double.valueOf(1.0), "", "{}", Double.valueOf(-0.7)));
            ModUpdater.addConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, List.of("minecraft:blue_ice", Double.valueOf(-0.35), Integer.valueOf(4), "mc", Double.valueOf(1.4), "", "{}", Double.valueOf(-0.7)));
            ModUpdater.addConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, List.of("#minecraft:ice", Double.valueOf(-0.15), Integer.valueOf(4), "mc", Double.valueOf(0.6), "", "{}", Double.valueOf(-0.7)));
            ModUpdater.addConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, List.of("#minecraft:campfires", Double.valueOf(0.476), Integer.valueOf(7), "mc", Double.valueOf(0.9), "lit=true", " ", Integer.valueOf(8)));
        }
        if (ModUpdater.isBehind(configVersion, "2.3.10")) {
            ArrayList blockTemps = new ArrayList((Collection)WorldSettingsConfig.BLOCK_TEMPERATURES.get());
            for (int i = 0; i < blockTemps.size(); ++i) {
                ArrayList<String> blockTemp2 = new ArrayList<String>((List)blockTemps.get(i));
                if (blockTemp2.size() <= 3 || blockTemp2.get(3) instanceof String) continue;
                blockTemp2.add(3, "mc");
                blockTemps.set(i, blockTemp2);
            }
            WorldSettingsConfig.BLOCK_TEMPERATURES.set(blockTemps);
        }
        if (ModUpdater.isBehind(configVersion, "2.4-b02a")) {
            ArrayList itemInsulations = new ArrayList((Collection)ItemSettingsConfig.INSULATION_ITEMS.get());
            for (List entry : itemInsulations) {
                if (!entry.contains("adaptive")) {
                    CSMath.setOrAppend(entry, 3, "static");
                }
                CSMath.setOrAppend(entry, 4, "");
                CSMath.setOrAppend(entry, 5, true);
            }
            ItemSettingsConfig.INSULATION_ITEMS.set(itemInsulations);
            ModUpdater.addConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, List.of("cold_sweat:chameleon_scale_helmet", Integer.valueOf(8), Double.valueOf(0.0085), "adaptive", "", Boolean.valueOf(true)));
            ModUpdater.addConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, List.of("cold_sweat:chameleon_scale_chestplate", Integer.valueOf(12), Double.valueOf(0.0085), "adaptive", "", Boolean.valueOf(true)));
            ModUpdater.addConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, List.of("cold_sweat:chameleon_scale_leggings", Integer.valueOf(10), Double.valueOf(0.0085), "adaptive", "", Boolean.valueOf(true)));
            ModUpdater.addConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, List.of("cold_sweat:chameleon_scale_boots", Integer.valueOf(8), Double.valueOf(0.0085), "adaptive", "", Boolean.valueOf(true)));
            ModUpdater.addConfigSetting(ItemSettingsConfig.INSULATING_ARMOR, List.of("cold_sweat:chameleon_scale_helmet", Integer.valueOf(8), Double.valueOf(0.0085), "adaptive"));
            ModUpdater.addConfigSetting(ItemSettingsConfig.INSULATING_ARMOR, List.of("cold_sweat:chameleon_scale_chestplate", Integer.valueOf(12), Double.valueOf(0.0085), "adaptive"));
            ModUpdater.addConfigSetting(ItemSettingsConfig.INSULATING_ARMOR, List.of("cold_sweat:chameleon_scale_leggings", Integer.valueOf(10), Double.valueOf(0.0085), "adaptive"));
            ModUpdater.addConfigSetting(ItemSettingsConfig.INSULATING_ARMOR, List.of("cold_sweat:chameleon_scale_boots", Integer.valueOf(8), Double.valueOf(0.0085), "adaptive"));
            ArrayList whitelist = new ArrayList((Collection)WorldSettingsConfig.SOURCE_SPREAD_WHITELIST.get());
            whitelist.remove("cold_sweat:hearth_bottom");
            WorldSettingsConfig.SOURCE_SPREAD_WHITELIST.set(whitelist);
            if (CompatManager.isTwilightForestLoaded()) {
                ModUpdater.addConfigSetting(WorldSettingsConfig.DIMENSION_TEMP_OFFSETS, List.of("twilightforest:twilight_forest_type", Double.valueOf(0.2)));
            }
            if (CompatManager.isAetherLoaded()) {
                ModUpdater.addConfigSetting(WorldSettingsConfig.DIMENSION_TEMP_OFFSETS, List.of("aether:the_aether", Double.valueOf(0.7)));
            }
        }
        if (ModUpdater.isBehind(configVersion, "2.4-b02b")) {
            ModUpdater.addConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, List.of("minecraft:lava", Double.valueOf(0.25), Integer.valueOf(7), "mc", Integer.valueOf(4), "", "", Double.valueOf(21.5)));
        }
        if (ModUpdater.isBehind(configVersion, "2.4-b02c")) {
            ModUpdater.removeConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, "minecraft:lava");
            ModUpdater.addConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, List.of("minecraft:lava", Double.valueOf(0.25), Integer.valueOf(7), "mc", Integer.valueOf(4), "", "", Double.valueOf(21.5), Boolean.valueOf(true)));
        }
        if (ModUpdater.isBehind(configVersion, "2.4-b03a")) {
            ModUpdater.removeConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, "cold_sweat:soul_stalk");
        }
        MainSettingsConfig.VERSION.set((Object)version);
        MainSettingsConfig.save();
        ItemSettingsConfig.save();
        WorldSettingsConfig.save();
    }

    public static void updateFileNames() {
        for (File file : ConfigLoadingHandler.findFilesRecursive(FMLPaths.CONFIGDIR.get().resolve("coldsweat").toFile())) {
            if (!file.isFile()) continue;
            switch (file.getName()) {
                case "world_settings.toml": {
                    ModUpdater.renameFile(file, "world.toml");
                    break;
                }
                case "entity_settings.toml": {
                    ModUpdater.renameFile(file, "entity.toml");
                    break;
                }
                case "item_settings.toml": {
                    ModUpdater.renameFile(file, "item.toml");
                }
            }
        }
    }

    private static void renameFile(File file, String newName) {
        File newFile = file.toPath().resolveSibling(newName).toFile();
        try {
            Files.move((File)file, (File)newFile);
        }
        catch (Exception e) {
            ColdSweat.LOGGER.error("Failed to rename file {} to {}", (Object)file, (Object)newFile, (Object)e);
        }
    }

    private static boolean isBehind(String version, String comparedTo) {
        boolean isBehind;
        boolean bl = isBehind = ModUpdater.compareVersions(version, comparedTo) < 0;
        if (isBehind) {
            ColdSweat.LOGGER.warn("Last launched version {} is less than {}. Updating config settings...", (Object)version, (Object)comparedTo);
        }
        return isBehind;
    }

    public static int compareVersions(String version, String comparedTo) {
        int i;
        String[] v1Parts = version.split("\\.|\\-");
        String[] v2Parts = comparedTo.split("\\.|\\-");
        for (i = 0; i < v1Parts.length && i < v2Parts.length; ++i) {
            if (v1Parts[i].matches("\\d+") && v2Parts[i].matches("\\d+")) {
                int num2;
                int num1 = Integer.parseInt(v1Parts[i]);
                if (num1 == (num2 = Integer.parseInt(v2Parts[i]))) continue;
                return Integer.compare(num1, num2);
            }
            if (!v1Parts[i].startsWith("b") && v2Parts[i].startsWith("b")) {
                return 1;
            }
            if (v1Parts[i].startsWith("b") && !v2Parts[i].startsWith("b")) {
                return -1;
            }
            int result = ModUpdater.comparePreReleaseVersions(v1Parts[i], v2Parts[i]);
            if (result == 0) continue;
            return result;
        }
        if (v1Parts.length != v2Parts.length) {
            if (i == v1Parts.length && i < v2Parts.length && v2Parts[i].startsWith("b")) {
                return 1;
            }
            if (i == v2Parts.length && i < v1Parts.length && v1Parts[i].startsWith("b")) {
                return -1;
            }
        }
        return Integer.compare(v1Parts.length, v2Parts.length);
    }

    private static int comparePreReleaseVersions(String v1, String v2) {
        if (v1.startsWith("b") && v2.startsWith("b")) {
            return ModUpdater.compareWithSubVersions(v1.substring(1), v2.substring(1));
        }
        return v1.compareTo(v2);
    }

    private static int compareWithSubVersions(String v1, String v2) {
        String[] parts1 = v1.split("(?<=\\d)(?=\\D)|(?<=\\D)(?=\\d)");
        String[] parts2 = v2.split("(?<=\\d)(?=\\D)|(?<=\\D)(?=\\d)");
        for (int i = 0; i < parts1.length && i < parts2.length; ++i) {
            if (parts1[i].matches("\\d+") && parts2[i].matches("\\d+")) {
                int num2;
                int num1 = Integer.parseInt(parts1[i]);
                if (num1 == (num2 = Integer.parseInt(parts2[i]))) continue;
                return Integer.compare(num1, num2);
            }
            int result = parts1[i].compareTo(parts2[i]);
            if (result == 0) continue;
            return result;
        }
        return Integer.compare(parts1.length, parts2.length);
    }

    public static boolean replaceConfigSetting(ModConfigSpec.ConfigValue<List<? extends List<?>>> config, String key, Consumer<List<Object>> modifier) {
        ArrayList setting = new ArrayList((Collection)config.get());
        for (int i = 0; i < setting.size(); ++i) {
            ArrayList element = new ArrayList((Collection)setting.get(i));
            if (element.isEmpty() || !element.get(0).equals(key)) continue;
            try {
                modifier.accept(element);
                setting.set(i, element);
                config.set(setting);
                return true;
            }
            catch (Exception e) {
                ColdSweat.LOGGER.error("Failed to update config setting {} for key '{}'", (Object)config.getPath(), (Object)key, (Object)e);
                return false;
            }
        }
        return false;
    }

    public static void addConfigSetting(ModConfigSpec.ConfigValue<List<? extends List<?>>> config, List<?> newSetting) {
        ArrayList setting = new ArrayList((Collection)config.get());
        if (setting.stream().noneMatch(entry -> !entry.isEmpty() && entry.get(0).equals(newSetting.get(0)))) {
            config.clearCache();
            setting.add(newSetting);
            config.set(setting);
        }
    }

    public static void removeConfigSetting(ModConfigSpec.ConfigValue<List<? extends List<? extends Object>>> config, String key) {
        ArrayList<List> setting = new ArrayList<List>((Collection)config.get());
        setting.removeIf(entry -> !entry.isEmpty() && entry.get(0).equals(key));
        config.set(setting);
    }
}

