/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.config;

import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.event.core.registry.CreateRegistriesEvent;
import com.momosoftworks.coldsweat.api.event.vanilla.ServerConfigsLoadedEvent;
import com.momosoftworks.coldsweat.api.registry.BlockTempRegistry;
import com.momosoftworks.coldsweat.api.temperature.block_temp.BlockTempConfig;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.TempModifierInit;
import com.momosoftworks.coldsweat.data.ModRegistries;
import com.momosoftworks.coldsweat.data.codec.configuration.BiomeTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.BlockTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.DepthTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.DimensionTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.DryingItemData;
import com.momosoftworks.coldsweat.data.codec.configuration.EntityClimateData;
import com.momosoftworks.coldsweat.data.codec.configuration.EntityTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.FoodData;
import com.momosoftworks.coldsweat.data.codec.configuration.FuelData;
import com.momosoftworks.coldsweat.data.codec.configuration.InsulatorData;
import com.momosoftworks.coldsweat.data.codec.configuration.ItemCarryTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.ItemInsulationSlotsData;
import com.momosoftworks.coldsweat.data.codec.configuration.MountData;
import com.momosoftworks.coldsweat.data.codec.configuration.RemoveRegistryData;
import com.momosoftworks.coldsweat.data.codec.configuration.SpawnBiomeData;
import com.momosoftworks.coldsweat.data.codec.configuration.StructureTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.TempEffectsData;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.ItemRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.LocationRequirement;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.data.tag.ModBlockTags;
import com.momosoftworks.coldsweat.data.tag.ModDimensionTags;
import com.momosoftworks.coldsweat.data.tag.ModEffectTags;
import com.momosoftworks.coldsweat.data.tag.ModItemTags;
import com.momosoftworks.coldsweat.util.math.RegistryMultiMap;
import com.momosoftworks.coldsweat.util.serialization.RegistryHelper;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.logging.log4j.Logger;

@EventBusSubscriber
public class ConfigLoadingHandler {
    public static final Multimap<ResourceKey<Registry<? extends ConfigData>>, RemoveRegistryData<?>> REMOVED_REGISTRIES = new RegistryMultiMap();

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void loadConfigs(ServerConfigsLoadedEvent event) {
        ConfigSettings.clear();
        BlockTempRegistry.flush();
        RegistryAccess.Frozen registryAccess = event.getServer().registryAccess();
        RegistryMultiMap<ResourceKey<? extends Registry<? extends ConfigData>>, Holder<? extends ConfigData>> registries = new RegistryMultiMap<ResourceKey<? extends Registry<? extends ConfigData>>, Holder<? extends ConfigData>>();
        ColdSweat.LOGGER.info("Loading registries from configs...");
        registries.putAll(ConfigLoadingHandler.collectUserRegistries((RegistryAccess)registryAccess));
        ColdSweat.LOGGER.info("Loading registries from data resources...");
        registries.putAll(ConfigLoadingHandler.collectDataRegistries((RegistryAccess)registryAccess));
        ConfigLoadingHandler.logAndAddRegistries((RegistryAccess)registryAccess, registries);
        ColdSweat.LOGGER.info("Loading TOML configs...");
        ConfigSettings.load((RegistryAccess)registryAccess, false);
        TempModifierInit.buildBlockConfigs();
        ColdSweat.LOGGER.info("Loading BlockTemps...");
        TempModifierInit.buildBlockRegistries();
    }

    public static Multimap<ResourceKey<Registry<? extends ConfigData>>, Holder<? extends ConfigData>> collectDataRegistries(RegistryAccess registryAccess) {
        if (registryAccess == null) {
            ColdSweat.LOGGER.error("Failed to load registries from null RegistryAccess");
            return new RegistryMultiMap<ResourceKey<Registry<? extends ConfigData>>, Holder<? extends ConfigData>>();
        }
        ConfigSettings.THERMAL_SOURCE_SPREAD_WHITELIST.get().addAll(((HolderSet.Named)registryAccess.registryOrThrow(Registries.BLOCK).getTag(ModBlockTags.HEARTH_SPREAD_WHITELIST).orElseThrow()).stream().map(holder -> {
            ColdSweat.LOGGER.info("Adding block {} to hearth spread whitelist", holder.value());
            return (Block)holder.value();
        }).toList());
        ConfigSettings.THERMAL_SOURCE_SPREAD_BLACKLIST.get().addAll(((HolderSet.Named)registryAccess.registryOrThrow(Registries.BLOCK).getTag(ModBlockTags.HEARTH_SPREAD_BLACKLIST).orElseThrow()).stream().map(holder -> {
            ColdSweat.LOGGER.info("Adding block {} to hearth spread blacklist", holder.value());
            return (Block)holder.value();
        }).toList());
        ConfigSettings.SLEEP_CHECK_IGNORE_BLOCKS.get().addAll(((HolderSet.Named)registryAccess.registryOrThrow(Registries.BLOCK).getTag(ModBlockTags.IGNORE_SLEEP_CHECK).orElseThrow()).stream().map(holder -> {
            ColdSweat.LOGGER.info("Disabling sleeping conditions check for block {}", holder.value());
            return (Block)holder.value();
        }).toList());
        ConfigSettings.LAMP_DIMENSIONS.get(registryAccess).addAll(((HolderSet.Named)registryAccess.registryOrThrow(Registries.DIMENSION_TYPE).getTag(ModDimensionTags.SOUL_LAMP_VALID).orElseThrow()).stream().map(holder -> {
            ColdSweat.LOGGER.info("Enabling dimension {} for soulspring lamp", holder.value());
            return (DimensionType)holder.value();
        }).toList());
        ConfigSettings.INSULATION_BLACKLIST.get().addAll(((HolderSet.Named)registryAccess.registryOrThrow(Registries.ITEM).getTag(ModItemTags.NOT_INSULATABLE).orElseThrow()).stream().map(holder -> {
            ColdSweat.LOGGER.info("Adding item {} to insulation blacklist", holder.value());
            return (Item)holder.value();
        }).toList());
        ConfigSettings.HEARTH_POTION_BLACKLIST.get().addAll(((HolderSet.Named)registryAccess.registryOrThrow(Registries.MOB_EFFECT).getTag(ModEffectTags.HEARTH_BLACKLISTED).orElseThrow()).stream().map(holder -> {
            ColdSweat.LOGGER.info("Adding effect {} to hearth potion blacklist", holder.value());
            return (MobEffect)holder.value();
        }).toList());
        RegistryMultiMap<ResourceKey<Registry<? extends ConfigData>>, Holder<? extends ConfigData>> registries = new RegistryMultiMap<ResourceKey<Registry<? extends ConfigData>>, Holder<? extends ConfigData>>();
        for (Map.Entry<String, ModRegistries.RegistryHolder<?>> entry : ModRegistries.getRegistries().entrySet()) {
            ResourceKey<Registry<?>> key = entry.getValue().registry();
            registries.putAll(key, registryAccess.registryOrThrow(key).holders().toList());
        }
        return registries;
    }

    public static Multimap<ResourceKey<Registry<? extends ConfigData>>, Holder<? extends ConfigData>> collectUserRegistries(RegistryAccess registryAccess) {
        if (registryAccess == null) {
            ColdSweat.LOGGER.error("Failed to load registries from null RegistryAccess");
            return new RegistryMultiMap<ResourceKey<Registry<? extends ConfigData>>, Holder<? extends ConfigData>>();
        }
        RegistryMultiMap<ResourceKey<Registry<? extends ConfigData>>, Holder<? extends ConfigData>> registries = new RegistryMultiMap<ResourceKey<Registry<? extends ConfigData>>, Holder<? extends ConfigData>>();
        for (Map.Entry<String, ModRegistries.RegistryHolder<?>> entry : ModRegistries.getRegistries().entrySet()) {
            ResourceKey<Registry<?>> key = entry.getValue().registry();
            Codec<?> codec = entry.getValue().codec();
            registries.putAll(key, ConfigLoadingHandler.parseConfigData(key, codec, registryAccess));
        }
        return registries;
    }

    private static void logAndAddRegistries(RegistryAccess registryAccess, RegistryMultiMap<ResourceKey<? extends Registry<? extends ConfigData>>, Holder<? extends ConfigData>> registries) {
        ConfigLoadingHandler.setDefaultRegistryPriority(registries);
        ConfigLoadingHandler.loadRegistryRemovals(registryAccess);
        for (Holder<? extends ConfigData> holder2 : registries.values()) {
            ((ConfigData)holder2.value()).setRegistryType(ConfigData.Type.JSON);
        }
        CreateRegistriesEvent.Pre event = new CreateRegistriesEvent.Pre(registryAccess, registries, REMOVED_REGISTRIES);
        NeoForge.EVENT_BUS.post((Event)event);
        registries.values().removeIf(holder -> !((ConfigData)holder.value()).areRequiredModsLoaded());
        ConfigLoadingHandler.removeRegistries(event.getRegistries());
        Collection<Holder<InsulatorData>> insulators = event.getRegistry(ModRegistries.INSULATOR_DATA);
        ConfigLoadingHandler.addInsulatorConfigs(insulators);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s insulators", insulators.size()), insulators);
        Collection<Holder<FuelData>> fuels = event.getRegistry(ModRegistries.FUEL_DATA);
        ConfigLoadingHandler.addFuelConfigs(fuels);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s fuels", fuels.size()), fuels);
        Collection<Holder<FoodData>> foods = event.getRegistry(ModRegistries.FOOD_DATA);
        ConfigLoadingHandler.addFoodConfigs(foods);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s foods", foods.size()), foods);
        Collection<Holder<ItemCarryTempData>> carryTemps = event.getRegistry(ModRegistries.CARRY_TEMP_DATA);
        ConfigLoadingHandler.addCarryTempConfigs(carryTemps);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s carried item temperatures", carryTemps.size()), carryTemps);
        Collection<Holder<DryingItemData>> dryingItems = event.getRegistry(ModRegistries.DRYING_ITEM_DATA);
        ConfigLoadingHandler.addDryingItemConfigs(dryingItems);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s drying items", dryingItems.size()), dryingItems);
        Collection<Holder<ItemInsulationSlotsData>> insulationSlots = event.getRegistry(ModRegistries.INSULATION_SLOTS_DATA);
        ConfigLoadingHandler.addInsulationSlotConfigs(insulationSlots);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s insulation slots configs", insulationSlots.size()), insulationSlots);
        Collection<Holder<BlockTempData>> blockTemps = event.getRegistry(ModRegistries.BLOCK_TEMP_DATA);
        ConfigLoadingHandler.addBlockTempConfigs(blockTemps);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s block temperatures", blockTemps.size()), blockTemps);
        Collection<Holder<BiomeTempData>> biomeTemps = event.getRegistry(ModRegistries.BIOME_TEMP_DATA);
        ConfigLoadingHandler.addBiomeTempConfigs(biomeTemps, registryAccess);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s biome temperatures", biomeTemps.size()), biomeTemps);
        Collection<Holder<DimensionTempData>> dimensionTemps = event.getRegistry(ModRegistries.DIMENSION_TEMP_DATA);
        ConfigLoadingHandler.addDimensionTempConfigs(dimensionTemps, registryAccess);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s dimension temperatures", dimensionTemps.size()), dimensionTemps);
        Collection<Holder<StructureTempData>> structureTemps = event.getRegistry(ModRegistries.STRUCTURE_TEMP_DATA);
        ConfigLoadingHandler.addStructureTempConfigs(structureTemps, registryAccess);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s structure temperatures", structureTemps.size()), structureTemps);
        Collection<Holder<DepthTempData>> depthTemps = event.getRegistry(ModRegistries.DEPTH_TEMP_DATA);
        ConfigLoadingHandler.addDepthTempConfigs(depthTemps);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s depth temperatures", depthTemps.size()), depthTemps);
        Collection<Holder<MountData>> mounts = event.getRegistry(ModRegistries.MOUNT_DATA);
        ConfigLoadingHandler.addMountConfigs(mounts);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s insulated mounts", mounts.size()), mounts);
        Collection<Holder<SpawnBiomeData>> spawnBiomes = event.getRegistry(ModRegistries.ENTITY_SPAWN_BIOME_DATA);
        ConfigLoadingHandler.addSpawnBiomeConfigs(spawnBiomes, registryAccess);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s entity spawn biomes", spawnBiomes.size()), spawnBiomes);
        Collection<Holder<EntityTempData>> entityTemps = event.getRegistry(ModRegistries.ENTITY_TEMP_DATA);
        ConfigLoadingHandler.addEntityTempConfigs(entityTemps);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s entity temperatures", entityTemps.size()), entityTemps);
        Collection<Holder<EntityClimateData>> entityClimates = event.getRegistry(ModRegistries.ENTITY_CLIMATE_DATA);
        ConfigLoadingHandler.addEntityClimateConfigs(entityClimates);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s entity climates", entityClimates.size()), entityClimates);
        Collection<Holder<TempEffectsData>> tempEffects = event.getRegistry(ModRegistries.TEMP_EFFECTS_DATA);
        ConfigLoadingHandler.addTempEffectsConfigs(tempEffects);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s temp effects", tempEffects.size()), tempEffects);
        CreateRegistriesEvent.Post postEvent = new CreateRegistriesEvent.Post(registryAccess, event.getRegistries());
        NeoForge.EVENT_BUS.post((Event)postEvent);
    }

    private static void logRegistryLoaded(String message, Collection<?> registry) {
        message = registry.isEmpty() ? (String)message + "." : (String)message + ":";
        ColdSweat.LOGGER.info((String)message, (Object)registry.size());
        if (registry.isEmpty()) {
            return;
        }
        for (Object entry : registry) {
            if (entry instanceof Holder) {
                Holder holder = (Holder)entry;
                ColdSweat.LOGGER.info("{}", holder.value());
                continue;
            }
            ColdSweat.LOGGER.info("{}", entry);
        }
    }

    private static void setDefaultRegistryPriority(Multimap<ResourceKey<? extends Registry<? extends ConfigData>>, Holder<? extends ConfigData>> registries) {
        for (ResourceKey key : registries.keySet()) {
            ArrayList<Holder> sortedHolders = new ArrayList<Holder>(registries.get((Object)key));
            sortedHolders.sort(Comparator.comparing(holder -> holder.unwrapKey().map(k -> k.location().getPath().startsWith("default") ? 1 : 0).orElse(0)));
            registries.replaceValues((Object)key, sortedHolders);
        }
    }

    private static void loadRegistryRemovals(RegistryAccess registryAccess) {
        REMOVED_REGISTRIES.clear();
        Set<Holder> removals = registryAccess.registryOrThrow(ModRegistries.REMOVE_REGISTRY_DATA).holders().collect(Collectors.toSet());
        removals.addAll(ConfigLoadingHandler.parseConfigData(ModRegistries.REMOVE_REGISTRY_DATA, RemoveRegistryData.CODEC, registryAccess));
        removals.forEach(holder -> {
            RemoveRegistryData data = (RemoveRegistryData)holder.value();
            ResourceKey key = data.registry();
            REMOVED_REGISTRIES.put(key, (Object)data);
        });
    }

    private static void removeRegistries(Multimap<ResourceKey<? extends Registry<? extends ConfigData>>, Holder<? extends ConfigData>> registries) {
        ColdSweat.LOGGER.info("Handling registry removals...");
        for (Map.Entry entry : REMOVED_REGISTRIES.asMap().entrySet()) {
            ConfigLoadingHandler.removeEntries((Collection)entry.getValue(), registries.get((Object)((ResourceKey)entry.getKey())));
        }
    }

    private static <T extends ConfigData> void removeEntries(Collection<RemoveRegistryData<T>> removals, Collection<Holder<T>> registry) {
        for (RemoveRegistryData<T> data : removals) {
            registry.removeIf(data::matches);
        }
    }

    public static <T extends ConfigData> Collection<T> removeEntries(Collection<T> registries, ResourceKey<Registry<T>> registryName) {
        REMOVED_REGISTRIES.get(registryName).forEach(data -> {
            RemoveRegistryData removeData = (RemoveRegistryData)data;
            if (removeData.registry() == registryName) {
                registries.removeIf(removeData::matches);
            }
        });
        return registries;
    }

    public static <T extends ConfigData> boolean isRemoved(T entry, ResourceKey<Registry<T>> registryName) {
        return REMOVED_REGISTRIES.get(registryName).stream().anyMatch(data -> ((RemoveRegistryData)data).matches(entry));
    }

    private static void addInsulatorConfigs(Collection<Holder<InsulatorData>> insulators) {
        insulators.forEach(holder -> {
            InsulatorData insulator = (InsulatorData)holder.value();
            ArrayList items = new ArrayList(RegistryHelper.mapBuiltinRegistryTagList(BuiltInRegistries.ITEM, insulator.item().nestedFlatMap(ItemRequirement::items)));
            if (items.isEmpty()) {
                items.add(null);
            }
            for (Item item : items) {
                switch (insulator.slot()) {
                    case ITEM: {
                        ConfigSettings.INSULATION_ITEMS.get().put((Object)item, (Object)insulator);
                        break;
                    }
                    case ARMOR: {
                        ConfigSettings.INSULATING_ARMORS.get().put((Object)item, (Object)insulator);
                        break;
                    }
                    case CURIO: {
                        if (!CompatManager.isCuriosLoaded()) break;
                        ConfigSettings.INSULATING_CURIOS.get().put((Object)item, (Object)insulator);
                    }
                }
            }
        });
    }

    private static void addFuelConfigs(Collection<Holder<FuelData>> fuels) {
        fuels.forEach(holder -> {
            FuelData fuelData = (FuelData)holder.value();
            ArrayList items = new ArrayList(RegistryHelper.mapBuiltinRegistryTagList(BuiltInRegistries.ITEM, fuelData.item().nestedFlatMap(ItemRequirement::items)));
            if (items.isEmpty()) {
                items.add(null);
            }
            for (Item item : items) {
                switch (fuelData.fuelType()) {
                    case BOILER: {
                        ConfigSettings.BOILER_FUEL.get().put((Object)item, (Object)fuelData);
                        break;
                    }
                    case ICEBOX: {
                        ConfigSettings.ICEBOX_FUEL.get().put((Object)item, (Object)fuelData);
                        break;
                    }
                    case HEARTH: {
                        ConfigSettings.HEARTH_FUEL.get().put((Object)item, (Object)fuelData);
                        break;
                    }
                    case SOUL_LAMP: {
                        ConfigSettings.SOULSPRING_LAMP_FUEL.get().put((Object)item, (Object)fuelData);
                    }
                }
            }
        });
    }

    private static void addFoodConfigs(Collection<Holder<FoodData>> foods) {
        foods.forEach(holder -> {
            FoodData foodData = (FoodData)holder.value();
            ArrayList items = new ArrayList(RegistryHelper.mapBuiltinRegistryTagList(BuiltInRegistries.ITEM, foodData.item().nestedFlatMap(ItemRequirement::items)));
            if (items.isEmpty()) {
                items.add(null);
            }
            for (Item item : items) {
                ConfigSettings.FOOD_TEMPERATURES.get().put((Object)item, (Object)foodData);
            }
        });
    }

    private static void addCarryTempConfigs(Collection<Holder<ItemCarryTempData>> carryTemps) {
        carryTemps.forEach(holder -> {
            ItemCarryTempData carryTempData = (ItemCarryTempData)holder.value();
            ArrayList items = new ArrayList(RegistryHelper.mapBuiltinRegistryTagList(BuiltInRegistries.ITEM, carryTempData.item().nestedFlatMap(ItemRequirement::items)));
            if (items.isEmpty()) {
                items.add(null);
            }
            for (Item item : items) {
                ConfigSettings.CARRIED_ITEM_TEMPERATURES.get().put((Object)item, (Object)carryTempData);
            }
        });
    }

    private static void addDryingItemConfigs(Collection<Holder<DryingItemData>> dryingItems) {
        dryingItems.forEach(holder -> {
            DryingItemData dryingItemData = (DryingItemData)holder.value();
            ArrayList items = new ArrayList(RegistryHelper.mapBuiltinRegistryTagList(BuiltInRegistries.ITEM, dryingItemData.item().nestedFlatMap(ItemRequirement::items)));
            if (items.isEmpty()) {
                items.add(null);
            }
            for (Item item : items) {
                ConfigSettings.DRYING_ITEMS.get().put((Object)item, (Object)dryingItemData);
            }
        });
    }

    private static void addInsulationSlotConfigs(Collection<Holder<ItemInsulationSlotsData>> insulationSlots) {
        insulationSlots.forEach(holder -> {
            ItemInsulationSlotsData insulationSlotData = (ItemInsulationSlotsData)holder.value();
            ArrayList items = new ArrayList(RegistryHelper.mapBuiltinRegistryTagList(BuiltInRegistries.ITEM, insulationSlotData.item().nestedFlatMap(ItemRequirement::items)));
            if (items.isEmpty()) {
                items.add(null);
            }
            for (Item item : items) {
                ConfigSettings.INSULATION_SLOT_OVERRIDES.get().put((Object)item, (Object)insulationSlotData);
            }
        });
    }

    private static void addBlockTempConfigs(Collection<Holder<BlockTempData>> blockTemps) {
        blockTemps.forEach(holder -> {
            final BlockTempData blockTempData = (BlockTempData)holder.value();
            BlockTempConfig blockTemp = new BlockTempConfig(blockTempData){
                final double temperature;
                final NegatableList<LocationRequirement> locationRequirement;
                final NegatableList<EntityRequirement> entityRequirement;
                {
                    super(data);
                    this.temperature = blockTempData.getTemperature();
                    this.locationRequirement = blockTempData.location();
                    this.entityRequirement = blockTempData.entity();
                }

                @Override
                public double getTemperature(Level level, LivingEntity entity, BlockState state, BlockPos pos, double distance) {
                    if (this.locationRequirement.test(req -> req.test(level, pos)) && this.entityRequirement.test(req -> req.test((Entity)entity))) {
                        return this.temperature;
                    }
                    return 0.0;
                }
            };
            BlockTempRegistry.register(blockTemp);
        });
    }

    private static void addBiomeTempConfigs(Collection<Holder<BiomeTempData>> biomeTemps, RegistryAccess registryAccess) {
        biomeTemps.forEach(holder -> {
            BiomeTempData biomeTempData = (BiomeTempData)holder.value();
            for (Holder biome : RegistryHelper.mapRegistryTagList(Registries.BIOME, biomeTempData.biomes().flatten(), registryAccess)) {
                if (biomeTempData.isOffset()) {
                    ConfigSettings.BIOME_OFFSETS.get(registryAccess).put(biome, biomeTempData);
                    continue;
                }
                ConfigSettings.BIOME_TEMPS.get(registryAccess).put(biome, biomeTempData);
            }
        });
    }

    private static void addDimensionTempConfigs(Collection<Holder<DimensionTempData>> dimensionTemps, RegistryAccess registryAccess) {
        dimensionTemps.forEach(holder -> {
            DimensionTempData dimensionTempData = (DimensionTempData)holder.value();
            for (Holder dimension : RegistryHelper.mapRegistryTagList(Registries.DIMENSION_TYPE, dimensionTempData.dimensions().flatten(), registryAccess)) {
                if (dimensionTempData.isOffset()) {
                    ConfigSettings.DIMENSION_OFFSETS.get(registryAccess).put(dimension, dimensionTempData);
                    continue;
                }
                ConfigSettings.DIMENSION_TEMPS.get(registryAccess).put(dimension, dimensionTempData);
            }
        });
    }

    private static void addStructureTempConfigs(Collection<Holder<StructureTempData>> structureTemps, RegistryAccess registryAccess) {
        structureTemps.forEach(holder -> {
            StructureTempData structureTempData = (StructureTempData)holder.value();
            for (Holder structure : RegistryHelper.mapRegistryTagList(Registries.STRUCTURE, structureTempData.structures().flatten(), registryAccess)) {
                if (structureTempData.isOffset()) {
                    ConfigSettings.STRUCTURE_OFFSETS.get(registryAccess).put(structure, structureTempData);
                    continue;
                }
                ConfigSettings.STRUCTURE_TEMPS.get(registryAccess).put(structure, structureTempData);
            }
        });
    }

    private static void addDepthTempConfigs(Collection<Holder<DepthTempData>> depthTemps) {
        for (Holder<DepthTempData> holder : depthTemps) {
            ConfigSettings.DEPTH_REGIONS.get().add((DepthTempData)holder.value());
        }
    }

    private static void addMountConfigs(Collection<Holder<MountData>> mounts) {
        mounts.forEach(holder -> {
            MountData mountData = (MountData)holder.value();
            ArrayList entities = new ArrayList(RegistryHelper.mapBuiltinRegistryTagList(BuiltInRegistries.ENTITY_TYPE, mountData.entity().nestedFlatMap(EntityRequirement::entities)));
            if (entities.isEmpty()) {
                entities.add(null);
            }
            for (EntityType entity : entities) {
                ConfigSettings.INSULATED_MOUNTS.get().put((Object)entity, (Object)mountData);
            }
        });
    }

    private static void addSpawnBiomeConfigs(Collection<Holder<SpawnBiomeData>> spawnBiomes, RegistryAccess registryAccess) {
        spawnBiomes.forEach(holder -> {
            SpawnBiomeData spawnBiomeData = (SpawnBiomeData)holder.value();
            for (Holder biome : RegistryHelper.mapRegistryTagList(Registries.BIOME, spawnBiomeData.biomes(), registryAccess)) {
                ConfigSettings.ENTITY_SPAWN_BIOMES.get(registryAccess).put(biome, (Object)spawnBiomeData);
            }
        });
    }

    private static void addEntityTempConfigs(Collection<Holder<EntityTempData>> entityTemps) {
        entityTemps.forEach(holder -> {
            EntityTempData entityTempData = (EntityTempData)holder.value();
            ArrayList entities = new ArrayList(RegistryHelper.mapBuiltinRegistryTagList(BuiltInRegistries.ENTITY_TYPE, entityTempData.entity().nestedFlatMap(EntityRequirement::entities)));
            if (entities.isEmpty()) {
                entities.add(null);
            }
            for (EntityType entity : entities) {
                ConfigSettings.ENTITY_TEMPERATURES.get().put((Object)entity, (Object)entityTempData);
            }
        });
    }

    private static void addEntityClimateConfigs(Collection<Holder<EntityClimateData>> entityTemps) {
        entityTemps.forEach(holder -> {
            EntityClimateData entityTempData = (EntityClimateData)holder.value();
            ArrayList entities = new ArrayList(RegistryHelper.mapBuiltinRegistryTagList(BuiltInRegistries.ENTITY_TYPE, entityTempData.entity().nestedFlatMap(EntityRequirement::entities)));
            if (entities.isEmpty()) {
                entities.add(null);
            }
            for (EntityType entity : entities) {
                ConfigSettings.ENTITY_CLIMATES.get().put((Object)entity, (Object)entityTempData);
            }
        });
    }

    private static void addTempEffectsConfigs(Collection<Holder<TempEffectsData>> tempEffects) {
        tempEffects.forEach(holder -> {
            TempEffectsData tempEffectsData = (TempEffectsData)holder.value();
            ArrayList entities = new ArrayList(RegistryHelper.mapBuiltinRegistryTagList(BuiltInRegistries.ENTITY_TYPE, tempEffectsData.entity().nestedFlatMap(EntityRequirement::entities)));
            if (entities.isEmpty()) {
                entities.add(null);
            }
            for (EntityType entity : entities) {
                ConfigSettings.ENTITY_TEMP_EFFECTS.get().put((Object)entity, (Object)tempEffectsData);
            }
        });
    }

    private static <T extends ConfigData> List<Holder<T>> parseConfigData(ResourceKey<Registry<T>> registry, Codec<T> codec, RegistryAccess registryAccess) {
        ArrayList output = new ArrayList();
        RegistryOps registryOps = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registryAccess);
        String configFolder = registry.location().getNamespace().replace("_", "");
        Path coldSweatDataPath = FMLPaths.CONFIGDIR.get().resolve(configFolder + "/data").resolve(registry.location().getPath());
        File jsonDirectory = coldSweatDataPath.toFile();
        if (!jsonDirectory.exists()) {
            return output;
        }
        for (File file : ConfigLoadingHandler.findFilesRecursive(jsonDirectory)) {
            if (!file.getName().endsWith(".json")) continue;
            try (FileReader reader = new FileReader(file);){
                codec.decode((DynamicOps)registryOps, (Object)GsonHelper.parse((Reader)reader)).resultOrPartial(arg_0 -> ((Logger)ColdSweat.LOGGER).error(arg_0)).map(Pair::getFirst).ifPresent(configData -> output.add(Holder.direct((Object)configData)));
            }
            catch (Exception e) {
                ColdSweat.LOGGER.error("Failed to parse JSON config setting in {}: {}", (Object)registry.location(), (Object)file.getName(), (Object)e);
            }
        }
        return output;
    }

    public static List<File> findFilesRecursive(File directory) {
        ArrayList<File> files = new ArrayList<File>();
        File[] filesInDirectory = directory.listFiles();
        if (filesInDirectory == null) {
            return files;
        }
        for (File file : filesInDirectory) {
            if (file.isDirectory()) {
                files.addAll(ConfigLoadingHandler.findFilesRecursive(file));
                continue;
            }
            files.add(file);
        }
        return files;
    }

    @EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
    public static final class ClientConfigs {
        @SubscribeEvent
        public static void loadClientConfigs(FMLLoadCompleteEvent event) {
            ConfigSettings.CLIENT_SETTINGS.forEach((id, holder) -> holder.load(true));
        }
    }
}

