/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.item;

import com.momosoftworks.coldsweat.api.temperature.modifier.SoulLampTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Placement;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.client.event.RegisterModels;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.advancement.trigger.SoulLampFuelledTrigger;
import com.momosoftworks.coldsweat.core.init.ModAdvancementTriggers;
import com.momosoftworks.coldsweat.core.init.ModItemComponents;
import com.momosoftworks.coldsweat.core.init.ModSounds;
import com.momosoftworks.coldsweat.core.network.message.ParticleBatchMessage;
import com.momosoftworks.coldsweat.data.codec.configuration.FuelData;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.serialization.NBTHelper;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

@EventBusSubscriber
public class SoulspringLampItem
extends Item {
    public SoulspringLampItem() {
        super(new Item.Properties().stacksTo(1).fireResistant().rarity(Rarity.UNCOMMON).component(ModItemComponents.SOULSPRING_LAMP_LIT, (Object)false).component(ModItemComponents.SOULSPRING_LAMP_FUEL, (Object)0.0).component(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)new CompoundTag())));
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(this){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                RegisterModels.checkForInitModels();
                return RegisterModels.SOULSPRING_LAMP_RENDERER;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inventoryTick(ItemStack stack, Level level, Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (living.tickCount % 5 == 0) {
                boolean shouldBeOn;
                block22: {
                    block21: {
                        shouldBeOn = false;
                        if (isSelected || living.getOffhandItem() == stack) break block21;
                        if (!level.isClientSide()) {
                            CustomData itemTag = NBTHelper.getOrCreateTag(stack);
                            if (itemTag.copyTag().getInt("stateChangeTimer") <= 0 && CSMath.orElse((Boolean)stack.get(ModItemComponents.SOULSPRING_LAMP_LIT), false) != shouldBeOn) {
                                stack.set(DataComponents.CUSTOM_DATA, (Object)itemTag.update(tag -> tag.putInt("stateChangeTimer", 2)));
                                SoulspringLampItem.setLit(stack, shouldBeOn);
                                if (SoulspringLampItem.getFuel(stack) < 0.5) {
                                    SoulspringLampItem.setFuel(stack, 0.0);
                                }
                                WorldHelper.playEntitySound(shouldBeOn ? (SoundEvent)ModSounds.SOUL_LAMP_ON.value() : (SoundEvent)ModSounds.SOUL_LAMP_OFF.value(), (Entity)living, living.getSoundSource(), 1.5f, (float)Math.random() / 5.0f + 0.9f);
                            } else {
                                NBTHelper.incrementTag(stack, "stateChangeTimer", -1, tag -> tag > 0);
                            }
                        }
                        return;
                    }
                    try {
                        Player player;
                        double max = Temperature.get(living, Temperature.Trait.BURNING_POINT);
                        double temp = Temperature.getModifier(living, Temperature.Trait.WORLD, SoulLampTempModifier.class).map(mod -> mod.getLastInput(Temperature.Trait.WORLD)).orElseGet(() -> Temperature.get(living, Temperature.Trait.WORLD));
                        if (!ConfigSettings.LAMP_DIMENSIONS.get(level.registryAccess()).contains(level.dimensionType()) || !(temp > max) || !(SoulspringLampItem.getFuel(stack) > 0.0)) break block22;
                        if (!(living instanceof Player && (player = (Player)living).isCreative() || living.isSpectator())) {
                            SoulspringLampItem.addFuel(stack, -0.005 * CSMath.clamp(temp - max, 1.0, 3.0));
                        }
                        double radius = 5.0;
                        AABB bb = new AABB(living.getX() - radius, living.getY() + (double)(living.getBbHeight() / 2.0f) - radius, living.getZ() - radius, living.getX() + radius, living.getY() + (double)(living.getBbHeight() / 2.0f) + radius, living.getZ() + radius);
                        if (Math.random() < 0.6) {
                            AABB bb2 = bb.inflate(-3.0);
                            double x = bb2.minX + (bb2.maxX - bb2.minX) * Math.random();
                            double y = bb2.minY + (bb2.maxY - bb2.minY) * Math.random();
                            double z = bb2.minZ + (bb2.maxZ - bb2.minZ) * Math.random();
                            double xSpeed = (Math.random() - 0.5) * 0.02;
                            double zSpeed = (Math.random() - 0.5) * 0.02;
                            new ParticleBatchMessage(0).addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, x, y, z, xSpeed, 0.0, zSpeed).sendEntity((Entity)living);
                        }
                        for (LivingEntity ent : level.getEntitiesOfClass(LivingEntity.class, bb)) {
                            if (!EntityTempManager.isTemperatureEnabled((Entity)ent)) continue;
                            Optional<SoulLampTempModifier> mod2 = Temperature.getModifier(ent, Temperature.Trait.WORLD, SoulLampTempModifier.class);
                            if (mod2.isPresent()) {
                                mod2.get().setTicksExisted(0);
                                continue;
                            }
                            Temperature.addOrReplaceModifier(ent, ((TempModifier)new SoulLampTempModifier().expires(5)).tickRate(5), Temperature.Trait.WORLD, Placement.Duplicates.BY_CLASS);
                        }
                        shouldBeOn = true;
                    }
                    catch (Throwable throwable) {
                        if (!level.isClientSide()) {
                            CustomData itemTag = NBTHelper.getOrCreateTag(stack);
                            if (itemTag.copyTag().getInt("stateChangeTimer") <= 0 && CSMath.orElse((Boolean)stack.get(ModItemComponents.SOULSPRING_LAMP_LIT), false) != shouldBeOn) {
                                stack.set(DataComponents.CUSTOM_DATA, (Object)itemTag.update(tag -> tag.putInt("stateChangeTimer", 2)));
                                SoulspringLampItem.setLit(stack, shouldBeOn);
                                if (SoulspringLampItem.getFuel(stack) < 0.5) {
                                    SoulspringLampItem.setFuel(stack, 0.0);
                                }
                                WorldHelper.playEntitySound(shouldBeOn ? (SoundEvent)ModSounds.SOUL_LAMP_ON.value() : (SoundEvent)ModSounds.SOUL_LAMP_OFF.value(), (Entity)living, living.getSoundSource(), 1.5f, (float)Math.random() / 5.0f + 0.9f);
                            } else {
                                NBTHelper.incrementTag(stack, "stateChangeTimer", -1, tag -> tag > 0);
                            }
                        }
                        throw throwable;
                    }
                }
                if (!level.isClientSide()) {
                    CustomData itemTag = NBTHelper.getOrCreateTag(stack);
                    if (itemTag.copyTag().getInt("stateChangeTimer") <= 0 && CSMath.orElse((Boolean)stack.get(ModItemComponents.SOULSPRING_LAMP_LIT), false) != shouldBeOn) {
                        stack.set(DataComponents.CUSTOM_DATA, (Object)itemTag.update(tag -> tag.putInt("stateChangeTimer", 2)));
                        SoulspringLampItem.setLit(stack, shouldBeOn);
                        if (SoulspringLampItem.getFuel(stack) < 0.5) {
                            SoulspringLampItem.setFuel(stack, 0.0);
                        }
                        WorldHelper.playEntitySound(shouldBeOn ? (SoundEvent)ModSounds.SOUL_LAMP_ON.value() : (SoundEvent)ModSounds.SOUL_LAMP_OFF.value(), (Entity)living, living.getSoundSource(), 1.5f, (float)Math.random() / 5.0f + 0.9f);
                    } else {
                        NBTHelper.incrementTag(stack, "stateChangeTimer", -1, tag -> tag > 0);
                    }
                }
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public static void setFuel(ItemStack stack, double fuel) {
        stack.set(ModItemComponents.SOULSPRING_LAMP_FUEL, (Object)fuel);
    }

    public static void addFuel(ItemStack stack, double amount) {
        SoulspringLampItem.setFuel(stack, Math.min(64.0, SoulspringLampItem.getFuel(stack) + amount));
    }

    public static void addFuel(ItemStack stack, ItemStack fuelStack) {
        SoulspringLampItem.addFuel(stack, SoulspringLampItem.getFuelForStack(fuelStack) * (double)fuelStack.getCount());
    }

    public static double getFuel(ItemStack stack) {
        return (Double)stack.getOrDefault(ModItemComponents.SOULSPRING_LAMP_FUEL, (Object)0.0);
    }

    public static boolean isLit(ItemStack stack) {
        return (Boolean)stack.getOrDefault(ModItemComponents.SOULSPRING_LAMP_LIT, (Object)false);
    }

    public static void setLit(ItemStack stack, boolean lit) {
        stack.set(ModItemComponents.SOULSPRING_LAMP_LIT, (Object)lit);
    }

    public static double getFuelForStack(ItemStack item) {
        return CSMath.getIfNotNull(ConfigHelper.getFirstOrNull(ConfigSettings.SOULSPRING_LAMP_FUEL, item.getItem(), data -> data.test(item)), FuelData::fuel, 0.0);
    }

    @SubscribeEvent
    public static void onEntityHit(LivingIncomingDamageEvent event) {
        Entity entity = event.getSource().getEntity();
        if (entity instanceof Player) {
            Player attacker = (Player)entity;
            if (!(event.getEntity() instanceof Player)) {
                Level level = attacker.level();
                ItemStack stack = attacker.getMainHandItem();
                if (!(stack.getItem() instanceof SoulspringLampItem)) {
                    return;
                }
                LivingEntity target = event.getEntity();
                if (SoulspringLampItem.getFuel(stack) < 64.0 && !target.getType().is(EntityTypeTags.UNDEAD) && !target.getPersistentData().getBoolean("SoulSucked")) {
                    target.getPersistentData().putBoolean("SoulSucked", true);
                    SoulspringLampItem.addFuel(stack, (int)Math.min(8.0f, target.getMaxHealth() / 2.0f));
                    float extraDamage = Math.max(0.0f, 8.0f - event.getAmount());
                    if (extraDamage > 0.0f) {
                        target.hurt(level.damageSources().playerAttack(attacker), extraDamage);
                    }
                    if (!target.level().isClientSide) {
                        int particleCount = (int)CSMath.clamp(target.getBbWidth() * target.getBbWidth() * target.getBbHeight() * 3.0f, 5.0f, 50.0f);
                        WorldHelper.spawnParticleBatch(attacker.level(), (ParticleOptions)ParticleTypes.SOUL, target.getX(), target.getY() + (double)(target.getBbHeight() / 2.0f), target.getZ(), target.getBbWidth() / 2.0f, target.getBbHeight() / 2.0f, target.getBbWidth() / 2.0f, particleCount, 0.05);
                    }
                    if (attacker.level().isClientSide) {
                        WorldHelper.playEntitySound((SoundEvent)ModSounds.SOUL_LAMP_ON.value(), (Entity)attacker, attacker.getSoundSource(), 1.0f, (float)Math.random() / 5.0f + 1.3f);
                    }
                }
            }
        }
    }

    public boolean canAttackBlock(BlockState state, Level level, BlockPos blockPos, Player player) {
        return !player.isCreative();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag advanced) {
        if (advanced.isAdvanced()) {
            tooltip.add((Component)Component.literal((String)("Fuel: " + (int)SoulspringLampItem.getFuel(stack) + " / 64")));
        }
        super.appendHoverText(stack, context, tooltip, advanced);
    }

    public boolean overrideOtherStackedOnMe(ItemStack thisStack, ItemStack fuelStack, Slot slot, ClickAction action, Player player, SlotAccess slotAccess) {
        FuelData fuel = ConfigHelper.findFirstFuelMatching(ConfigSettings.SOULSPRING_LAMP_FUEL, fuelStack).orElse(null);
        if (fuel != null && fuel.test(fuelStack) && SoulspringLampItem.getFuel(thisStack) < 64.0) {
            double currentFuel = SoulspringLampItem.getFuel(thisStack);
            if (action == ClickAction.PRIMARY) {
                SoulspringLampItem.addFuel(thisStack, fuelStack);
                fuelStack.shrink((int)((64.0 - currentFuel) / SoulspringLampItem.getFuelForStack(fuelStack)));
            } else if (action == ClickAction.SECONDARY) {
                ItemStack singleFuelItem = fuelStack.copy();
                singleFuelItem.setCount(1);
                SoulspringLampItem.addFuel(thisStack, singleFuelItem);
                fuelStack.shrink(1);
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ((SoulLampFuelledTrigger)((Object)ModAdvancementTriggers.SOUL_LAMP_FUELED.value())).trigger(serverPlayer, fuelStack, thisStack);
            }
            return true;
        }
        return false;
    }
}

