/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.item;

import com.momosoftworks.coldsweat.core.init.ModBlocks;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class MinecartInsulationItem
extends Item {
    public MinecartInsulationItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        Minecart minecart;
        Entity entity2;
        Vec3 look;
        ItemStack itemStack = player.getItemInHand(hand);
        double reachDistance = player.getAttribute(Attributes.BLOCK_INTERACTION_RANGE).getValue();
        Vec3 eye = player.getEyePosition();
        EntityHitResult entityHitResult = ProjectileUtil.getEntityHitResult((Level)level, (Entity)player, (Vec3)eye, (Vec3)(look = eye.add(player.getLookAngle().scale(reachDistance))), (AABB)new AABB(eye, look).inflate(1.0), entity -> entity instanceof Minecart, (float)0.0f);
        if (entityHitResult != null && entityHitResult.getType() == HitResult.Type.ENTITY && (entity2 = entityHitResult.getEntity()) instanceof Minecart && (minecart = (Minecart)entity2).getDisplayBlockState().getBlock() != ModBlocks.MINECART_INSULATION.value()) {
            if (!player.isCreative()) {
                player.getMainHandItem().shrink(1);
            }
            player.swing(InteractionHand.MAIN_HAND, true);
            level.playSound(null, minecart.blockPosition(), (SoundEvent)SoundEvents.LLAMA_SWAG.value(), SoundSource.PLAYERS, 1.0f, (float)(Math.random() / 5.0 + 0.9));
            minecart.setDisplayBlockState(((Block)ModBlocks.MINECART_INSULATION.value()).defaultBlockState());
            minecart.setDisplayOffset(5);
            return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
        }
        return InteractionResultHolder.pass((Object)itemStack);
    }
}

