/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.item;

import com.momosoftworks.coldsweat.client.event.RegisterModels;
import com.momosoftworks.coldsweat.client.renderer.model.armor.GoatParkaModel;
import com.momosoftworks.coldsweat.core.init.ModItems;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

public class GoatArmorItem
extends ArmorItem {
    public GoatArmorItem(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(this){

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<?> playerModel) {
                RegisterModels.checkForInitModels();
                return switch (armorSlot) {
                    case EquipmentSlot.HEAD -> RegisterModels.GOAT_CAP_MODEL;
                    case EquipmentSlot.CHEST -> {
                        GoatParkaModel<?> model = RegisterModels.GOAT_PARKA_MODEL;
                        ModelPart fluff = model.body.getChild("fluff");
                        float headPitch = entityLiving.getViewXRot(Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true));
                        fluff.xRot = CSMath.toRadians(CSMath.clamp(headPitch, 0.0f, 60.0f)) / 2.0f;
                        fluff.x = fluff.zRot * 2.0f;
                        yield model;
                    }
                    case EquipmentSlot.LEGS -> RegisterModels.GOAT_PANTS_MODEL;
                    case EquipmentSlot.FEET -> RegisterModels.GOAT_BOOTS_MODEL;
                    default -> null;
                };
            }
        });
    }

    public boolean canWalkOnPowderedSnow(ItemStack stack, LivingEntity wearer) {
        return stack.is(ModItems.GOAT_FUR_BOOTS);
    }
}

