/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.event;

import com.momosoftworks.coldsweat.api.temperature.modifier.WaterTempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.DryingItemData;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.Collection;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber
public class PlayerDrying {
    @SubscribeEvent
    public static void onDryingItemUsed(PlayerInteractEvent.RightClickItem event) {
        ItemStack stack = event.getItemStack();
        Player player = event.getEntity();
        Collection dryingResults = ConfigSettings.DRYING_ITEMS.get().get((Object)stack.getItem());
        if (!player.level().isClientSide() && Temperature.hasModifier((LivingEntity)player, Temperature.Trait.WORLD, WaterTempModifier.class)) {
            for (DryingItemData dryingResult : dryingResults) {
                if (!dryingResult.test((Entity)player, stack)) continue;
                ItemStack newStack = dryingResult.result();
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                    if (!player.getInventory().add(newStack)) {
                        player.drop(newStack, false);
                    }
                }
                player.swing(event.getHand(), true);
                WorldHelper.playEntitySound(dryingResult.sound(), (Entity)player, SoundSource.PLAYERS, 1.0f, 1.0f);
                Temperature.removeModifiers((LivingEntity)player, Temperature.Trait.WORLD, mod -> mod instanceof WaterTempModifier);
                break;
            }
        }
    }
}

