/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.event;

import com.momosoftworks.coldsweat.api.temperature.effect.TempEffect;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffectType;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.common.capability.temperature.ITemperatureCap;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.ModEffects;
import com.momosoftworks.coldsweat.data.codec.configuration.TempEffectsData;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber
public class HandleTempEffects {
    @SubscribeEvent
    public static void addTempEffects(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (living.tickCount > 5 && living.tickCount % 20 == 0) {
                EntityTempManager.getTemperatureCap((Entity)living).ifPresent(cap -> {
                    TempEffectsData effectsData = ConfigHelper.getFirstOrNull(ConfigSettings.ENTITY_TEMP_EFFECTS, living.getType(), data -> data.test((Entity)living));
                    if (effectsData == null) {
                        return;
                    }
                    ArrayList addedEffects = new ArrayList();
                    effectsData.effects().forEach(holder -> {
                        TempEffectType effectType = holder.effect();
                        if (!cap.getTempEffects().containsKey(effectType)) {
                            cap.addTempEffect((TempEffect)effectType.create(effectType, living, holder.range()));
                        }
                        addedEffects.add(effectType);
                    });
                    cap.getTempEffects().keySet().stream().filter(type -> !addedEffects.contains(type)).forEach(cap::removeTempEffect);
                });
            }
        }
    }

    @SubscribeEvent
    public static void clearTempEffects(EntityLeaveLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            EntityTempManager.getTemperatureCap((Entity)living).ifPresent(ITemperatureCap::clearTempEffects);
        }
    }

    public static boolean isPlayerImmune(Player player) {
        return player == null || !player.isAlive() || EntityTempManager.isPeacefulMode((LivingEntity)player) || player.hasEffect(ModEffects.GRACE);
    }

    @EventBusSubscriber(value={Dist.CLIENT})
    public static class Client {
        public static double COLD_IMMUNITY = 0.0;
        public static double HOT_IMMUNITY = 0.0;

        @SubscribeEvent
        public static void onClientTick(ClientTickEvent.Post event) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (HandleTempEffects.isPlayerImmune((Player)player)) {
                return;
            }
            if (player.tickCount % 5 == 0) {
                COLD_IMMUNITY = player.hasEffect(ModEffects.ICE_RESISTANCE) && ConfigSettings.ICE_RESISTANCE_ENABLED.get() != false ? 1.0 : Temperature.get((LivingEntity)player, Temperature.Trait.COLD_RESISTANCE);
                HOT_IMMUNITY = player.hasEffect(MobEffects.FIRE_RESISTANCE) && ConfigSettings.FIRE_RESISTANCE_ENABLED.get() != false ? 1.0 : Temperature.get((LivingEntity)player, Temperature.Trait.HEAT_RESISTANCE);
            }
        }
    }
}

