/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.event;

import com.momosoftworks.coldsweat.ColdSweat;
import java.lang.reflect.Field;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;

@EventBusSubscriber
public class BoilerRecipeOverride {
    private static final Field SLOT_CRAFT_CONTAINER = ObfuscationReflectionHelper.findField(ResultSlot.class, (String)"craftSlots");

    @SubscribeEvent
    public static void onCraftingTableOpen(PlayerContainerEvent.Open event) {
        RecipeBookMenu crafting;
        AbstractContainerMenu abstractContainerMenu = event.getContainer();
        if (abstractContainerMenu instanceof RecipeBookMenu && (crafting = (RecipeBookMenu)abstractContainerMenu).getGridWidth() == 3 && crafting.getGridHeight() == 3) {
            final MinecraftServer server = event.getEntity().getServer();
            if (server == null) {
                return;
            }
            final RecipeHolder boilerRecipe = server.getRecipeManager().byKey(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"boiler")).orElse(null);
            if (boilerRecipe == null) {
                return;
            }
            crafting.addSlotListener(new ContainerListener(){

                public void slotChanged(AbstractContainerMenu sendingContainer, int slotId, ItemStack stack) {
                    Slot slot = sendingContainer.getSlot(slotId);
                    if (slot instanceof ResultSlot) {
                        CraftingContainer craftSlots;
                        ResultSlot resultSlot = (ResultSlot)slot;
                        if (crafting.recipeMatches(boilerRecipe) && (craftSlots = BoilerRecipeOverride.getCraftingContainer(resultSlot)) != null) {
                            slot.set(boilerRecipe.value().assemble((RecipeInput)craftSlots.asCraftInput(), (HolderLookup.Provider)server.registryAccess()));
                        }
                    }
                }

                public void dataChanged(AbstractContainerMenu pContainerMenu, int pDataSlotIndex, int pValue) {
                }
            });
        }
    }

    @Nullable
    private static CraftingContainer getCraftingContainer(ResultSlot slot) {
        try {
            return (CraftingContainer)SLOT_CRAFT_CONTAINER.get(slot);
        }
        catch (IllegalAccessException e) {
            ColdSweat.LOGGER.error("Failed to get crafting container from ResultSlot", (Throwable)e);
            return null;
        }
    }

    static {
        SLOT_CRAFT_CONTAINER.setAccessible(true);
    }
}

