/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.entity.goals;

import com.momosoftworks.coldsweat.common.entity.Chameleon;
import com.momosoftworks.coldsweat.common.entity.data.edible.ChameleonEdibles;
import com.momosoftworks.coldsweat.common.entity.data.edible.Edible;
import com.momosoftworks.coldsweat.common.entity.goals.LazyLookGoal;
import com.momosoftworks.coldsweat.core.event.TaskScheduler;
import com.momosoftworks.coldsweat.core.init.ModSounds;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EatObjectsGoal
extends Goal {
    List<EntityType<?>> wantedEntities;
    Chameleon entity;
    Entity target;
    boolean stoppedTasks;
    Vec3 lookPos = null;

    public EatObjectsGoal(Chameleon chameleon, List<EntityType<?>> wantedEntities) {
        this.wantedEntities = wantedEntities;
        this.entity = chameleon;
    }

    public boolean canContinueToUse() {
        return this.target != null && this.target.isAlive() && !this.target.isRemoved() || this.entity.getEatTimer() > 0.0f;
    }

    public boolean isInterruptable() {
        return false;
    }

    public void start() {
        List items = this.entity.level().getEntities((Entity)this.entity, new AABB(this.entity.blockPosition()).inflate(5.0));
        for (Entity ent : items) {
            ItemEntity itemEntity;
            if (ent instanceof ItemEntity && (itemEntity = (ItemEntity)ent).getOwner() != null && (this.entity.isPlayerTrusted(itemEntity.getOwner().getUUID()) || this.entity.isTamingItem(itemEntity.getItem()))) {
                ItemStack item = itemEntity.getItem();
                Optional<Edible> edible = ChameleonEdibles.getEdible(item);
                if (!edible.isPresent() || itemEntity.getPersistentData().contains("Recipient") && !itemEntity.getPersistentData().getUUID("Recipient").equals(this.entity.getUUID()) || (this.entity.getCooldown(edible.get()) > 0 || !edible.get().shouldEat(this.entity, itemEntity)) && !this.isBreedingItem(itemEntity.getItem())) continue;
                this.target = ent;
                this.lookPos = ent.position();
                break;
            }
            if (!this.wantedEntities.contains(ent.getType())) continue;
            this.target = ent;
            this.lookPos = ent.position();
            break;
        }
    }

    public void stop() {
        this.stoppedTasks = false;
        this.target = null;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        if ((this.target == null || this.target.isRemoved()) && this.entity.getEatTimer() <= 0.0f) {
            this.stop();
            return;
        }
        this.lookPos = this.target.position().add(this.target.getDeltaMovement());
        this.entity.getLookControl().setLookAt(this.lookPos);
        if (this.entity.getEatTimer() <= 0.0f) {
            PathNavigation navigator = this.entity.getNavigation();
            Path path = navigator.createPath(this.target, 0);
            if (path != null) {
                navigator.moveTo(path, 1.5);
            }
            if (Math.sqrt(this.entity.distanceToSqr(this.target)) < 1.5 && Math.abs(this.entity.getY() - this.target.getY()) < 1.0 && this.target.isAlive()) {
                navigator.stop();
                this.entity.getLookControl().setLookAt(this.lookPos);
                this.entity.eatAnimation();
                WorldHelper.playEntitySound((SoundEvent)ModSounds.CHAMELEON_TONGUE_OUT.value(), (Entity)this.entity, this.entity.getSoundSource(), 1.0f, (float)Math.random() * 0.2f + 0.9f);
                TaskScheduler.scheduleServer(() -> {
                    if (this.target != null && this.target.isAlive() && !this.target.isRemoved()) {
                        this.entity.onEatEntity(this.target);
                        this.target.remove(Entity.RemovalReason.KILLED);
                        Entity patt0$temp = this.target;
                        if (patt0$temp instanceof ItemEntity) {
                            ItemEntity item = (ItemEntity)patt0$temp;
                            this.entity.onItemPickup(item);
                            Entity thrower = item.getOwner();
                            if (thrower != null && item.getItem().getCount() > 0) {
                                ItemStack stack = item.getItem().copy();
                                stack.shrink(1);
                                if (!stack.isEmpty()) {
                                    ItemEntity remainingStack = WorldHelper.entityDropItem((Entity)this.entity, stack);
                                    remainingStack.setThrower(thrower);
                                    remainingStack.getPersistentData().putUUID("Recipient", this.entity.getUUID());
                                }
                            }
                        }
                        WorldHelper.playEntitySound((SoundEvent)ModSounds.CHAMELEON_TONGUE_IN.value(), (Entity)this.entity, this.entity.getSoundSource(), 1.0f, (float)Math.random() * 0.2f + 0.9f);
                    }
                }, this.entity.getEatAnimLength() / 2 + 2);
                TaskScheduler.scheduleServer(() -> this.target.setDeltaMovement(this.entity.position().subtract(this.target.position()).normalize().scale(0.75)), this.entity.getEatAnimLength() / 2);
            }
            for (WrappedGoal goal : this.entity.goalSelector.getAvailableGoals()) {
                Goal g = goal.getGoal();
                if (!(g instanceof TemptGoal) && !(g instanceof LookAtPlayerGoal) && !(g instanceof RandomLookAroundGoal) && !(g instanceof LazyLookGoal)) continue;
                if (g.isInterruptable()) {
                    this.stoppedTasks = true;
                    goal.stop();
                    continue;
                }
                this.stoppedTasks = false;
                break;
            }
        }
    }

    public boolean canUse() {
        return this.entity.getLastHurtByMob() == null;
    }

    private boolean isBreedingItem(ItemStack stack) {
        return this.entity.canFallInLove() && this.entity.isFood(stack);
    }
}

