/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.entity.data.edible;

import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.common.entity.Chameleon;
import com.momosoftworks.coldsweat.common.entity.data.edible.Edible;
import com.momosoftworks.coldsweat.core.event.TaskScheduler;
import com.momosoftworks.coldsweat.core.init.ModSounds;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public abstract class BiomeSearchingEdible
extends Edible {
    private final BiPredicate<Level, Holder<Biome>> biomePredicate;

    public BiomeSearchingEdible(BiPredicate<Level, Holder<Biome>> biomePredicate) {
        this.biomePredicate = biomePredicate;
    }

    @Override
    public Edible.Result onEaten(Chameleon entity, ItemEntity item) {
        if (!entity.level().isClientSide) {
            entity.setSearching(true);
            Thread searchThread = new Thread(null, () -> {
                Pair biomePair = ((ServerLevel)entity.level()).findClosestBiome3d(biome -> this.biomePredicate.test(entity.level(), (Holder<Biome>)biome), entity.blockPosition(), 2000, 32, 64);
                if (biomePair != null) {
                    TaskScheduler.scheduleServer(() -> {
                        entity.setTrackingPos((BlockPos)biomePair.getFirst());
                        WorldHelper.playEntitySound((SoundEvent)ModSounds.CHAMELEON_FIND.value(), (Entity)entity, entity.getSoundSource(), 1.2f, entity.getVoicePitch());
                        WorldHelper.spawnParticleBatch(entity.level(), (ParticleOptions)ParticleTypes.HAPPY_VILLAGER, entity.getX(), entity.getY() + (double)(entity.getBbHeight() / 2.0f), entity.getZ(), 1.0, 1.0, 1.0, 6.0, 0.01);
                        entity.setSearching(false);
                    }, (int)(Math.random() * 20.0 + 40.0));
                } else {
                    TaskScheduler.scheduleServer(() -> {
                        WorldHelper.spawnParticleBatch(entity.level(), (ParticleOptions)ParticleTypes.SMOKE, entity.getX(), entity.getY() + (double)(entity.getBbHeight() / 2.0f), entity.getZ(), 1.0, 1.0, 1.0, 6.0, 0.01);
                        entity.setSearching(false);
                    }, (int)(Math.random() * 20.0 + 40.0));
                }
            }, "(Cold Sweat) Chameleon search thread");
            searchThread.start();
        }
        return Edible.Result.FAIL;
    }

    @Override
    public boolean shouldEat(Chameleon entity, ItemEntity item) {
        return item.getOwner() != null && entity.isPlayerTrusted(item.getOwner().getUUID());
    }
}

