/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.capability.temperature;

import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.capability.temperature.AbstractTempCap;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.ModItems;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class PlayerTempCap
extends AbstractTempCap {
    public PlayerTempCap() {
    }

    public PlayerTempCap(LivingEntity entity) {
        super(entity);
    }

    @Override
    public void tickHurting(LivingEntity entity) {
        Player player;
        if (!(entity instanceof Player && (player = (Player)entity).isCreative() || entity.isSpectator())) {
            super.tickHurting(entity);
        }
    }

    @Override
    public void tick(LivingEntity entity) {
        super.tick(entity);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.tickCount % 20 == 0) {
                this.calculateHudVisibility(player);
            }
            if (player.isCreative()) {
                this.setTrait(Temperature.Trait.CORE, 0.0);
            }
        }
    }

    @Override
    public void tickDummy(LivingEntity entity) {
        super.tickDummy(entity);
    }

    public void calculateHudVisibility(Player player) {
        this.showWorldTemp = ConfigSettings.REQUIRE_THERMOMETER.get() == false || player.isCreative() || player.getInventory().items.stream().limit(9L).anyMatch(stack -> stack.getItem() == ModItems.THERMOMETER.value()) || player.getOffhandItem().getItem() == ModItems.THERMOMETER.value() || CompatManager.Curios.hasCurio(player, (Item)ModItems.THERMOMETER.value());
        this.showBodyTemp = !player.isCreative() && !player.isSpectator();
    }
}

