/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.capability.temperature;

import com.google.common.math.DoubleMath;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.event.common.temperautre.TemperatureChangedEvent;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffect;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffectType;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.common.capability.temperature.ITemperatureCap;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.advancement.trigger.TemperatureChangedTrigger;
import com.momosoftworks.coldsweat.core.init.ModAdvancementTriggers;
import com.momosoftworks.coldsweat.core.init.ModEffects;
import com.momosoftworks.coldsweat.data.codec.configuration.EntityClimateData;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModDamageSources;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.serialization.NBTHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;

public class AbstractTempCap
implements ITemperatureCap {
    boolean changed = true;
    int syncTimer = 0;
    Temperature.Units preferredUnits = Temperature.Units.F;
    private final Set<Attribute> persistentAttributes = new HashSet<Attribute>();
    private final EnumMap<Temperature.Trait, Double> traits = new EnumMap(Temperature.Trait.class);
    private final EnumMap<Temperature.Trait, List<TempModifier>> modifiers = new EnumMap(Temperature.Trait.class);
    private final EnumMap<Temperature.Trait, AttributeInstance> attributes = new EnumMap(Temperature.Trait.class);
    private final Map<AttributeInstance, Map<AttributeModifier.Operation, Set<AttributeModifier>>> attributeModifiers = new HashMap<AttributeInstance, Map<AttributeModifier.Operation, Set<AttributeModifier>>>();
    private final HashMap<TempEffectType<?>, TempEffect> tempEffects = new HashMap();
    public boolean showBodyTemp;
    public boolean showWorldTemp;

    public AbstractTempCap(LivingEntity entity) {
        this.deserializeNBT(entity.getPersistentData().getCompound("Temperature"));
    }

    public AbstractTempCap() {
    }

    @Override
    public double getTrait(Temperature.Trait trait) {
        if (trait == Temperature.Trait.BODY) {
            return this.getTrait(Temperature.Trait.CORE) + this.getTrait(Temperature.Trait.BASE);
        }
        if (!trait.isForTemperature()) {
            throw (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("Invalid temperature trait: " + String.valueOf((Object)trait)));
        }
        return this.traits.computeIfAbsent(trait, t -> 0.0);
    }

    @Override
    public EnumMap<Temperature.Trait, Double> getTraits() {
        return new EnumMap<Temperature.Trait, Double>(this.traits);
    }

    @Override
    public void setTrait(Temperature.Trait trait, double value) {
        if (!trait.isForTemperature()) {
            throw (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("Invalid temperature trait: " + String.valueOf((Object)trait)));
        }
        this.changed |= (switch (trait) {
            case Temperature.Trait.CORE -> {
                if ((int)value != (int)this.getTrait(Temperature.Trait.CORE)) {
                    yield true;
                }
                yield false;
            }
            case Temperature.Trait.BASE -> {
                if ((int)value != (int)this.getTrait(Temperature.Trait.BASE)) {
                    yield true;
                }
                yield false;
            }
            case Temperature.Trait.WORLD -> {
                if (Math.abs(value - this.getTrait(Temperature.Trait.WORLD)) >= 0.02) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        });
        this.traits.put(trait, value);
    }

    public void setTrait(Temperature.Trait trait, double value, LivingEntity entity) {
        double oldTemp = this.getTrait(trait);
        this.setTrait(trait, value);
        if (entity.tickCount > 5 && oldTemp != value && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ((TemperatureChangedTrigger)((Object)ModAdvancementTriggers.TEMPERATURE_CHANGED.value())).trigger(player, this.getTraits());
        }
    }

    @Override
    public void addModifier(TempModifier modifier, Temperature.Trait trait) {
        if (!trait.isForModifiers()) {
            throw (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("Invalid modifier trait: " + String.valueOf((Object)trait)));
        }
        this.getModifiers(trait).add(modifier);
    }

    @Override
    public EnumMap<Temperature.Trait, List<TempModifier>> getModifiers() {
        return this.modifiers;
    }

    @Override
    public List<TempModifier> getModifiers(Temperature.Trait trait) {
        if (!trait.isForModifiers()) {
            throw (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("Invalid modifier trait: " + String.valueOf((Object)trait)));
        }
        return this.modifiers.computeIfAbsent(trait, t -> new ArrayList());
    }

    @Override
    public boolean hasModifier(Temperature.Trait trait, Class<? extends TempModifier> mod) {
        return this.getModifiers(trait).stream().anyMatch(mod::isInstance);
    }

    @Override
    public void markPersistentAttribute(Attribute attribute) {
        this.persistentAttributes.add(attribute);
    }

    @Override
    public void clearPersistentAttribute(Attribute attribute) {
        this.persistentAttributes.remove(attribute);
    }

    @Override
    public Collection<Attribute> getPersistentAttributes() {
        return this.persistentAttributes;
    }

    @Override
    public void clearModifiers(Temperature.Trait trait) {
        this.getModifiers(trait).clear();
    }

    public boolean shouldShowBodyTemp() {
        return this.showBodyTemp;
    }

    public boolean showAdvancedWorldTemp() {
        return this.showWorldTemp;
    }

    private AttributeInstance getAttribute(LivingEntity entity, Temperature.Trait trait) {
        return this.attributes.computeIfAbsent(trait, t -> EntityTempManager.getAttribute(t, entity));
    }

    private Set<AttributeModifier> getAttributeModifiers(AttributeInstance attribute, AttributeModifier.Operation operation) {
        return attribute.getModifiers().stream().filter(mod -> mod.operation() == operation).collect(Collectors.toSet());
    }

    public HashMap<TempEffectType<?>, TempEffect> getTempEffects() {
        return this.tempEffects;
    }

    @Override
    public void addTempEffect(TempEffect effect) {
        if (!this.tempEffects.containsKey(effect.type())) {
            this.tempEffects.put(effect.type(), effect);
            if (FMLEnvironment.dist == Dist.CLIENT || !effect.isClient()) {
                NeoForge.EVENT_BUS.register((Object)effect);
            }
        }
    }

    @Override
    public void removeTempEffect(TempEffectType<?> effect) {
        this.tempEffects.computeIfPresent(effect, (type, e) -> {
            NeoForge.EVENT_BUS.unregister(e);
            return null;
        });
    }

    @Override
    public void clearTempEffects() {
        this.tempEffects.values().forEach(arg_0 -> ((IEventBus)NeoForge.EVENT_BUS).unregister(arg_0));
        this.tempEffects.clear();
    }

    @Override
    public void tickDummy(LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return;
        }
        Temperature.apply(0.0, entity, Temperature.Trait.WORLD, this.getModifiers(Temperature.Trait.WORLD));
        Temperature.apply(0.0, entity, Temperature.Trait.BASE, this.getModifiers(Temperature.Trait.WORLD));
        Temperature.apply(this.getTrait(Temperature.Trait.CORE), entity, Temperature.Trait.CORE, this.getModifiers(Temperature.Trait.CORE));
        Temperature.apply((double)ConfigSettings.MAX_TEMP.get(), entity, Temperature.Trait.BURNING_POINT, this.getModifiers(Temperature.Trait.BURNING_POINT));
        Temperature.apply((double)ConfigSettings.MIN_TEMP.get(), entity, Temperature.Trait.FREEZING_POINT, this.getModifiers(Temperature.Trait.FREEZING_POINT));
        Temperature.apply(0.0, entity, Temperature.Trait.COLD_DAMPENING, this.getModifiers(Temperature.Trait.COLD_DAMPENING));
        Temperature.apply(0.0, entity, Temperature.Trait.HEAT_DAMPENING, this.getModifiers(Temperature.Trait.HEAT_DAMPENING));
        Temperature.apply(0.0, entity, Temperature.Trait.COLD_RESISTANCE, this.getModifiers(Temperature.Trait.COLD_RESISTANCE));
        Temperature.apply(0.0, entity, Temperature.Trait.HEAT_RESISTANCE, this.getModifiers(Temperature.Trait.HEAT_RESISTANCE));
        Temperature.apply(0.0, entity, Temperature.Trait.RATE, this.getModifiers(Temperature.Trait.RATE));
    }

    @Override
    public void tick(LivingEntity entity) {
        double changeBy;
        Player player;
        boolean isFullyHeatDampened;
        double worldTemp = this.modifyFromAttribute(entity, Temperature.Trait.WORLD, 0.0);
        double baseTemp = this.modifyFromAttribute(entity, Temperature.Trait.BASE, 0.0);
        double coreTemp = Temperature.apply(this.getTrait(Temperature.Trait.CORE), entity, Temperature.Trait.CORE, this.getModifiers(Temperature.Trait.CORE));
        double maxTemp = this.modifyFromAttribute(entity, Temperature.Trait.BURNING_POINT, ConfigSettings.MAX_TEMP.get());
        double minTemp = this.modifyFromAttribute(entity, Temperature.Trait.FREEZING_POINT, ConfigSettings.MIN_TEMP.get());
        double coldDampening = this.modifyFromAttribute(entity, Temperature.Trait.COLD_DAMPENING, 0.0);
        double heatDampening = this.modifyFromAttribute(entity, Temperature.Trait.HEAT_DAMPENING, 0.0);
        double coldResistance = this.modifyFromAttribute(entity, Temperature.Trait.COLD_RESISTANCE, 0.0);
        double heatResistance = this.modifyFromAttribute(entity, Temperature.Trait.HEAT_RESISTANCE, 0.0);
        double rate = 0.0;
        int worldTempSign = CSMath.getSignForRange(worldTemp, minTemp, maxTemp);
        boolean immuneToTemp = EntityTempManager.isPeacefulMode(entity);
        boolean isFullyColdDampened = worldTempSign < 0 && (coldDampening >= 1.0 || immuneToTemp);
        boolean bl = isFullyHeatDampened = worldTempSign > 0 && (heatDampening >= 1.0 || immuneToTemp);
        if (!(worldTempSign == 0 || entity instanceof Player && (player = (Player)entity).isCreative() || entity.isSpectator() || EntityTempManager.isPeacefulMode(entity))) {
            double difference = Math.abs(worldTemp - CSMath.clamp(worldTemp, minTemp, maxTemp));
            changeBy = Math.max(difference / 7.0 * ConfigSettings.TEMP_RATE.get(), Math.abs(ConfigSettings.TEMP_RATE.get() / 50.0)) * (double)worldTempSign;
            if (changeBy < 0.0) {
                changeBy = coldDampening < 0.0 ? changeBy * (1.0 + Math.abs(coldDampening)) : CSMath.blend(changeBy, 0.0, coldDampening, 0.0, 1.0);
            } else if (changeBy > 0.0) {
                changeBy = heatDampening < 0.0 ? changeBy * (1.0 + Math.abs(heatDampening)) : CSMath.blend(changeBy, 0.0, heatDampening, 0.0, 1.0);
            }
            rate = this.modifyFromAttribute(entity, Temperature.Trait.RATE, changeBy);
            coreTemp += (rate *= CSMath.getIfNotNull(ConfigHelper.getFirstOrNull(ConfigSettings.ENTITY_CLIMATES, entity.getType(), data -> data.test((Entity)entity)), EntityClimateData::rate, 0.25) * 4.0);
        }
        int coreTempSign = CSMath.sign(coreTemp);
        double amount = 0.0;
        if (isFullyColdDampened && coreTempSign < 0) {
            amount = ConfigSettings.TEMP_RATE.get() / 10.0;
        } else if (isFullyHeatDampened && coreTempSign > 0) {
            amount = ConfigSettings.TEMP_RATE.get() / -10.0;
        } else if (coreTempSign != 0 && coreTempSign != worldTempSign) {
            amount = (coreTempSign == 1 ? worldTemp - maxTemp : worldTemp - minTemp) / 3.0;
        }
        if (amount != 0.0) {
            changeBy = CSMath.maxAbs(amount * ConfigSettings.TEMP_RATE.get(), ConfigSettings.TEMP_RATE.get() / 10.0 * (double)(-coreTempSign));
            coreTemp += CSMath.minAbs(changeBy, -this.getTrait(Temperature.Trait.CORE));
        }
        this.setTrait(Temperature.Trait.CORE, CSMath.clamp(coreTemp, -150.0, 150.0), entity);
        this.setTrait(Temperature.Trait.BASE, CSMath.clamp(baseTemp, -150.0, 150.0), entity);
        this.setTrait(Temperature.Trait.WORLD, worldTemp, entity);
        this.setTrait(Temperature.Trait.BURNING_POINT, maxTemp);
        this.setTrait(Temperature.Trait.FREEZING_POINT, minTemp);
        this.setTrait(Temperature.Trait.COLD_RESISTANCE, coldResistance);
        this.setTrait(Temperature.Trait.HEAT_RESISTANCE, heatResistance);
        this.setTrait(Temperature.Trait.COLD_DAMPENING, coldDampening);
        this.setTrait(Temperature.Trait.HEAT_DAMPENING, heatDampening);
        this.setTrait(Temperature.Trait.RATE, rate);
        if (this.syncTimer > 0) {
            --this.syncTimer;
        }
        if (this.changed && this.syncTimer <= 0) {
            this.syncValues(entity);
        }
        this.tickHurting(entity);
    }

    private double modifyFromAttribute(LivingEntity entity, Temperature.Trait trait, double baseValue) {
        double newValue;
        Supplier<Double> defaultSupplier = () -> Temperature.apply(baseValue, entity, trait, this.getModifiers(trait));
        AttributeInstance attribute = this.getAttribute(entity, trait);
        if (attribute == null) {
            newValue = defaultSupplier.get();
        } else {
            double base = CSMath.safeDouble(attribute.getBaseValue()).orElseGet(defaultSupplier);
            if (this.modifiers.isEmpty()) {
                newValue = base;
            } else {
                for (AttributeModifier mod : this.getAttributeModifiers(attribute, AttributeModifier.Operation.ADD_VALUE)) {
                    base += mod.amount();
                }
                double value = base;
                for (AttributeModifier mod : this.getAttributeModifiers(attribute, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)) {
                    value += base * mod.amount();
                }
                for (AttributeModifier mod : this.getAttributeModifiers(attribute, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)) {
                    value *= 1.0 + mod.amount();
                }
                newValue = value;
            }
        }
        if (!DoubleMath.fuzzyEquals((double)newValue, (double)this.getTrait(trait), (double)0.001)) {
            NeoForge.EVENT_BUS.post((Event)new TemperatureChangedEvent(entity, trait, this.getTrait(trait), newValue));
            NBTHelper.getOrPutTag(entity, "Temperature", new CompoundTag()).putDouble(trait.getSerializedName(), newValue);
        }
        return newValue;
    }

    @Override
    public void syncValues(LivingEntity entity) {
        Temperature.updateTemperature(entity, this, false);
        this.changed = false;
        this.syncTimer = 5;
    }

    public int getHurtInterval(LivingEntity entity) {
        return 40;
    }

    public void tickHurting(LivingEntity entity) {
        if (EntityTempManager.isPeacefulMode(entity)) {
            return;
        }
        double bodyTemp = this.getTrait(Temperature.Trait.BODY);
        double heatResistance = this.getTrait(Temperature.Trait.HEAT_RESISTANCE);
        double coldResistance = this.getTrait(Temperature.Trait.COLD_RESISTANCE);
        double damage = ConfigSettings.TEMP_DAMAGE.get();
        double rate = this.getTrait(Temperature.Trait.RATE);
        int hurtInterval = this.getHurtInterval(entity);
        if (hurtInterval < 1) {
            return;
        }
        boolean hasGrace = entity.hasEffect(ModEffects.GRACE);
        boolean hasFireResist = entity.hasEffect(MobEffects.FIRE_RESISTANCE);
        boolean hasIceResist = entity.hasEffect(ModEffects.ICE_RESISTANCE);
        double rateFactor = CSMath.sign(bodyTemp) == CSMath.sign(rate) ? Math.abs(rate) : 0.0;
        int rateInterval = (int)CSMath.blend(1.0, 4.0, rateFactor, 0.0, 0.7);
        if (!hasGrace && entity.tickCount % (hurtInterval / rateInterval) == 0) {
            Registry damageTypes = entity.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE);
            if (!(!(bodyTemp >= 100.0) || hasFireResist && ConfigSettings.FIRE_RESISTANCE_ENABLED.get().booleanValue())) {
                DamageSource hot = new DamageSource((Holder)damageTypes.getHolderOrThrow(ModDamageSources.HOT));
                entity.hurt(hot, (float)CSMath.blend(damage, 0.0, heatResistance, 0.0, 1.0));
            } else if (!(!(bodyTemp <= -100.0) || hasIceResist && ConfigSettings.ICE_RESISTANCE_ENABLED.get().booleanValue())) {
                DamageSource cold = new DamageSource((Holder)damageTypes.getHolderOrThrow(ModDamageSources.COLD));
                entity.hurt(cold, (float)CSMath.blend(damage, 0.0, coldResistance, 0.0, 1.0));
            }
        }
    }

    @Override
    public void copy(ITemperatureCap cap) {
        for (Temperature.Trait trait : EntityTempManager.VALID_TEMPERATURE_TRAITS) {
            this.setTrait(trait, cap.getTrait(trait));
        }
        for (Temperature.Trait trait : EntityTempManager.VALID_MODIFIER_TRAITS) {
            this.getModifiers(trait).clear();
            this.getModifiers(trait).addAll(cap.getModifiers(trait));
        }
        this.persistentAttributes.clear();
        this.persistentAttributes.addAll(cap.getPersistentAttributes());
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.put("Traits", (Tag)this.serializeTraits());
        nbt.put("TempModifiers", (Tag)this.serializeModifiers());
        ListTag attributes = new ListTag();
        for (Attribute attribute : this.getPersistentAttributes()) {
            attributes.add((Object)StringTag.valueOf((String)BuiltInRegistries.ATTRIBUTE.getKey((Object)attribute).toString()));
        }
        nbt.put("PersistentAttributes", (Tag)attributes);
        return nbt;
    }

    @Override
    public CompoundTag serializeTraits() {
        CompoundTag nbt = new CompoundTag();
        for (Map.Entry<Temperature.Trait, Double> trait : this.traits.entrySet()) {
            nbt.putDouble(NBTHelper.getTraitTagKey(trait.getKey()), trait.getValue().doubleValue());
        }
        return nbt;
    }

    @Override
    public CompoundTag serializeModifiers() {
        CompoundTag nbt = new CompoundTag();
        for (Temperature.Trait trait : EntityTempManager.VALID_MODIFIER_TRAITS) {
            ListTag modifiers = new ListTag();
            for (TempModifier modifier : this.getModifiers(trait)) {
                modifiers.add((Object)NBTHelper.modifierToTag(modifier));
            }
            nbt.put(NBTHelper.getTraitTagKey(trait), (Tag)modifiers);
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.deserializeTraits(nbt.getCompound("Traits"));
        this.deserializeModifiers(nbt.getCompound("TempModifiers"));
        ListTag attributes = nbt.getList("PersistentAttributes", 8);
        for (int i = 0; i < attributes.size(); ++i) {
            this.markPersistentAttribute((Attribute)BuiltInRegistries.ATTRIBUTE.get(ResourceLocation.parse((String)attributes.getString(i))));
        }
    }

    @Override
    public void deserializeTraits(CompoundTag nbt) {
        for (Temperature.Trait trait : EntityTempManager.VALID_TEMPERATURE_TRAITS) {
            this.setTrait(trait, nbt.getDouble(NBTHelper.getTraitTagKey(trait)));
        }
    }

    @Override
    public void deserializeModifiers(CompoundTag nbt) {
        EnumMap modifiers = new EnumMap(Temperature.Trait.class);
        HashMap modifierHashes = new HashMap();
        for (Temperature.Trait trait : EntityTempManager.VALID_MODIFIER_TRAITS) {
            ListTag modTags = nbt.getList(NBTHelper.getTraitTagKey(trait), 10);
            modTags.forEach(entry -> {
                CompoundTag modNBT = (CompoundTag)entry;
                Optional modOpt = modNBT.contains("Hash") ? modifierHashes.computeIfAbsent(modNBT.getInt("Hash"), hash -> NBTHelper.tagToModifier(modNBT)) : NBTHelper.tagToModifier(modNBT);
                modOpt.ifPresent(modifier -> modifiers.computeIfAbsent(trait, t -> new ArrayList()).add(modifier));
            });
        }
        this.modifiers.clear();
        this.modifiers.putAll(modifiers);
    }
}

