/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.capability.handler;

import com.momosoftworks.coldsweat.common.capability.ModCapabilities;
import com.momosoftworks.coldsweat.common.capability.shearing.IShearableCap;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.event.TaskScheduler;
import com.momosoftworks.coldsweat.core.network.message.SyncShearableDataMessage;
import com.momosoftworks.coldsweat.data.codec.configuration.EntityDropData;
import com.momosoftworks.coldsweat.data.loot.ModLootTables;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber
public class ShearableFurManager {
    public static final Map<Entity, IShearableCap> CAP_CACHE = new HashMap<Entity, IShearableCap>();

    public static boolean isShearable(Entity entity) {
        return entity instanceof Goat;
    }

    public static Optional<IShearableCap> getFurCap(Entity entity) {
        return ShearableFurManager.isShearable(entity) ? Optional.ofNullable(CAP_CACHE.computeIfAbsent(entity, e -> (IShearableCap)e.getCapability(ModCapabilities.SHEARABLE_FUR))) : Optional.empty();
    }

    @SubscribeEvent
    public static void cleanRemovedEntities(EntityLeaveLevelEvent event) {
        if (ShearableFurManager.isShearable(event.getEntity())) {
            CAP_CACHE.entrySet().removeIf(e -> ((Entity)e.getKey()).isRemoved());
            ShearableFurManager.writeData(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onShearGoat(PlayerInteractEvent.EntityInteract event) {
        AgeableMob ageable;
        LivingEntity living;
        Entity entity = event.getTarget();
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        if (!(!(entity instanceof LivingEntity) || (living = (LivingEntity)entity) instanceof AgeableMob && (ageable = (AgeableMob)living).isBaby() || entity.level().isClientSide || !stack.is(Tags.Items.TOOLS_SHEAR))) {
            IShearableCap cap = ShearableFurManager.getFurCap((Entity)living).orElse(null);
            if (cap == null) {
                return;
            }
            if (cap.isSheared()) {
                event.setCancellationResult(InteractionResult.PASS);
                return;
            }
            player.swing(event.getHand(), true);
            stack.hurtAndBreak(1, (ServerLevel)event.getEntity().level(), (LivingEntity)event.getEntity(), item -> {});
            ShearableFurManager.shear(living, stack, player);
            if (living instanceof Goat) {
                Goat goat = (Goat)living;
                if (!player.getAbilities().instabuild && goat.level().getDifficulty() != Difficulty.PEACEFUL && !goat.level().isClientSide && goat.getRandom().nextDouble() < 0.4) {
                    goat.getBrain().setMemory(MemoryModuleType.RAM_COOLDOWN_TICKS, (Object)30);
                    for (WrappedGoal goal : goat.goalSelector.getAvailableGoals()) {
                        if (!goal.isInterruptable()) continue;
                        goal.stop();
                    }
                    TaskScheduler.scheduleServer(() -> {
                        ClientboundEntityEventPacket packet = new ClientboundEntityEventPacket((Entity)goat, 58);
                        ((ServerChunkCache)goat.level().getChunkSource()).broadcastAndSend((Entity)goat, (Packet)packet);
                    }, 5);
                    BehaviorUtils.lookAtEntity((LivingEntity)goat, (LivingEntity)player);
                    goat.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
                    goat.getBrain().setMemory(MemoryModuleType.RAM_TARGET, (Object)player.position());
                    TaskScheduler.scheduleServer(() -> {
                        if (player.distanceTo((Entity)goat) <= 10.0f) {
                            goat.playSound(goat.isScreamingGoat() ? SoundEvents.GOAT_SCREAMING_PREPARE_RAM : SoundEvents.GOAT_PREPARE_RAM, 1.0f, 1.0f);
                            goat.getBrain().setMemory(MemoryModuleType.RAM_TARGET, (Object)player.position());
                        }
                    }, 30);
                    goat.getBrain().setActiveActivityIfPossible(Activity.RAM);
                }
            }
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    @SubscribeEvent
    public static void onGoatTick(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        Optional<IShearableCap> icap = ShearableFurManager.getFurCap(entity);
        icap.ifPresent(cap -> {
            EntityDropData furConfig = ConfigSettings.FUR_TIMINGS.get();
            if (cap.furGrowthCooldown() > 0) {
                cap.setFurGrowthCooldown(Math.min(cap.furGrowthCooldown() - 1, furConfig.cooldown()));
            }
            cap.setAge(cap.age() + 1);
            if (!entity.level().isClientSide && cap.isSheared() && cap.age() % Math.max(1, furConfig.interval()) == 0 && cap.furGrowthCooldown() == 0 && entity.getRandom().nextDouble() < furConfig.chance()) {
                WorldHelper.playEntitySound(SoundEvents.WOOL_HIT, entity, entity.getSoundSource(), 0.5f, 0.6f);
                WorldHelper.playEntitySound((SoundEvent)SoundEvents.LLAMA_SWAG.value(), entity, entity.getSoundSource(), 0.5f, 0.8f);
                WorldHelper.spawnParticleBatch(entity.level(), (ParticleOptions)ParticleTypes.SPIT, entity.getX(), entity.getY() + (double)(entity.getBbHeight() / 2.0f), entity.getZ(), 0.5, 0.5, 0.5, 10.0, 0.05f);
                cap.setSheared(false);
                ShearableFurManager.syncData(living, null);
            }
        });
    }

    @SubscribeEvent
    public static void onEntityLoaded(PlayerEvent.StartTracking event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (ShearableFurManager.getFurCap(event.getTarget()).isPresent()) {
                ShearableFurManager.syncData((LivingEntity)event.getTarget(), player2);
            }
        }
    }

    public static void shear(LivingEntity entity, ItemStack shears, @Nullable Player player) {
        ShearableFurManager.getFurCap((Entity)entity).ifPresent(cap -> {
            if (!cap.isSheared() && !entity.level().isClientSide()) {
                cap.setSheared(true);
                cap.setFurGrowthCooldown(ConfigSettings.FUR_TIMINGS.get().cooldown());
                for (ItemStack item2 : ModLootTables.getEntityDropsLootTable((Entity)entity, player, ModLootTables.GOAT_SHEARING)) {
                    WorldHelper.entityDropItem((Entity)entity, item2);
                }
                entity.level().playSound(null, (Entity)entity, SoundEvents.SHEEP_SHEAR, SoundSource.NEUTRAL, 1.0f, 1.0f);
                if (player == null || !player.getAbilities().instabuild) {
                    shears.hurtAndBreak(1, (ServerLevel)entity.level(), entity, item -> {});
                }
                ShearableFurManager.syncData(entity, null);
            }
        });
    }

    public static void syncData(LivingEntity entity, ServerPlayer player) {
        if (!entity.level().isClientSide) {
            ShearableFurManager.getFurCap((Entity)entity).ifPresent(cap -> {
                if (player != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncShearableDataMessage(entity.getId(), cap.serializeNBT()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                } else {
                    PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)new SyncShearableDataMessage(entity.getId(), cap.serializeNBT()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                ShearableFurManager.writeData((Entity)entity);
            });
        }
    }

    public static void writeData(Entity entity) {
        ShearableFurManager.getFurCap(entity).ifPresent(cap -> entity.getPersistentData().put("FurData", (Tag)cap.serializeNBT()));
    }
}

