/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.blockentity;

import com.momosoftworks.coldsweat.common.block.ThermolithBlock;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.ModBlockEntities;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ThermolithBlockEntity
extends BlockEntity {
    private int signal = 0;

    public ThermolithBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.THERMOLITH.get(), pos, state);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T te) {
        if (te instanceof ThermolithBlockEntity) {
            ThermolithBlockEntity thermoTE = (ThermolithBlockEntity)te;
            thermoTE.tick(level, state, pos);
        }
    }

    public void tick(Level level, BlockState state, BlockPos pos) {
        if (level.getGameTime() % 20L == 0L && !level.isClientSide) {
            double temperature = WorldHelper.getTemperatureAt(level, pos);
            int newSignal = (int)CSMath.blend(0.0, 15.0, temperature, ConfigSettings.MIN_TEMP.get(), ConfigSettings.MAX_TEMP.get());
            if (newSignal != this.signal) {
                this.signal = newSignal;
                ThermolithBlock.updateFacingNeighbors(level, state, pos);
            }
            if (this.signal == 0) {
                if (((Boolean)state.getValue((Property)ThermolithBlock.POWERED)).booleanValue()) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ThermolithBlock.POWERED, (Comparable)Boolean.valueOf(false)));
                }
            } else if (!((Boolean)state.getValue((Property)ThermolithBlock.POWERED)).booleanValue()) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ThermolithBlock.POWERED, (Comparable)Boolean.valueOf(true)));
            }
        }
    }

    public int getSignal() {
        return this.signal;
    }
}

