/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.block;

import com.momosoftworks.coldsweat.data.tag.ModBlockTags;
import com.momosoftworks.coldsweat.data.tag.ModItemTags;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SmokestackBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<Facing> FACING = EnumProperty.create((String)"facing", Facing.class);
    public static final BooleanProperty END = BooleanProperty.create((String)"end");
    public static final BooleanProperty BASE = BooleanProperty.create((String)"base");
    public static final BooleanProperty ENCASED = BooleanProperty.create((String)"encased");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public SmokestackBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)((Object)Facing.UP))).setValue((Property)END, (Comparable)Boolean.valueOf(false))).setValue((Property)BASE, (Comparable)Boolean.valueOf(false))).setValue((Property)ENCASED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public static BlockBehaviour.Properties getProperties() {
        return BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(2.0f).explosionResistance(10.0f).requiresCorrectToolForDrops();
    }

    public static Item.Properties getItemProperties() {
        return new Item.Properties();
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        if (!player.isCrouching() && stack.is(ModItemTags.ENCASES_SMOKESTACK) && !((Boolean)state.getValue((Property)ENCASED)).booleanValue() && state.getValue(FACING) != Facing.BEND) {
            level.setBlock(pos, (BlockState)((BlockState)((BlockState)state.setValue((Property)ENCASED, (Comparable)Boolean.valueOf(true))).setValue((Property)END, (Comparable)Boolean.valueOf(false))).setValue((Property)BASE, (Comparable)Boolean.valueOf(false)), 3);
            player.swing(hand, true);
            level.playSound(null, pos, this.getSoundType(state, (LevelReader)level, pos, (Entity)player).getPlaceSound(), SoundSource.BLOCKS, 1.0f, 0.8f);
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            return ItemInteractionResult.CONSUME;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, rayTraceResult);
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.getValue((Property)ENCASED) == false && state.getValue(FACING) != Facing.BEND;
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        return (Boolean)state.getValue((Property)ENCASED) != false || state.getValue(FACING) == Facing.BEND;
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.getValue((Property)ENCASED)).booleanValue()) {
            return Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        }
        return switch (((Facing)((Object)state.getValue(FACING))).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1 -> Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
            case 2, 3 -> Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0);
            case 4, 5 -> Block.box((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
            case 6 -> Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        };
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(FACING, (Comparable)((Object)((Facing)((Object)state.getValue(FACING))).rotate(rotation)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue(FACING, (Comparable)((Object)((Facing)((Object)state.getValue(FACING))).mirror(mirror)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, END, BASE, ENCASED, WATERLOGGED});
    }

    protected Facing calculateFacing(Facing facing, BlockPos pos, LevelAccessor level) {
        Direction newDir = null;
        for (Direction dir : Direction.values()) {
            BlockState neighborState = level.getBlockState(pos.relative(dir));
            if (!neighborState.is(ModBlockTags.CONNECTS_SMOKESTACK) && (dir != Direction.DOWN || !neighborState.is(ModBlockTags.THERMAL_SOURCE))) continue;
            if (newDir != null && newDir.getAxis() != dir.getAxis()) {
                return Facing.BEND;
            }
            newDir = dir;
        }
        if (newDir != null) {
            if (newDir.getAxis() == facing.getAxis()) {
                return facing;
            }
            BlockState neighbor = level.getBlockState(pos.relative(newDir));
            if (neighbor.getBlock() instanceof SmokestackBlock) {
                Facing neighborFacing = (Facing)((Object)neighbor.getValue(FACING));
                return neighborFacing == Facing.BEND ? (facing.getAxis() != newDir.getAxis() ? Facing.fromDirection(newDir.getOpposite()) : facing) : (neighborFacing.getAxis() != newDir.getAxis() ? Facing.fromDirection(newDir.getOpposite()) : neighborFacing);
            }
            return Facing.fromDirection(newDir.getOpposite());
        }
        return facing;
    }

    protected BlockState calculateConnections(BlockState state, BlockPos pos, LevelAccessor level) {
        Facing facing = (Facing)((Object)state.getValue(FACING));
        if (facing == Facing.BEND) {
            return (BlockState)((BlockState)state.setValue((Property)END, (Comparable)Boolean.valueOf(false))).setValue((Property)BASE, (Comparable)Boolean.valueOf(false));
        }
        boolean connectedTop = level.getBlockState(pos.relative(facing.toDirection())).is(ModBlockTags.CONNECTS_SMOKESTACK);
        boolean connectedBase = level.getBlockState(pos.relative(facing.toDirection().getOpposite())).is(ModBlockTags.CONNECTS_SMOKESTACK);
        return (BlockState)((BlockState)state.setValue((Property)END, (Comparable)Boolean.valueOf(connectedTop))).setValue((Property)BASE, (Comparable)Boolean.valueOf(connectedBase));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction placeDir = context.getClickedFace();
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        Facing facing = Facing.fromDirection(placeDir);
        facing = this.calculateFacing(facing, pos, (LevelAccessor)level);
        BlockState state = (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)((Object)facing));
        if (facing != Facing.BEND) {
            state = this.calculateConnections(state, pos, (LevelAccessor)level);
        }
        state = WorldHelper.waterlog(state, level, pos);
        return state;
    }

    protected BlockState updateFluid(LevelAccessor level, BlockState state, BlockPos pos) {
        if (state.getValue(FACING) == Facing.BEND || ((Boolean)state.getValue((Property)ENCASED)).booleanValue()) {
            return (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return state;
    }

    public BlockState updateShape(BlockState state, Direction neighborDir, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        state = this.updateFluid(level, state, pos);
        Facing facing = this.calculateFacing((Facing)((Object)state.getValue(FACING)), pos, level);
        state = (BlockState)state.setValue(FACING, (Comparable)((Object)facing));
        state = this.calculateConnections(state, pos, level);
        return state;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter ilevel, BlockPos pos) {
        float progress = super.getDestroyProgress(state, player, ilevel, pos);
        if (((Boolean)state.getValue((Property)ENCASED)).booleanValue()) {
            progress *= 2.0f;
        }
        return progress;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (((Boolean)state.getValue((Property)ENCASED)).booleanValue()) {
            state = this.updateFluid((LevelAccessor)level, state, pos);
            level.setBlock(pos, (BlockState)this.calculateConnections(state, pos, (LevelAccessor)level).setValue((Property)ENCASED, (Comparable)Boolean.valueOf(false)), 3);
            level.addDestroyBlockEffect(pos, state);
            level.playSound(null, pos, this.getSoundType(state, (LevelReader)level, pos, (Entity)player).getBreakSound(), SoundSource.BLOCKS, 1.0f, 0.8f);
            return false;
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public static enum Facing implements StringRepresentable
    {
        UP("up"),
        DOWN("down"),
        NORTH("north"),
        SOUTH("south"),
        EAST("east"),
        WEST("west"),
        BEND("bend");

        private final String name;

        private Facing(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public static Facing byName(String name) {
            for (Facing facing : Facing.values()) {
                if (!facing.name.equals(name)) continue;
                return facing;
            }
            return UP;
        }

        public static Facing fromDirection(Direction direction) {
            return switch (direction) {
                case Direction.DOWN -> DOWN;
                case Direction.NORTH -> NORTH;
                case Direction.SOUTH -> SOUTH;
                case Direction.EAST -> EAST;
                case Direction.WEST -> WEST;
                default -> UP;
            };
        }

        public Direction toDirection() {
            return switch (this.ordinal()) {
                case 1 -> Direction.DOWN;
                case 2 -> Direction.NORTH;
                case 3 -> Direction.SOUTH;
                case 4 -> Direction.EAST;
                case 5 -> Direction.WEST;
                default -> Direction.UP;
            };
        }

        @Nullable
        public Direction.Axis getAxis() {
            return this == BEND ? null : this.toDirection().getAxis();
        }

        public Facing rotate(Rotation rotation) {
            return switch (rotation) {
                case Rotation.CLOCKWISE_90 -> {
                    switch (this.ordinal()) {
                        case 2: {
                            yield EAST;
                        }
                        case 4: {
                            yield SOUTH;
                        }
                        case 3: {
                            yield WEST;
                        }
                        case 5: {
                            yield NORTH;
                        }
                    }
                    yield this;
                }
                case Rotation.CLOCKWISE_180 -> {
                    switch (this.ordinal()) {
                        case 2: {
                            yield SOUTH;
                        }
                        case 3: {
                            yield NORTH;
                        }
                        case 4: {
                            yield WEST;
                        }
                        case 5: {
                            yield EAST;
                        }
                    }
                    yield this;
                }
                case Rotation.COUNTERCLOCKWISE_90 -> {
                    switch (this.ordinal()) {
                        case 2: {
                            yield WEST;
                        }
                        case 5: {
                            yield SOUTH;
                        }
                        case 3: {
                            yield EAST;
                        }
                        case 4: {
                            yield NORTH;
                        }
                    }
                    yield this;
                }
                default -> this;
            };
        }

        public Facing mirror(Mirror mirror) {
            return switch (mirror) {
                case Mirror.FRONT_BACK -> {
                    switch (this.ordinal()) {
                        case 2: {
                            yield SOUTH;
                        }
                        case 3: {
                            yield NORTH;
                        }
                    }
                    yield this;
                }
                case Mirror.LEFT_RIGHT -> {
                    switch (this.ordinal()) {
                        case 4: {
                            yield WEST;
                        }
                        case 5: {
                            yield EAST;
                        }
                    }
                    yield this;
                }
                default -> this;
            };
        }
    }
}

