/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.gui.tooltip;

import com.momosoftworks.coldsweat.config.ConfigSettings;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientInsulationAttributeTooltip
implements ClientTooltipComponent {
    public static final ResourceLocation TOOLTIP = ResourceLocation.parse((String)"cold_sweat:textures/gui/tooltip/insulation_bar.png");
    public static final ResourceLocation TOOLTIP_HC = ResourceLocation.parse((String)"cold_sweat:textures/gui/tooltip/insulation_bar_hc.png");
    public static final Supplier<ResourceLocation> TOOLTIP_LOCATION = () -> ConfigSettings.HIGH_CONTRAST.get() != false ? TOOLTIP_HC : TOOLTIP;
    Component original;
    Font font;
    boolean strikethrough;

    public ClientInsulationAttributeTooltip(Component original, Font font, boolean strikethrough) {
        this.original = original;
        this.font = font;
        this.strikethrough = strikethrough;
    }

    public int getHeight() {
        Objects.requireNonNull(this.font);
        return 9 + 2;
    }

    public int getWidth(Font font) {
        return this.font.width((FormattedText)this.original) + 10;
    }

    public void renderImage(Font font, int x, int y, GuiGraphics graphics) {
        graphics.blit(TOOLTIP_LOCATION.get(), x, y, 0, 28.0f, 8.0f, 8, 8, 36, 28);
        int color = Optional.ofNullable(this.original.getStyle().getColor()).map(TextColor::getValue).orElse(0xFFFFFF);
        int xOffs = this.strikethrough ? 12 : 10;
        graphics.drawString(font, this.original, x + xOffs, y + 1, color);
        if (this.strikethrough) {
            graphics.fill(x - 2, y + 4, x + 9, y + 5, 401, -642510);
            graphics.fill(x - 1, y + 5, x + 10, y + 6, 401, -642510);
        }
    }
}

