/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.gui.config;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class ConfigLabel
extends AbstractWidget
implements GuiEventListener,
NarratableEntry {
    public final String id;
    private int color;

    public ConfigLabel(String id, String text, int x, int y) {
        this(id, text, x, y, 0xFFFFFF);
    }

    public ConfigLabel(String id, String text, int x, int y, int color) {
        int n = Minecraft.getInstance().font.width(text);
        Objects.requireNonNull(Minecraft.getInstance().font);
        super(x, y, n, 9, (Component)Component.translatable((String)text));
        this.id = id;
        this.setX(x);
        this.setY(y);
        this.color = color;
    }

    public void setTextColor(int color) {
        this.color = color;
    }

    protected void renderWidget(GuiGraphics graphics, int pmousex, int mouseY, float partialTick) {
        graphics.drawString(Minecraft.getInstance().font, this.getMessage(), this.getX(), this.getY(), this.color, true);
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        return NarratableEntry.NarrationPriority.HOVERED;
    }

    public void updateWidgetNarration(NarrationElementOutput narration) {
        narration.add(NarratedElementType.HINT, this.getMessage());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isMouseOver(double mouseX, double mouseY) {
        if (!(mouseX >= (double)(this.getX() - 5))) return false;
        if (!(mouseY >= (double)(this.getY() - 5))) return false;
        if (!(mouseX < (double)(this.getX() + Minecraft.getInstance().font.width((FormattedText)this.getMessage()) + 5))) return false;
        int n = this.getY();
        Objects.requireNonNull(Minecraft.getInstance().font);
        if (!(mouseY < (double)(n + 9 + 5))) return false;
        return true;
    }
}

