/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.gui.config;

import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.client.gui.config.ConfigButton;
import com.momosoftworks.coldsweat.client.gui.config.ConfigImageWidget;
import com.momosoftworks.coldsweat.client.gui.config.ConfigLabel;
import com.momosoftworks.coldsweat.client.gui.config.ConfigScreen;
import com.momosoftworks.coldsweat.client.gui.config.ConfigSliderButton;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public abstract class AbstractConfigPage
extends Screen {
    static int MOUSE_STILL_TIMER = 0;
    static int TOOLTIP_DELAY = 5;
    private final Screen parentScreen;
    public Map<String, Pair<List<GuiEventListener>, Boolean>> widgetBatches = new HashMap<String, Pair<List<GuiEventListener>, Boolean>>();
    public Map<String, List<Component>> tooltips = new HashMap<String, List<Component>>();
    protected int rightSideLength = 0;
    protected int leftSideLength = 0;
    private static final int TITLE_HEIGHT = 16;
    private static final int BOTTOM_BUTTON_HEIGHT_OFFSET = 26;
    private static final int BOTTOM_BUTTON_WIDTH = 150;
    public static Minecraft MINECRAFT = Minecraft.getInstance();
    private static final String GUI_TEXTURE_PATH = "config/";
    public static final ResourceLocation CLIENTSIDE_ICON_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/gui/sprites/config/clientside_icon.png");
    public static final ResourceLocation DIVIDER_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/gui/sprites/config/divider.png");
    public static final WidgetSprites CONFIG_BUTTON_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"config/config_button"), ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"config/config_button_disabled"), ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"config/config_button_focus"));
    public static final WidgetSprites DIRECTION_RIGHT_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"config/direction_panel_right"), ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"config/direction_panel_right_focus"));
    public static final WidgetSprites DIRECTION_LEFT_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"config/direction_panel_left"), ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"config/direction_panel_left_focus"));
    public static final WidgetSprites DIRECTION_UP_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"config/direction_panel_up"), ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"config/direction_panel_up_focus"));
    public static final WidgetSprites DIRECTION_DOWN_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"config/direction_panel_down"), ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"config/direction_panel_down_focus"));
    public static final WidgetSprites DIRECTION_RESET_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"config/direction_panel_reset"), ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"config/direction_panel_reset_focus"));
    public static final WidgetSprites DIRECTION_RESET_SMALL_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"config/direction_panel_reset_small"), ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"config/direction_panel_reset_small_focus"));
    public static final WidgetSprites DIRECTION_VISIBILITY_ON_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"config/direction_panel_visibility_on"), ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"config/direction_panel_visibility_on_focus"));
    public static final WidgetSprites DIRECTION_VISIBILITY_OFF_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"config/direction_panel_visibility_off"), ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"config/direction_panel_visibility_off_focus"));
    public static final WidgetSprites NEXT_PAGE_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"config/next_page"), ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"config/next_page_focus"));
    public static final WidgetSprites PREV_PAGE_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"config/prev_page"), ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"config/prev_page_focus"));
    public static final WidgetSprites SLIDER_BAR_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"config/slider_bar"), ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"config/slider_bar_focus"));
    public static final WidgetSprites SLIDER_HEAD_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"config/slider_head"), ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"config/slider_head_focus"));
    ImageButton nextNavButton;
    ImageButton prevNavButton;

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Pre event) {
        ++MOUSE_STILL_TIMER;
    }

    public void mouseMoved(double mouseX, double mouseY) {
        MOUSE_STILL_TIMER = 0;
        super.mouseMoved(mouseX, mouseY);
    }

    @SubscribeEvent
    public static void onMouseClicked(ScreenEvent.MouseButtonPressed.Post event) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof AbstractConfigPage) {
            AbstractConfigPage screen2 = (AbstractConfigPage)screen;
            screen2.children().forEach(child -> {
                AbstractWidget widget;
                if (child instanceof AbstractWidget && !(widget = (AbstractWidget)child).isMouseOver(event.getMouseX(), event.getMouseY())) {
                    widget.setFocused(false);
                }
            });
        }
    }

    public AbstractConfigPage(Screen parentScreen) {
        super((Component)Component.translatable((String)"cold_sweat.config.title"));
        this.parentScreen = parentScreen;
    }

    public AbstractConfigPage(Screen parentScreen, Component title) {
        super(title);
        this.parentScreen = parentScreen;
    }

    public abstract Component sectionOneTitle();

    @Nullable
    public abstract Component sectionTwoTitle();

    public boolean showNavigation() {
        return true;
    }

    protected void addEmptySpace(Side side, double height) {
        if (side == Side.LEFT) {
            this.leftSideLength += (int)(25.0 * height);
        } else {
            this.rightSideLength += (int)(25.0 * height);
        }
    }

    protected void addLabel(String id, Side side, String text, int color) {
        int labelX = side == Side.LEFT ? this.width / 2 - 185 : this.width / 2 + 51;
        int labelY = this.height / 4 + (side == Side.LEFT ? this.leftSideLength : this.rightSideLength);
        ConfigLabel label = new ConfigLabel(id, text, labelX, labelY, color);
        this.addWidgetBatch(id, List.of(label), true);
        if (side == Side.LEFT) {
            Objects.requireNonNull(this.font);
            this.leftSideLength += 9 + 4;
        } else {
            Objects.requireNonNull(this.font);
            this.rightSideLength += 9 + 4;
        }
    }

    protected void addClientsideIcon(int x, int y) {
        this.addRenderableOnly((Renderable)new ConfigImageWidget(CLIENTSIDE_ICON_TEXTURE, x, y, 16, 15, 0, 0));
    }

    protected void addLabel(String id, Side side, String text) {
        this.addLabel(id, side, text, 0xFFFFFF);
    }

    protected void addButton(String id, Side side, Supplier<Component> dynamicLabel, Consumer<Button> onClick, boolean requireOP, final boolean setsCustomDifficulty, boolean clientside, Component ... tooltip) {
        Component label = dynamicLabel.get();
        boolean shouldBeActive = !requireOP || AbstractConfigPage.MINECRAFT.player == null || AbstractConfigPage.MINECRAFT.player.hasPermissions(2);
        int widgetX = this.width / 2 + (side == Side.LEFT ? -179 : 56);
        int widgetY = this.height / 4 - 8 + (side == Side.LEFT ? this.leftSideLength : this.rightSideLength);
        int buttonWidth = 152 + Math.max(0, this.font.width((FormattedText)label) - 140);
        ConfigButton button = new ConfigButton(this, widgetX, widgetY, buttonWidth, 20, label, button1 -> {
            onClick.accept(button1);
            button1.setMessage((Component)dynamicLabel.get());
        }){

            @Override
            public boolean setsCustomDifficulty() {
                return setsCustomDifficulty;
            }
        };
        button.active = shouldBeActive;
        if (clientside) {
            this.createClientsideIcon(id, widgetX - 16, widgetY + 4);
        }
        ArrayList<Component> tooltipList = new ArrayList<Component>(Arrays.asList(tooltip));
        if (clientside) {
            tooltipList.add((Component)Component.translatable((String)"cold_sweat.config.clientside_warning").withStyle(ChatFormatting.DARK_GRAY));
        }
        this.setTooltip(id, tooltipList);
        this.addWidgetBatch(id, List.of(button), shouldBeActive);
        if (side == Side.LEFT) {
            this.leftSideLength += 25;
        } else {
            this.rightSideLength += 25;
        }
    }

    protected void addDecimalInput(String id, Side side, Component label, final Consumer<Double> onEdited, Consumer<EditBox> onInit, boolean requireOP, final boolean setsCustomDifficulty, boolean clientside, Component ... tooltip) {
        boolean shouldBeActive = !requireOP || AbstractConfigPage.MINECRAFT.player == null || AbstractConfigPage.MINECRAFT.player.hasPermissions(2);
        int labelOffset = this.font.width(label.getString()) > 90 ? this.font.width(label.getString()) - 86 : 0;
        int boxWidth = Math.max(51 - labelOffset, 30);
        int widgetX = this.width / 2 + (side == Side.LEFT ? -80 : 155);
        int widgetY = this.height / 4 + (side == Side.LEFT ? this.leftSideLength : this.rightSideLength) - 2;
        EditBox textBox = new EditBox(this, this.font, widgetX + labelOffset, widgetY - 6, boxWidth, 18, (Component)Component.literal((String)"")){

            public void onEdit() {
                CSMath.tryCatch(() -> {
                    onEdited.accept(Double.parseDouble(this.getValue()));
                    if (setsCustomDifficulty) {
                        ConfigSettings.DIFFICULTY.set(ConfigSettings.Difficulty.CUSTOM);
                    }
                });
            }

            public void insertText(String text) {
                super.insertText(text);
                this.onEdit();
            }

            public void deleteWords(int i) {
                super.deleteWords(i);
                this.onEdit();
            }

            public void deleteChars(int i) {
                super.deleteChars(i);
                this.onEdit();
            }
        };
        textBox.setEditable(shouldBeActive);
        onInit.accept(textBox);
        textBox.setValue(ConfigScreen.TWO_PLACES.format(Double.parseDouble(textBox.getValue())));
        ConfigLabel configLabel = new ConfigLabel(id, label.getString(), widgetX - 95, widgetY, shouldBeActive ? 0xFFFFFF : 0x808080);
        if (clientside) {
            this.createClientsideIcon(id, widgetX - 115, widgetY - 2);
        }
        ArrayList<Component> tooltipList = new ArrayList<Component>(Arrays.asList(tooltip));
        if (clientside) {
            tooltipList.add((Component)Component.translatable((String)"cold_sweat.config.clientside_warning").withStyle(ChatFormatting.DARK_GRAY));
        }
        this.setTooltip(id, tooltipList);
        this.addWidgetBatch(id, List.of(textBox, configLabel), shouldBeActive);
        if (side == Side.LEFT) {
            this.leftSideLength += 25;
        } else {
            this.rightSideLength += 25;
        }
    }

    protected void addDirectionPanel(String id, Side side, Component label, Consumer<Integer> leftRightPressed, Consumer<Integer> upDownPressed, Runnable reset, Supplier<Boolean> hide, boolean requireOP, boolean setsCustomDifficulty, boolean clientside, boolean canHide, Component ... tooltip) {
        int widgetX = this.width / 2 + (side == Side.LEFT ? -97 : 136);
        int widgetY = this.height / 4 + (side == Side.LEFT ? this.leftSideLength : this.rightSideLength);
        boolean shouldBeActive = !requireOP || AbstractConfigPage.MINECRAFT.player == null || AbstractConfigPage.MINECRAFT.player.hasPermissions(2);
        int labelWidth = this.font.width(label.getString());
        int labelOffset = labelWidth > 84 ? labelWidth - 84 : 0;
        ArrayList<GuiEventListener> widgetBatch = new ArrayList<GuiEventListener>();
        ImageButton leftButton = new ImageButton(widgetX + labelOffset, widgetY - 8, 14, 20, DIRECTION_LEFT_SPRITES, button -> {
            leftRightPressed.accept(-1);
            if (setsCustomDifficulty) {
                ConfigSettings.DIFFICULTY.set(ConfigSettings.Difficulty.CUSTOM);
            }
        });
        leftButton.active = shouldBeActive;
        widgetBatch.add((GuiEventListener)leftButton);
        ImageButton upButton = new ImageButton(widgetX + 14 + labelOffset, widgetY - 8, 20, 10, DIRECTION_UP_SPRITES, button -> {
            upDownPressed.accept(-1);
            if (setsCustomDifficulty) {
                ConfigSettings.DIFFICULTY.set(ConfigSettings.Difficulty.CUSTOM);
            }
        });
        upButton.active = shouldBeActive;
        widgetBatch.add((GuiEventListener)upButton);
        ImageButton downButton = new ImageButton(widgetX + 14 + labelOffset, widgetY + 2, 20, 10, DIRECTION_DOWN_SPRITES, button -> {
            upDownPressed.accept(1);
            if (setsCustomDifficulty) {
                ConfigSettings.DIFFICULTY.set(ConfigSettings.Difficulty.CUSTOM);
            }
        });
        downButton.active = shouldBeActive;
        widgetBatch.add((GuiEventListener)downButton);
        ImageButton rightButton = new ImageButton(widgetX + 34 + labelOffset, widgetY - 8, 14, 20, DIRECTION_RIGHT_SPRITES, button -> {
            leftRightPressed.accept(1);
            if (setsCustomDifficulty) {
                ConfigSettings.DIFFICULTY.set(ConfigSettings.Difficulty.CUSTOM);
            }
        });
        rightButton.active = shouldBeActive;
        widgetBatch.add((GuiEventListener)rightButton);
        ImageButton resetButton = new ImageButton(widgetX + 52 + labelOffset, widgetY - 8, 20, canHide ? 10 : 20, canHide ? DIRECTION_RESET_SMALL_SPRITES : DIRECTION_RESET_SPRITES, button -> {
            reset.run();
            if (setsCustomDifficulty) {
                ConfigSettings.DIFFICULTY.set(ConfigSettings.Difficulty.CUSTOM);
            }
        });
        resetButton.active = shouldBeActive;
        widgetBatch.add((GuiEventListener)resetButton);
        if (canHide) {
            ImageButton hideButton = new ImageButton(widgetX + 52 + labelOffset, widgetY + 2, 20, 10, DIRECTION_VISIBILITY_ON_SPRITES, button -> {
                if (setsCustomDifficulty) {
                    ConfigSettings.DIFFICULTY.set(ConfigSettings.Difficulty.CUSTOM);
                }
                AbstractConfigPage.setButtonSprites((ImageButton)button, (Boolean)hide.get() != false ? DIRECTION_VISIBILITY_OFF_SPRITES : DIRECTION_VISIBILITY_ON_SPRITES);
            });
            hide.get();
            AbstractConfigPage.setButtonSprites(hideButton, hide.get() != false ? DIRECTION_VISIBILITY_OFF_SPRITES : DIRECTION_VISIBILITY_ON_SPRITES);
            hideButton.active = shouldBeActive;
            widgetBatch.add((GuiEventListener)hideButton);
        }
        ConfigLabel configLabel = new ConfigLabel(id, label.getString(), widgetX - 79, widgetY, shouldBeActive ? 0xFFFFFF : 0x808080);
        if (clientside) {
            this.createClientsideIcon(id, widgetX - 96, widgetY - 8 + 5);
        }
        widgetBatch.add(configLabel);
        ArrayList<Component> tooltipList = new ArrayList<Component>(Arrays.asList(tooltip));
        if (clientside) {
            tooltipList.add((Component)Component.translatable((String)"cold_sweat.config.clientside_warning").withStyle(ChatFormatting.DARK_GRAY));
        }
        this.setTooltip(id, tooltipList);
        this.addWidgetBatch(id, widgetBatch, shouldBeActive);
        if (side == Side.LEFT) {
            this.leftSideLength = (int)((double)this.leftSideLength + 26.25);
        } else {
            this.rightSideLength = (int)((double)this.rightSideLength + 26.25);
        }
    }

    protected void addSliderButton(String id, Side side, final Supplier<Component> dynamicLabel, final double minVal, final double maxVal, final BiConsumer<Double, ConfigSliderButton> onChanged, Consumer<ConfigSliderButton> onInit, boolean requireOP, boolean clientside, Component ... tooltip) {
        Component label = dynamicLabel.get();
        boolean shouldBeActive = !requireOP || this.minecraft.player == null || this.minecraft.player.hasPermissions(2);
        int widgetX = this.width / 2 + (side == Side.LEFT ? -179 : 56);
        int widgetY = this.height / 4 - 8 + (side == Side.LEFT ? this.leftSideLength : this.rightSideLength);
        int buttonWidth = 152 + Math.max(0, this.font.width((FormattedText)label) - 140);
        ConfigSliderButton sliderButton = new ConfigSliderButton(this, widgetX, widgetY, buttonWidth, 20, label, 0.0){

            @Override
            protected void updateMessage() {
                this.setMessage((Component)dynamicLabel.get());
                onChanged.accept(CSMath.blend(minVal, maxVal, CSMath.truncate(this.value, 2), 0.0, 1.0), this);
            }

            @Override
            protected void applyValue() {
                this.updateMessage();
            }
        };
        sliderButton.active = shouldBeActive;
        onInit.accept(sliderButton);
        if (clientside) {
            this.createClientsideIcon(id, widgetX - 16, widgetY + 4);
        }
        ArrayList<Component> tooltipList = new ArrayList<Component>(Arrays.asList(tooltip));
        if (clientside) {
            tooltipList.add((Component)Component.translatable((String)"cold_sweat.config.clientside_warning").withStyle(ChatFormatting.DARK_GRAY));
        }
        this.setTooltip(id, tooltipList);
        this.addWidgetBatch(id, List.of(sliderButton), shouldBeActive);
        if (side == Side.LEFT) {
            this.leftSideLength += 25;
        } else {
            this.rightSideLength += 25;
        }
    }

    protected void createClientsideIcon(String id, int x, int y) {
        ConfigImageWidget icon = new ConfigImageWidget(CLIENTSIDE_ICON_TEXTURE, x, y, 12, 12, 0, 0);
        this.addRenderableOnly((Renderable)icon);
        String iconId = String.format("%s_client", id);
        this.setTooltip(iconId, List.of(Component.translatable((String)"cold_sweat.config.clientside_warning")));
        this.addWidgetBatch(iconId, List.of(icon), true);
    }

    protected void init() {
        MOUSE_STILL_TIMER = 0;
        this.setDragging(false);
        this.leftSideLength = 0;
        this.rightSideLength = 0;
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"gui.done"), button -> this.onClose()).pos(this.width / 2 - 75, this.height - 26).size(150, 20).createNarration(button -> MutableComponent.create((ComponentContents)((MutableComponent)button.get()).getContents())).build());
        if (this.showNavigation()) {
            this.nextNavButton = new ImageButton(this.width - 32, 12, 20, 20, NEXT_PAGE_SPRITES, button -> MINECRAFT.setScreen(ConfigScreen.getPage(++ConfigScreen.CURRENT_PAGE, this.parentScreen)));
            if (ConfigScreen.CURRENT_PAGE < ConfigScreen.LAST_PAGE) {
                this.addRenderableWidget((GuiEventListener)this.nextNavButton);
            }
            this.prevNavButton = new ImageButton(this.width - 76, 12, 20, 20, PREV_PAGE_SPRITES, button -> MINECRAFT.setScreen(ConfigScreen.getPage(--ConfigScreen.CURRENT_PAGE, this.parentScreen)));
            if (ConfigScreen.CURRENT_PAGE > ConfigScreen.FIRST_PAGE) {
                this.addRenderableWidget((GuiEventListener)this.prevNavButton);
            }
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        Font font = this.font;
        graphics.drawCenteredString(this.font, this.title.getString(), this.width / 2, 16, 0xFFFFFF);
        if (this.showNavigation()) {
            graphics.drawString(this.font, (Component)Component.literal((String)(ConfigScreen.CURRENT_PAGE + 1 + "/" + (ConfigScreen.LAST_PAGE + 1))), this.width - 53, 18, 0xFFFFFF, true);
        }
        graphics.drawString(this.font, this.sectionOneTitle(), this.width / 2 - 204, this.height / 4 - 28, 0xFFFFFF, true);
        graphics.blit(DIVIDER_TEXTURE, this.width / 2 - 202, this.height / 4 - 16, 0, 0, 1, 154);
        if (this.sectionTwoTitle() != null) {
            graphics.drawString(this.font, this.sectionTwoTitle(), this.width / 2 + 32, this.height / 4 - 28, 0xFFFFFF, true);
            graphics.blit(DIVIDER_TEXTURE, this.width / 2 + 34, this.height / 4 - 16, 0, 0, 1, 154);
        }
        if (this.isDragging()) {
            MOUSE_STILL_TIMER = 0;
        }
        if (MOUSE_STILL_TIMER < TOOLTIP_DELAY) {
            return;
        }
        for (Map.Entry<String, Pair<List<GuiEventListener>, Boolean>> entry : this.widgetBatches.entrySet()) {
            List<Component> tooltipList;
            String id = entry.getKey();
            List widgets = (List)entry.getValue().getFirst();
            boolean enabled = (Boolean)entry.getValue().getSecond();
            int minX = 0;
            int minY = 0;
            int maxX = 0;
            int maxY = 0;
            for (GuiEventListener listener : widgets) {
                if (!(listener instanceof AbstractWidget)) continue;
                AbstractWidget widget = (AbstractWidget)listener;
                if (minX == 0 || widget.getX() < minX) {
                    minX = widget.getX();
                }
                if (minY == 0 || widget.getY() < minY) {
                    minY = widget.getY();
                }
                if (maxX == 0 || widget.getX() + widget.getWidth() > maxX) {
                    maxX = widget.getX() + widget.getWidth();
                }
                if (maxY != 0 && widget.getY() + widget.getHeight() <= maxY) continue;
                maxY = widget.getY() + widget.getHeight();
            }
            if (!CSMath.betweenInclusive(mouseX, minX, maxX) || !CSMath.betweenInclusive(mouseY, minY, maxY)) continue;
            List<Object> list = tooltipList = enabled ? this.tooltips.get(id) : List.of(Component.translatable((String)"cold_sweat.config.require_op").withStyle(ChatFormatting.RED));
            if (tooltipList == null || tooltipList.isEmpty()) break;
            graphics.renderTooltip(font, tooltipList, Optional.empty(), mouseX, mouseY);
            break;
        }
    }

    protected void addWidgetBatch(String id, List<GuiEventListener> elements, boolean enabled) {
        for (GuiEventListener element : elements) {
            if (!(element instanceof Renderable)) continue;
            Renderable widget = (Renderable)element;
            this.addRenderableWidget((GuiEventListener)((NarratableEntry)widget));
        }
        this.widgetBatches.put(id, (Pair<List<GuiEventListener>, Boolean>)Pair.of(elements, (Object)enabled));
    }

    public List<GuiEventListener> getWidgetBatch(String id) {
        return (List)this.widgetBatches.get(id).getFirst();
    }

    protected void setTooltip(String id, List<Component> tooltip) {
        ArrayList<MutableComponent> wrappedTooltip = new ArrayList<MutableComponent>();
        for (Component component : tooltip) {
            List wrappedText = this.font.getSplitter().splitLines((FormattedText)component, 300, component.getStyle());
            wrappedTooltip.addAll(wrappedText.stream().map(text -> Component.literal((String)text.getString()).withStyle(component.getStyle())).toList());
        }
        this.tooltips.put(id, wrappedTooltip);
    }

    public static void setButtonSprites(ImageButton button, WidgetSprites sprites) {
        Field spritesField = ObfuscationReflectionHelper.findField(ImageButton.class, (String)"sprites");
        spritesField.setAccessible(true);
        try {
            spritesField.set(button, sprites);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onClose() {
        MINECRAFT.setScreen(this.parentScreen);
        ConfigScreen.saveConfig();
    }

    public MutableComponent getToggleButtonText(MutableComponent text, boolean on) {
        return text.append(": ").append(on ? CommonComponents.OPTION_ON : CommonComponents.OPTION_OFF);
    }

    public <T extends Enum<T>> MutableComponent getEnumButtonText(MutableComponent text, T value) {
        return text.append(": ").append((Component)Component.translatable((String)((StringRepresentable)value).getSerializedName()));
    }

    public <T extends Enum<T>> T getNextCycle(T current) {
        Enum[] values = (Enum[])current.getDeclaringClass().getEnumConstants();
        int index = (current.ordinal() + 1) % values.length;
        return (T)values[index];
    }

    public MutableComponent getSliderPercentageText(MutableComponent message, double value, double offAt) {
        return message.append(": ").append((Component)(Double.compare(offAt, value) != 0 ? Component.literal((String)((int)(value * 100.0) + "%")) : Component.literal((String)CommonComponents.OPTION_OFF.getString())));
    }

    public MutableComponent getSliderText(MutableComponent message, int value, int min, int max, int offAt) {
        return message.append(": ").append((Component)((value > min || value < max) && value != offAt ? Component.literal((String)("" + value)) : Component.literal((String)CommonComponents.OPTION_OFF.getString())));
    }

    public MutableComponent getSliderText(MutableComponent message, double value, double min, double max, double offAt) {
        return message.append(": ").append((Component)((value > min || value < max) && Double.compare(value, offAt) != 0 ? Component.literal((String)("" + CSMath.truncate(value, 1))) : Component.literal((String)CommonComponents.OPTION_OFF.getString())));
    }

    public static enum Side {
        LEFT,
        RIGHT;

    }
}

