/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.momosoftworks.coldsweat.client.gui.AbstractHearthScreen;
import com.momosoftworks.coldsweat.common.blockentity.HearthBlockEntity;
import com.momosoftworks.coldsweat.common.container.HearthContainer;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class HearthScreen
extends AbstractHearthScreen<HearthContainer> {
    private static final ResourceLocation HEARTH_GUI = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/gui/screen/hearth_gui.png");

    @Override
    HearthBlockEntity getBlockEntity() {
        return ((HearthContainer)this.menu).te;
    }

    public HearthScreen(HearthContainer screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, (Component)Component.translatable((String)"container.cold_sweat.hearth"));
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.blit(HEARTH_GUI, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        int hotFuel = (int)((double)((HearthContainer)this.menu).getHotFuel() / 27.7);
        int coldFuel = (int)((double)((HearthContainer)this.menu).getColdFuel() / 27.7);
        graphics.blit(HEARTH_GUI, this.leftPos + 61, this.topPos + 66 - hotFuel, 176.0f, (float)(36 - hotFuel), 12, hotFuel, 256, 256);
        graphics.blit(HEARTH_GUI, this.leftPos + 103, this.topPos + 66 - coldFuel, 188.0f, (float)(36 - coldFuel), 12, coldFuel, 256, 256);
        if (!ConfigSettings.SMART_HEARTH.get().booleanValue()) {
            boolean sidePowered = ((HearthContainer)this.menu).te.isCoolingOn();
            boolean backPowered = ((HearthContainer)this.menu).te.isHeatingOn();
            graphics.blit(HEARTH_GUI, this.leftPos + 60, this.topPos + 21, 176.0f, backPowered ? 60.0f : 68.0f, 14, 8, 256, 256);
            graphics.blit(HEARTH_GUI, this.leftPos + 102, this.topPos + 21, 190.0f, sidePowered ? 60.0f : 68.0f, 14, 8, 256, 256);
            if (CSMath.betweenInclusive(mouseX, this.leftPos + 56, this.leftPos + 75) && CSMath.betweenInclusive(mouseY, this.topPos + 17, this.topPos + 29)) {
                this.setTooltipForNextRenderPass((Component)Component.translatable((String)(backPowered ? "gui.cold_sweat.hearth.powered" : "gui.cold_sweat.hearth.unpowered")));
            }
            if (CSMath.betweenInclusive(mouseX, this.leftPos + 99, this.leftPos + 117) && CSMath.betweenInclusive(mouseY, this.topPos + 17, this.topPos + 29)) {
                this.setTooltipForNextRenderPass((Component)Component.translatable((String)(sidePowered ? "gui.cold_sweat.hearth.powered" : "gui.cold_sweat.hearth.unpowered")));
            }
        }
    }
}

