/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.momosoftworks.coldsweat.client.gui.AbstractHearthScreen;
import com.momosoftworks.coldsweat.common.blockentity.HearthBlockEntity;
import com.momosoftworks.coldsweat.common.container.BoilerContainer;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class BoilerScreen
extends AbstractHearthScreen<BoilerContainer> {
    private static final ResourceLocation BOILER_GUI = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/gui/screen/boiler_gui.png");

    @Override
    HearthBlockEntity getBlockEntity() {
        return ((BoilerContainer)this.menu).te;
    }

    public BoilerScreen(BoilerContainer screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        this.imageWidth = 176;
        this.imageHeight = 172;
        this.inventoryLabelY = this.imageHeight - 94;
        this.titleLabelX = this.leftPos + this.imageWidth / 2 - Minecraft.getInstance().font.width((FormattedText)this.getTitle()) / 2;
    }

    @Override
    public void init() {
        super.init();
        if (this.particleButton != null) {
            this.particleButton.setX(this.leftPos + 151);
            this.particleButton.setY(this.topPos + 63);
        }
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.blit(BOILER_GUI, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        graphics.blit(BOILER_GUI, this.leftPos + 109, this.topPos + 63, 176.0f, 0.0f, (int)((double)((BoilerContainer)this.menu).getFuel() / 31.25), 14, 256, 256);
        if (!ConfigSettings.SMART_HEARTH.get().booleanValue() && ((BoilerContainer)this.menu).te.hasSmokeStack()) {
            boolean powered = ((BoilerContainer)this.menu).te.isHeatingOn();
            graphics.blit(BOILER_GUI, this.leftPos + 117, this.topPos + 78, 176.0f, powered ? 14.0f : 22.0f, 14, 8, 256, 256);
            if (CSMath.betweenInclusive(mouseX, this.leftPos + 114, this.leftPos + 132) && CSMath.betweenInclusive(mouseY, this.topPos + 78, this.topPos + 86)) {
                this.setTooltipForNextRenderPass((Component)Component.translatable((String)(powered ? "gui.cold_sweat.hearth.powered" : "gui.cold_sweat.hearth.unpowered")));
            }
        }
    }
}

